/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.facet.Series;
import oracle.dbtools.raptor.metrics.facet.TimeSeriesMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.NumberDataObject;

@DefaultProperty(value="series")
public class ListedTimeSeriesMonitor
extends TimeSeriesMonitor {
    private final List<TimeSeriesMonitor.SeriesSource> seriesSources = new ArrayList<TimeSeriesMonitor.SeriesSource>();
    private final ObservableList<Series> series = FXCollections.observableArrayList();

    public ListedTimeSeriesMonitor() {
        this.init(new Listener());
    }

    public ObservableList<Series> getSeries() {
        return this.series;
    }

    @Override
    public List<DataObject<?>> getDataObjects(Context context) {
        ArrayList arrayList = new ArrayList();
        for (Series series : this.series) {
            NumberDataObject numberDataObject = series.getItem();
            arrayList.add(numberDataObject);
        }
        return arrayList;
    }

    @Override
    protected List<TimeSeriesMonitor.SeriesSource> getSeriesSources() {
        return this.seriesSources;
    }

    protected class Listener
    extends TimeSeriesMonitor.Listener {
        protected Listener() {
            super(ListedTimeSeriesMonitor.this);
        }

        @Override
        public void onOpen(Context context) {
            for (Series series : ListedTimeSeriesMonitor.this.series) {
                NumberDataObject numberDataObject = series.getItem();
                TimeSeriesMonitor.SeriesSource seriesSource = new TimeSeriesMonitor.SeriesSource(series.getName(), (ObservableValue<? extends Number>)numberDataObject.valueProperty());
                ListedTimeSeriesMonitor.this.seriesSources.add(seriesSource);
            }
            super.onOpen(context);
        }
    }
}

