/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.chart.NumberAxis;
import oracle.dbtools.raptor.metrics.facet.PointAxisProperties;

public abstract class HistoryAxisProperties
extends PointAxisProperties {
    private final DoubleProperty lowerBound = new SimpleDoubleProperty();
    private final DoubleProperty upperBound = new SimpleDoubleProperty();
    private final DoubleProperty tickUnit = new SimpleDoubleProperty();

    @Override
    void initialize(NumberAxis numberAxis) {
        super.initialize(numberAxis);
        numberAxis.autoRangingProperty().bind((ObservableValue)this.falseValue);
        numberAxis.tickUnitProperty().bind((ObservableValue)this.tickUnit);
        numberAxis.upperBoundProperty().bind((ObservableValue)this.upperBound);
        numberAxis.lowerBoundProperty().bind((ObservableValue)this.lowerBound);
        this.tickUnit.set(1.0);
        this.upperBound.set(1.0);
        this.lowerBound.set(0.0);
    }

    @Override
    void update(double d, double d2) {
        int n = this.getMaximumTickIntervalCount();
        double d3 = (d2 - d) / (double)n;
        double d4 = this.getRoundedTickUnit(d3);
        int n2 = d4 == d3 ? n : (int)(1.0 + (d2 - d) / d4);
        this.tickUnit.set(d4);
        this.upperBound.set(d2);
        this.lowerBound.set(d2 - d4 * (double)n2);
    }
}

