/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.actionobject.ChangeHandler;
import oracle.dbtools.raptor.metrics.facet.Decorator;
import oracle.dbtools.raptor.metrics.facet.Dependency;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.VarDataObject;

@DefaultProperty(value="dependencies")
public class HandlerBinding
implements Decorator {
    private ObjectBinding<Object> binding;
    private int bindingValue = 0;
    private final ObjectProperty<ChangeHandler<?>> handlerProperty = new SimpleObjectProperty((Object)this, "handler");
    private final ObservableList<Dependency> dependencies = FXCollections.observableArrayList();

    public HandlerBinding() {
        this.init(new Listener());
    }

    public ChangeHandler<?> getHandler() {
        return (ChangeHandler)this.handlerProperty.get();
    }

    public void setHandler(ChangeHandler<?> changeHandler) {
        this.handlerProperty.set(changeHandler);
    }

    public ObjectProperty<ChangeHandler<?>> handlerProperty() {
        return this.handlerProperty;
    }

    public ObservableList<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Class<?> getBindToClass() {
        return Object.class;
    }

    @Override
    public Class<? extends Facet> getBindAsClass() {
        return HandlerBinding.class;
    }

    private int getBindingValue() {
        return this.bindingValue++;
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            Observable[] observableArray = new Observable[HandlerBinding.this.dependencies.size()];
            int n = 0;
            for (Dependency dependency : HandlerBinding.this.dependencies) {
                VarDataObject<?> varDataObject = dependency.getObject();
                observableArray[n++] = varDataObject.valueProperty();
            }
            HandlerBinding.this.binding = Bindings.createObjectBinding(() -> HandlerBinding.this.getBindingValue(), (Observable[])observableArray);
            ChangeHandler<?> changeHandler = HandlerBinding.this.getHandler();
            HandlerBinding.this.binding.addListener((ChangeListener)changeHandler);
        }

        @Override
        public void onClose(Context context) {
            ChangeHandler<?> changeHandler = HandlerBinding.this.getHandler();
            HandlerBinding.this.binding.removeListener(changeHandler);
            HandlerBinding.this.binding.dispose();
        }
    }
}

