/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.ContextMenuEvent;
import oracle.dbtools.raptor.metrics.facet.Augmentor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

@DefaultProperty(value="contextMenu")
public class ContextMenuTray
implements Augmentor {
    private final ObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty();

    public ContextMenuTray() {
        this.init(new Listener());
    }

    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenuProperty.get();
    }

    public void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty.set((Object)contextMenu);
    }

    public ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenuProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return Node.class;
    }

    @Override
    public Class<? extends Facet> getBindAsClass() {
        return ContextMenuTray.class;
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            Node node = context.getLinkedTarget(Node.class, ContextMenuTray.this);
            ContextMenu contextMenu = ContextMenuTray.this.getContextMenu();
            node.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, contextMenuEvent -> {
                contextMenu.show(node, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                contextMenuEvent.consume();
            });
        }
    }
}

