/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Screen;
import oracle.dbtools.raptor.metrics.facet.Augmentor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

public abstract class AbstractZoomPanObject
implements Augmentor {
    private ScrollPane scrollPane;
    private Region managedPanel;
    private boolean panZoomMode;
    private boolean zooming;
    private double dragLogScaleInitial;
    private int dragInitial;
    private int deltaDrag;
    private int deltaDragThreshold;
    private double zoomFactor;
    private double fitFactor;
    private boolean fitToSize;
    private ScrollPane.ScrollBarPolicy hbarPolicy;
    private ScrollPane.ScrollBarPolicy vbarPolicy;
    private double lastScale = -1.0;
    private Bounds lastPortBounds = null;
    private EventHandler<MouseEvent> dragDetectedHandler;
    private EventHandler<MouseEvent> mouseDraggedHandler;
    private EventHandler<MouseEvent> mouseReleasedHandler;
    private final BooleanProperty viewportTrackingDisabledProperty = new SimpleBooleanProperty((Object)this, "viewportTrackingDisabled", false);
    private final DoubleProperty minInitPercentProperty = new SimpleDoubleProperty((Object)this, "minInitPercent");
    private final BooleanProperty contentSizedProperty = new SimpleBooleanProperty((Object)this, "contentSized", true);

    public AbstractZoomPanObject() {
        this.init(new Listener());
    }

    public boolean isViewportTrackingDisabled() {
        return this.viewportTrackingDisabledProperty.get();
    }

    public void setViewportTrackingDisabled(boolean bl) {
        this.viewportTrackingDisabledProperty.set(bl);
    }

    public BooleanProperty viewportTrackingDisabledProperty() {
        return this.viewportTrackingDisabledProperty;
    }

    public double getMinInitPercent() {
        return this.minInitPercentProperty.get();
    }

    public void setMinInitPercent(double d) {
        this.minInitPercentProperty.set(d);
    }

    public DoubleProperty minInitPercentProperty() {
        return this.minInitPercentProperty;
    }

    public boolean isContentSized() {
        return this.contentSizedProperty.get();
    }

    public void setContentSized(boolean bl) {
        this.contentSizedProperty.set(bl);
    }

    public BooleanProperty contentSizedProperty() {
        return this.contentSizedProperty;
    }

    public void panLeft() {
        double d = this.scrollPane.getHvalue();
        d = d < 0.9 ? (d += 0.1) : 1.0;
        this.scrollPane.setHvalue(d);
    }

    public void panRight() {
        double d = this.scrollPane.getHvalue();
        d = d > 0.1 ? (d -= 0.1) : 0.0;
        this.scrollPane.setHvalue(d);
    }

    public void panUp() {
        double d = this.scrollPane.getVvalue();
        d = d < 0.9 ? (d += 0.1) : 1.0;
        this.scrollPane.setVvalue(d);
    }

    public void panDown() {
        double d = this.scrollPane.getVvalue();
        d = d > 0.1 ? (d -= 0.1) : 0.0;
        this.scrollPane.setVvalue(d);
    }

    public void zoomIn() {
        this.adjustZoomFactor(0.05);
        this.scaleContent();
    }

    public void zoomOut() {
        this.adjustZoomFactor(-0.05);
        this.scaleContent();
    }

    public void zoomToFit() {
        Bounds bounds = this.scrollPane.getViewportBounds();
        this.zoomFactor = 1.0;
        this.fitFactor = this.getFitFactor(this.managedPanel, bounds.getWidth(), bounds.getHeight());
        this.setFitToSize(true);
        this.scaleContent();
    }

    public void toggleMousePanZoom() {
        this.panZoomMode = !this.panZoomMode;
        this.scrollPane.setPannable(this.panZoomMode);
        this.scrollPane.getContent().setMouseTransparent(this.panZoomMode);
        Node node = this.scrollPane.lookup(".viewport");
        if (this.panZoomMode) {
            node.setCursor(Cursor.MOVE);
        } else {
            node.setCursor(Cursor.DEFAULT);
        }
    }

    @Override
    public Class<?> getBindToClass() {
        return Region.class;
    }

    @Override
    public Class<? extends Facet> getBindAsClass() {
        return AbstractZoomPanObject.class;
    }

    protected void initContent(Region region) {
    }

    protected abstract double getFitFactor(Region var1, double var2, double var4);

    private void setInitZoom(Region region, double d, double d2) {
        double d3 = this.getMinInitPercent();
        if (d3 > 0.0 && d3 <= 100.0) {
            double d4 = d3 / 100.0;
            double d5 = d4 * region.getPrefWidth();
            double d6 = d4 * region.getPrefHeight();
            if (d < d5 || d2 < d6) {
                this.zoomFactor = Math.max(d5 / d, d6 / d2);
                this.setFitToSize(false);
            } else {
                this.zoomFactor = 1.0;
                this.setFitToSize(true);
            }
        } else {
            this.zoomFactor = 1.0;
            this.setFitToSize(true);
        }
    }

    private void open(Region region) {
        if (this.scrollPane == null) {
            Parent parent;
            for (parent = region.getParent(); parent != null && !(parent instanceof ScrollPane); parent = parent.getParent()) {
            }
            if (parent != null) {
                this.scrollPane = (ScrollPane)parent;
                this.managedPanel = region;
                this.scrollPane.viewportBoundsProperty().addListener(observable -> {
                    Bounds bounds = this.scrollPane.getViewportBounds();
                    if (this.lastPortBounds == null) {
                        double d = bounds.getWidth();
                        double d2 = bounds.getHeight();
                        if (d > 0.0 && d < Double.MAX_VALUE && d2 > 0.0 && d2 < Double.MAX_VALUE && this.isContentSized()) {
                            this.initContent(region);
                            this.setInitZoom(region, d, d2);
                            this.fitFactor = this.getFitFactor(region, d, d2);
                            this.scaleContent();
                            this.scrollPane.setHvalue(0.0);
                            this.scrollPane.setVvalue(0.0);
                            this.lastPortBounds = bounds;
                        }
                    } else if (!(this.isViewportTrackingDisabled() || bounds.getWidth() == this.lastPortBounds.getWidth() && bounds.getHeight() == this.lastPortBounds.getHeight())) {
                        if (this.fitToSize) {
                            this.fitFactor = this.getFitFactor(region, bounds.getWidth(), bounds.getHeight());
                            this.scaleContent();
                        }
                        this.lastPortBounds = bounds;
                    }
                });
                this.fitFactor = 1.0;
                this.zoomFactor = 1.0;
                this.addZoomHandlers();
            } else {
                Logger.getLogger(AbstractZoomPanObject.class.getName()).log(Level.WARNING, "ZoomPanObject must be attached to node within a ScrollPane");
            }
        }
    }

    private void close() {
        if (this.scrollPane != null) {
            this.removeZoomHandlers();
        }
    }

    private void adjustZoomFactor(double d) {
        double d2 = Math.log10(this.zoomFactor * this.fitFactor);
        this.zoomFactor = Math.pow(10.0, d2 += d) / this.fitFactor;
        this.setFitToSize(false);
    }

    private void scaleContent() {
        double d = this.fitFactor * this.zoomFactor;
        if (d != this.lastScale) {
            this.lastScale = d;
            Scale scale = Transform.scale((double)d, (double)d, (double)0.0, (double)0.0);
            this.managedPanel.getTransforms().setAll((Object[])new Transform[]{scale});
        }
    }

    private void setFitToSize(boolean bl) {
        if (bl != this.fitToSize) {
            if (bl) {
                this.hbarPolicy = this.scrollPane.getHbarPolicy();
                this.vbarPolicy = this.scrollPane.getVbarPolicy();
                this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                this.fitToSize = true;
            } else {
                this.scrollPane.setHbarPolicy(this.hbarPolicy);
                this.scrollPane.setVbarPolicy(this.vbarPolicy);
                this.hbarPolicy = null;
                this.vbarPolicy = null;
                this.fitToSize = false;
            }
        }
    }

    private void addZoomHandlers() {
        this.dragDetectedHandler = mouseEvent -> {
            if (this.panZoomMode && mouseEvent.isControlDown()) {
                this.zooming = true;
                this.beginZoom((int)mouseEvent.getScreenX());
                mouseEvent.consume();
            }
        };
        this.mouseDraggedHandler = mouseEvent -> {
            if (this.panZoomMode && this.zooming) {
                this.zoom((int)mouseEvent.getScreenX());
                mouseEvent.consume();
            }
        };
        this.mouseReleasedHandler = mouseEvent -> {
            if (this.panZoomMode && this.zooming) {
                this.zooming = false;
                mouseEvent.consume();
            }
        };
        this.scrollPane.addEventFilter(MouseEvent.DRAG_DETECTED, this.dragDetectedHandler);
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedHandler);
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
    }

    private void removeZoomHandlers() {
        this.scrollPane.removeEventFilter(MouseEvent.DRAG_DETECTED, this.dragDetectedHandler);
        this.scrollPane.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedHandler);
        this.scrollPane.removeEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
        this.dragDetectedHandler = null;
        this.mouseDraggedHandler = null;
        this.mouseReleasedHandler = null;
    }

    private void beginZoom(int n) {
        if (this.deltaDragThreshold == 0) {
            this.deltaDragThreshold = (int)Screen.getPrimary().getVisualBounds().getWidth() / 2;
        }
        this.dragInitial = n;
        this.dragLogScaleInitial = Math.log10(this.fitFactor * this.zoomFactor);
    }

    private void zoom(int n) {
        int n2 = n - this.dragInitial;
        if (n2 != this.deltaDrag) {
            this.deltaDrag = n2;
            double d = Math.log10(this.zoomFactor * this.fitFactor);
            double d2 = this.dragLogScaleInitial + (double)this.deltaDrag / (double)this.deltaDragThreshold;
            this.adjustZoomFactor(d2 - d);
            this.scaleContent();
        }
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            Region region = context.getLinkedTarget(Region.class, AbstractZoomPanObject.this);
            if (AbstractZoomPanObject.this.scrollPane == null && region.getScene() != null) {
                AbstractZoomPanObject.this.open(region);
            } else {
                region.sceneProperty().addListener((observableValue, scene, scene2) -> {
                    if (AbstractZoomPanObject.this.scrollPane == null && scene2 != null) {
                        AbstractZoomPanObject.this.open(region);
                    }
                });
            }
        }

        @Override
        public void onClose(Context context) {
            AbstractZoomPanObject.this.close();
        }
    }
}

