/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.Handle;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;

class TracingService {
    private static final Logger traceLogger = Logger.getLogger(TracingService.class.getPackage().getName());
    private Context context;

    TracingService() {
    }

    void setContext(Context context) {
        this.context = context;
    }

    boolean isTracingEnabled() {
        return traceLogger.isLoggable(Level.FINE);
    }

    void traceTask(URI uRI, String string) {
        this.trace(uRI, "TASK", string, null, Level.FINER);
    }

    void traceCommand(URI uRI, String string) {
        this.trace(uRI, "COMMAND", string, null, Level.FINER);
    }

    void traceEvent(URI uRI, String string, String string2, String string3) {
        this.trace(uRI, "EVENT", string, string2 + " -> " + string3, Level.FINEST);
    }

    void traceEngineEvent(String string) {
        this.trace(null, "EVENT", string, null, Level.FINE);
    }

    private void trace(URI uRI, String string, String string2, String string3, Level level) {
        assert (this.isTracingEnabled());
        StringBuilder stringBuilder = new StringBuilder();
        if (uRI != null) {
            ObjectManager objectManager = this.context.getObjectManager();
            Handle handle = objectManager.createHandle(uRI);
            stringBuilder.append(objectManager.getCategoryName(handle));
            stringBuilder.append("(");
            stringBuilder.append(handle.getConnectionTypeName());
            stringBuilder.append(":");
            Handle handle2 = objectManager.createHandle(handle.getEnclosingSourceId());
            SourceInstance sourceInstance = objectManager.getSource(handle2);
            if (sourceInstance != null) {
                String string4 = sourceInstance.getConnectionDisplayName();
                stringBuilder.append(string4);
            } else {
                stringBuilder.append(handle.getConnectionName());
            }
            stringBuilder.append("/");
            stringBuilder.append(handle.getPath());
            stringBuilder.append(")");
        } else {
            stringBuilder.append("Engine");
        }
        stringBuilder.append(".");
        stringBuilder.append(string);
        stringBuilder.append("@");
        stringBuilder.append(string2);
        stringBuilder.append("(");
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append(")");
        traceLogger.log(level, stringBuilder.toString());
    }
}

