/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.AbstractInstanceObject;
import oracle.dbtools.raptor.metrics.engine.ContainerInstanceObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.InstanceProperty;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.OperationInstance;
import oracle.dbtools.raptor.metrics.engine.OperationType;
import oracle.dbtools.raptor.metrics.engine.ParameterTypes;
import oracle.dbtools.raptor.metrics.engine.SourceAutomaton;
import oracle.dbtools.raptor.metrics.engine.SourceAutomatonActions;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;
import oracle.dbtools.raptor.metrics.listener.SourceChange;

public abstract class SourceInstance
extends ContainerInstanceObject {
    private ExecutionService executionService;
    private final String connectionName;
    private final Map<String, JobInstance> jobMap;
    private final Map<String, OperationInstance> operationMap;
    private final SourceAutomaton automaton;
    private final Map<String, String> parameters;
    private InstanceProperty<Double> minimumIntervalProperty;
    private InstanceProperty<Integer> connectionCountProperty;

    protected SourceInstance(SourceType sourceType, String string, Map<String, String> map) {
        super(DXIds.newId(sourceType.getConnectionTypeName(), string, sourceType.getPath(), map, null));
        this.connectionName = string;
        this.jobMap = new HashMap<String, JobInstance>();
        this.operationMap = new HashMap<String, OperationInstance>();
        this.automaton = new SourceAutomaton(this);
        this.parameters = map;
    }

    public abstract SourceType getSourceType();

    public String getConnectionName() {
        return this.connectionName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public abstract String getVersionString();

    protected abstract String getConnectionDisplayName();

    protected abstract JobInstance newJob(String var1);

    protected abstract OperationInstance newOperation(String var1, Map<String, String> var2, DXOperationCallback var3);

    protected abstract void connect(int var1);

    protected abstract void check();

    protected abstract void adjust(int var1, int var2);

    protected abstract void disconnect();

    protected abstract boolean cancelConnect();

    protected abstract boolean cancelCheck();

    protected abstract boolean cancelAdjustConnectionCount();

    protected abstract boolean cancelDisconnect();

    protected abstract ValueConverter getValueConverter();

    SourceAutomaton getAutomaton() {
        return this.automaton;
    }

    @Override
    void start(Context context, List<InstanceProperty<?>> list) {
        super.start(context, list);
        this.minimumIntervalProperty = this.findProperty("minimumInterval", list);
        this.connectionCountProperty = this.findProperty("connectionCount", list);
        this.executionService = context.getExecutionService();
        this.connectionCountProperty.getObservable().addListener((observableValue, n, n2) -> this.executionService.addEvent(this.getAutomaton().createAdjust((int)n)));
        this.getLogger().log(Level.INFO, "source ''{0}'' opened with pool size {1}", new Object[]{this.getId(), this.connectionCountProperty.get()});
        this.automaton.start();
    }

    Collection<JobInstance> getFaultedJobs() {
        return this.jobMap.values();
    }

    JobInstance getJob(String string) {
        return this.jobMap.get(string);
    }

    void removeJob(String string) {
        this.jobMap.remove(string);
    }

    Collection<OperationInstance> getFaultedOperations() {
        return this.operationMap.values();
    }

    OperationInstance getOperation(String string) {
        return this.operationMap.get(string);
    }

    void removeOperation(String string) {
        this.operationMap.remove(string);
    }

    <V> ItemInstance getOrCreateItem(String string, Map<String, String> map, Class<V> clazz) {
        ItemInstance itemInstance = null;
        ItemType itemType = this.getSourceType().itemTypeMap().get(string);
        if (itemType != null) {
            if (clazz == null || clazz.isAssignableFrom(itemType.getChangeClass())) {
                String string2 = itemType.getJobType().getPath();
                JobType jobType = this.getSourceType().jobTypeMap().get(string2);
                if (jobType != null) {
                    ParameterTypes parameterTypes = jobType.getParameterTypes();
                    Map<String, String> map2 = parameterTypes.normalize(map);
                    if (map2 != null) {
                        JobPartition jobPartition;
                        JobInstance jobInstance = this.jobMap.get(string2);
                        if (jobInstance == null && (jobInstance = jobType.newJob(this, string2)) != null) {
                            this.jobMap.put(string2, jobInstance);
                        }
                        if (jobInstance != null && (jobPartition = jobInstance.getPartition(map)) != null) {
                            itemInstance = jobPartition.getItem(string);
                        }
                    }
                    if (itemInstance == null) {
                        this.getContext().getLogger().log(Level.WARNING, "parameter mismatch for item with path ''{0}''", string);
                    }
                } else {
                    this.getContext().getLogger().log(Level.WARNING, "data type mismatch for item with path ''{0}''", string);
                }
            } else {
                this.getContext().getLogger().log(Level.WARNING, "job type not found for ''{0}''", string);
            }
        }
        return itemInstance;
    }

    <V> OperationInstance createOperation(String string, Map<String, String> map, DXOperationCallback dXOperationCallback) {
        OperationInstance operationInstance = null;
        OperationType operationType = this.getSourceType().operationTypeMap().get(string);
        if (operationType != null && !this.operationMap.containsKey(string) && (operationInstance = operationType.newOperation(this, string, map, dXOperationCallback)) != null) {
            this.operationMap.put(string, operationInstance);
        }
        if (operationInstance == null) {
            this.getContext().getLogger().log(Level.WARNING, "unable to create operation with path ''{0}''", string);
        }
        return operationInstance;
    }

    InstanceProperty<Double> getMinimumInterval() {
        return this.minimumIntervalProperty;
    }

    InstanceProperty<Integer> getConnectionCount() {
        return this.connectionCountProperty;
    }

    boolean isConnected() {
        SourceAutomatonActions sourceAutomatonActions = (SourceAutomatonActions)this.getAutomaton().getState();
        return sourceAutomatonActions != null ? sourceAutomatonActions.isConnected() : false;
    }

    void remove() {
        this.getContext().getActivityListenerService().addEngineObjectChange(this, ChangeType.REMOVE);
        this.getContext().getObjectManager().removeSource(this);
        for (InstanceProperty<?> instanceProperty : this.getProperties()) {
            instanceProperty.release();
        }
    }

    @Override
    AbstractInstanceObject getEnclosingInstance(Class<? extends AbstractInstanceObject> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    @Override
    protected SourceChange createChangeObject(ChangeType changeType, List<PropertyValue<?>> list) {
        return new SourceChange(changeType, this.getId(), this.getSourceType().getTypeId(), this.getConnectionDisplayName(), this.isConnected(), list);
    }
}

