/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.AbstractTypeObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.Handle;
import oracle.dbtools.raptor.metrics.engine.InstanceProperty;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.ItemTypeChange;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class ItemType
extends AbstractTypeObject {
    private final JobType jobType;
    private List<String> mapTo;

    protected ItemType(JobType jobType) {
        this.jobType = jobType;
    }

    public List<String> getMapTo() {
        return this.mapTo;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    @Override
    public <T> InstanceProperty<T> getInstanceProperty(URI uRI, Class<T> clazz, String string) {
        return null;
    }

    @Override
    public String getCategoryName() {
        return "Item";
    }

    @Override
    protected Logger getLogger() {
        return this.jobType.getLogger();
    }

    protected abstract ItemInstance createItem(URI var1);

    protected abstract Class<?> getChangeClass();

    protected abstract boolean isColumnRequired();

    ItemInstance createItem(Context context, JobPartition jobPartition, Map<String, String> map, Map<String, String> map2) {
        JobInstance jobInstance = jobPartition.getJob();
        URI uRI = DXIds.newId(jobInstance.getSource().getSourceType().getConnectionTypeName(), jobInstance.getSource().getConnectionName(), this.getPath(), map, map2);
        ItemInstance itemInstance = this.createItem(uRI);
        itemInstance.setContainingPartition(jobPartition);
        return itemInstance;
    }

    @Override
    AbstractTypeObject getEnclosingType(Class<? extends AbstractTypeObject> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (clazz.isAssignableFrom(this.jobType.getClass())) {
            return this.jobType;
        }
        SourceType sourceType = this.jobType.getSourceType();
        if (clazz.isAssignableFrom(sourceType.getClass())) {
            return sourceType;
        }
        return null;
    }

    @Override
    ItemInstance findInstance(ObjectManager objectManager, Handle handle) {
        JobPartition jobPartition;
        String string;
        JobInstance jobInstance;
        ItemType itemType;
        SourceInstance sourceInstance = objectManager.getEnclosingSourceInstance(handle);
        ItemInstance itemInstance = null;
        if (sourceInstance != null && (itemType = sourceInstance.getSourceType().itemTypeMap().get(handle.getPath())) != null && (jobInstance = sourceInstance.getJob(string = itemType.getJobType().getPath())) != null && (jobPartition = jobInstance.getPartition(handle.getNormalizedQueryParameters())) != null) {
            itemInstance = jobPartition.getItem(handle.getPath());
        }
        return itemInstance;
    }

    @Override
    URI createTypeId(String string) {
        return DXIds.newTypeId(this.getJobType().getSourceType().getConnectionTypeName(), string);
    }

    void setMapTo(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.mapTo = string != null && !string.isEmpty() ? Arrays.asList(string.split("\\s*\\.\\s*")) : Collections.emptyList();
    }

    @Override
    protected ItemTypeChange createChangeObject(ChangeType changeType, List<PropertyValue<?>> list) {
        return new ItemTypeChange(changeType, this.getTypeId(), this.getJobType().getTypeId(), this.getChangeClass(), list);
    }
}

