/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.AbstractInstanceObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.DataMap;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.DXBindEvent;
import oracle.dbtools.raptor.metrics.listener.DXConnectionEvent;
import oracle.dbtools.raptor.metrics.listener.DXItemListener;
import oracle.dbtools.raptor.metrics.listener.DXItemUpdateEvent;
import oracle.dbtools.raptor.metrics.listener.ItemChange;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class ItemInstance
extends AbstractInstanceObject {
    private final Set<DXItemListener<?>> itemListeners = new HashSet();
    private JobPartition jobPartition;
    private boolean changed;

    protected ItemInstance(URI uRI) {
        super(uRI);
    }

    public abstract ItemType getItemType();

    protected abstract Object getChangeObject();

    protected Object getIncrementalChangeObject() {
        return this.getChangeObject();
    }

    @Override
    protected Logger getLogger() {
        return this.jobPartition.getJob().getLogger();
    }

    protected abstract void update(ValueConverter var1, DataMap var2);

    protected void markChanged() {
        this.changed = true;
    }

    JobPartition getJobPartition() {
        return this.jobPartition;
    }

    void setContainingPartition(JobPartition jobPartition) {
        this.jobPartition = jobPartition;
    }

    boolean isPinned() {
        return this.itemListeners.size() > 0;
    }

    Collection<DXItemListener<?>> getItemListeners() {
        return this.itemListeners;
    }

    <V> boolean addItemListener(Context context, DXItemListener<V> dXItemListener) {
        JobInstance jobInstance = this.jobPartition.getJob();
        this.itemListeners.add(dXItemListener);
        if (this.itemListeners.size() == 1) {
            context.getExecutionService().addEvent(jobInstance.getAutomaton().createItemPinned(this));
            context.getActivityListenerService().addEngineObjectChange(this, ChangeType.ADD);
        }
        return this.jobPartition.hasRunAtLeastOnce();
    }

    <V> boolean removeItemListener(Context context, final DXItemListener<V> dXItemListener) {
        JobInstance jobInstance = this.jobPartition.getJob();
        boolean bl = this.itemListeners.remove(dXItemListener);
        if (bl) {
            ExecutionService executionService = context.getExecutionService();
            if (this.itemListeners.isEmpty()) {
                executionService.addEvent(jobInstance.getAutomaton().createItemUnpinned(this));
                context.getActivityListenerService().addEngineObjectChange(this, ChangeType.REMOVE);
            }
            executionService.addNotification(new Notification(){

                @Override
                void execute() {
                    DXBindEvent dXBindEvent = new DXBindEvent(ItemInstance.this.getId());
                    dXItemListener.onUnbind(dXBindEvent);
                }
            });
        }
        return bl;
    }

    @Override
    AbstractInstanceObject getEnclosingInstance(Class<? extends AbstractInstanceObject> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        JobInstance jobInstance = this.jobPartition.getJob();
        if (clazz.isAssignableFrom(jobInstance.getClass())) {
            return jobInstance;
        }
        SourceInstance sourceInstance = jobInstance.getSource();
        if (clazz.isAssignableFrom(sourceInstance.getClass())) {
            return sourceInstance;
        }
        return null;
    }

    Runnable createChangeNotifier() {
        Runnable runnable = null;
        if (this.itemListeners.size() > 0) {
            HashSet hashSet = new HashSet(this.itemListeners);
            DXItemUpdateEvent<Object> dXItemUpdateEvent = new DXItemUpdateEvent<Object>(this.getId(), this.getIncrementalChangeObject(), this.changed);
            runnable = () -> {
                for (DXItemListener dXItemListener : hashSet) {
                    try {
                        dXItemListener.onUpdate(dXItemUpdateEvent);
                    }
                    catch (RuntimeException runtimeException) {
                        this.getLogger().log(Level.WARNING, "Listener threw exception: " + dXItemListener, runtimeException);
                    }
                }
            };
        }
        this.changed = false;
        return runnable;
    }

    void notifyConnectEvent(boolean bl) {
        if (this.itemListeners.size() > 0) {
            URI uRI = this.getId();
            DXConnectionEvent dXConnectionEvent = new DXConnectionEvent(uRI, bl);
            for (DXItemListener<?> dXItemListener : this.itemListeners) {
                try {
                    if (bl) {
                        dXItemListener.onConnect(dXConnectionEvent);
                        continue;
                    }
                    dXItemListener.onDisconnect(dXConnectionEvent);
                }
                catch (RuntimeException runtimeException) {
                    this.getLogger().log(Level.WARNING, "Listener threw exception: " + dXItemListener, runtimeException);
                }
            }
        }
    }

    @Override
    protected ItemChange createChangeObject(ChangeType changeType, List<PropertyValue<?>> list) {
        return new ItemChange(changeType, this.getId(), this.getItemType().getTypeId(), this.jobPartition.getJob().getId(), list);
    }
}

