/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import oracle.dbtools.raptor.metrics.engine.AbstractEngineObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.MetaProperty;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class EngineObjectProperty<T> {
    private ValueHolder valueHolder;

    EngineObjectProperty() {
    }

    public abstract MetaProperty<T> getMeta();

    public T get() {
        return (T)this.getValueHolder().property.get();
    }

    public ObservableObjectValue<T> getObservable() {
        return this.getValueHolder().property;
    }

    public boolean isOverridden() {
        return this.getValueHolder().overridden;
    }

    void set(T t, boolean bl) {
        MetaProperty<T> metaProperty = this.getMeta();
        metaProperty.validate(t);
        this.getContext().getPropertyStore().set(this.getId(), metaProperty.getName(), t, bl);
        if (this.getEngineObject() != null) {
            this.getContext().getActivityListenerService().addEngineObjectChange(this.getEngineObject(), ChangeType.UPDATE);
        }
        ValueHolder valueHolder = this.getValueHolder();
        valueHolder.property.set(t);
        valueHolder.overridden = true;
    }

    void unset(boolean bl) {
        ValueHolder valueHolder = this.getValueHolder();
        if (valueHolder.overridden) {
            this.getContext().getPropertyStore().remove(this.getId(), this.getMeta().getName(), bl);
            if (this.getEngineObject() != null) {
                this.getContext().getActivityListenerService().addEngineObjectChange(this.getEngineObject(), ChangeType.UPDATE);
            }
            valueHolder.property.set(this.getDefaultValue());
            valueHolder.overridden = false;
        }
    }

    PropertyValue<T> createPropertyValue() {
        return new PropertyValue<T>(this.getMeta(), this.get(), this.isOverridden());
    }

    abstract Context getContext();

    abstract AbstractEngineObject getEngineObject();

    abstract URI getId();

    abstract T getDefaultValue();

    abstract ValueHolder createInitialValue();

    private ValueHolder getValueHolder() {
        if (this.valueHolder == null) {
            this.valueHolder = this.createInitialValue();
        }
        return this.valueHolder;
    }

    class ValueHolder {
        final ObjectProperty<T> property;
        boolean overridden;

        ValueHolder(ObjectProperty<T> objectProperty, boolean bl) {
            this.property = objectProperty;
            this.overridden = bl;
        }
    }
}

