/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataMap {
    public static DataMap createLeaf(final Map<String, List<Object>> map) {
        return new DataMap(){

            @Override
            public List<Object> getColumnValue(String string) {
                return (List)map.get(string);
            }
        };
    }

    public static DataMap createIntermediate(final Map<String, DataMap> map) {
        return new DataMap(){

            @Override
            protected DataMap getDataMap(List<String> list, int n, int n2) {
                if (n == n2) {
                    return (DataMap)map.get(list.get(n));
                }
                if (n < n2) {
                    return ((DataMap)map.get(list.get(n))).getDataMap(list, n + 1, n2);
                }
                return null;
            }
        };
    }

    private DataMap() {
    }

    public <T> T getColumnValue(String string, Class<T> clazz) {
        return this.getColumnValue(Collections.singletonList(string), clazz);
    }

    public <T> T getColumnValue(List<String> list, Class<T> clazz) {
        Object object;
        List<Object> list2 = this.getColumnValue(list);
        if (list2.size() != 1) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "DataMap column '{0}' is not singleton", list);
            if (list2.isEmpty()) {
                return null;
            }
        }
        if ((object = list2.get(0)) == null || clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Type mismatch for column ''{0}}'': required ''{1}'', found ''{2}''", new Object[]{list, clazz.getName(), object.getClass().getName()});
        return null;
    }

    public List<Object> getColumnValue(String string) {
        return null;
    }

    public List<Object> getColumnValue(List<String> list) {
        int n = list.size();
        DataMap dataMap = n == 1 ? this : this.getDataMap(list, 0, n - 2);
        return dataMap != null ? dataMap.getColumnValue(list.get(n - 1)) : null;
    }

    public DataMap getDataMap(List<String> list) {
        if (list.isEmpty()) {
            return this;
        }
        return this.getDataMap(list, 0, list.size() - 1);
    }

    protected DataMap getDataMap(List<String> list, int n, int n2) {
        return null;
    }
}

