/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import oracle.dbtools.raptor.metrics.control.AbstractGraphLayout;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.WeightedEdge;
import oracle.dbtools.raptor.metrics.control.WeightedVertex;

public class SankeyLayout<T, V extends WeightedVertex<T, V, E>, E extends WeightedEdge<T, V, E>>
extends AbstractGraphLayout<T, V, E> {
    public SankeyLayout(Graph<T, V, E> graph) {
        super(graph);
    }

    @Override
    protected void initializeVertices(Graph<T, V, E> graph, List<List<V>> list) {
        int n = 0;
        ListIterator<List<V>> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            List<V> list2 = listIterator.next();
            this.sortVerticesByWeight(list2);
            double d = n;
            int n2 = 0;
            for (WeightedVertex weightedVertex : list2) {
                weightedVertex.setX(d);
                weightedVertex.setY(n2++);
                weightedVertex.setHeight(weightedVertex.getWeight());
            }
            ++n;
        }
    }

    @Override
    protected void relaxVertexLevel(List<V> list, Graph<T, V, E> graph, List<List<V>> list2, double d) {
        for (WeightedVertex weightedVertex : list) {
            int n;
            WeightedVertex weightedVertex2;
            double d2;
            int n2 = this.getModifiedLevel(weightedVertex);
            double d3 = 0.0;
            double d4 = 0.0;
            for (WeightedEdge weightedEdge : weightedVertex.getInEdges()) {
                d2 = weightedEdge.getWeight();
                weightedVertex2 = (WeightedVertex)weightedEdge.getSource();
                n = this.getModifiedLevel(weightedVertex2);
                d3 += weightedVertex2.getY() * d2 / (double)(n2 - n);
                d4 += d2;
            }
            for (WeightedEdge weightedEdge : weightedVertex.getOutEdges()) {
                d2 = weightedEdge.getWeight();
                weightedVertex2 = (WeightedVertex)weightedEdge.getDest();
                n = this.getModifiedLevel(weightedVertex2);
                d3 += weightedVertex2.getY() * d2 / (double)(n - n2);
                d4 += d2;
            }
            if (!(d4 > 0.0)) continue;
            double d5 = d3 / d4;
            d2 = weightedVertex.getY();
            d2 += (d5 - d2) * d;
            weightedVertex.setY(d2);
        }
    }

    @Override
    protected void resolveCollisions(Graph<T, V, E> graph, List<List<V>> list) {
        double d;
        double d2;
        double d3 = this.getMinGap((Collection<V>)graph.getVertices());
        ListIterator<List<V>> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            List<V> list2 = listIterator.next();
            double d4 = this.getAverageY(list2);
            this.sortVerticesByLowestPoint(list2);
            int n = list2.size();
            d2 = 0.0;
            for (int i = n - 1; i > 0; --i) {
                double d5;
                WeightedVertex weightedVertex = (WeightedVertex)list2.get(i);
                WeightedVertex weightedVertex2 = (WeightedVertex)list2.get(i - 1);
                double d6 = weightedVertex.getY() - 0.5 * weightedVertex.getHeight();
                double d7 = d6 - (d5 = weightedVertex2.getY() + 0.5 * weightedVertex2.getHeight() + d2);
                if (d7 < d3) {
                    d2 += d7 - d3;
                }
                weightedVertex2.setY(weightedVertex2.getY() + d2);
            }
            d = d4 - this.getAverageY(list2);
            for (WeightedVertex weightedVertex : list2) {
                weightedVertex.setY(weightedVertex.getY() + d);
            }
        }
        double d8 = Double.MAX_VALUE;
        for (WeightedVertex weightedVertex : graph.getVertices()) {
            d2 = weightedVertex.getY();
            double d9 = d2 - 0.5 * (d = weightedVertex.getHeight());
            if (!(d9 < d8)) continue;
            d8 = d9;
        }
        for (WeightedVertex weightedVertex : graph.getVertices()) {
            weightedVertex.setY(weightedVertex.getY() - d8);
        }
        if (list.size() > 0) {
            double d10 = 0.0;
            for (WeightedVertex weightedVertex : list.get(0)) {
                weightedVertex.setY(d10 + weightedVertex.getHeight() * 0.5);
                d10 += weightedVertex.getHeight() + d3;
            }
            double d11 = 0.0;
            for (WeightedVertex weightedVertex : list.get(list.size() - 1)) {
                weightedVertex.setY(d11 + weightedVertex.getHeight() * 0.5);
                d11 += weightedVertex.getHeight() + d3;
            }
        }
    }

    @Override
    protected void normalize(Graph<T, V, E> graph, List<List<V>> list) {
        double d;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        for (WeightedVertex weightedVertex : graph.getVertices()) {
            d = weightedVertex.getY();
            double d4 = weightedVertex.getHeight();
            double d5 = d - 0.5 * d4;
            double d6 = d + 0.5 * d4;
            if (d5 < d3) {
                d3 = d5;
            }
            if (!(d6 > d2)) continue;
            d2 = d6;
        }
        double d7 = 1.0 / (d2 - d3);
        d = 1.0 / (double)(list.size() - 1);
        for (WeightedVertex weightedVertex : graph.getVertices()) {
            weightedVertex.setY(d7 * (weightedVertex.getY() - d3));
            weightedVertex.setX(d * (double)this.getModifiedLevel(weightedVertex));
            weightedVertex.setHeight(weightedVertex.getHeight() * d7);
        }
    }

    private double getMinGap(Collection<V> collection) {
        double d = 0.0;
        for (WeightedVertex weightedVertex : collection) {
            d += weightedVertex.getHeight();
        }
        double d2 = d / (double)collection.size();
        return d2 / 1.5;
    }

    private double getAverageY(List<V> list) {
        double d = 0.0;
        double d2 = 0.0;
        for (WeightedVertex weightedVertex : list) {
            d += weightedVertex.getY() * weightedVertex.getHeight();
            d2 += weightedVertex.getHeight();
        }
        return d / d2;
    }

    private void sortVerticesByWeight(List<V> list) {
        Collections.sort(list, (weightedVertex, weightedVertex2) -> {
            double d = weightedVertex2.getWeight() - weightedVertex.getWeight();
            if (d == 0.0) {
                return weightedVertex2.getId() > weightedVertex.getId() ? -1 : 1;
            }
            return d < 0.0 ? -1 : 1;
        });
    }

    private void sortVerticesByLowestPoint(List<V> list) {
        Collections.sort(list, (weightedVertex, weightedVertex2) -> {
            double d;
            double d2 = weightedVertex.getY() + 0.5 * weightedVertex.getHeight();
            double d3 = d2 - (d = weightedVertex2.getY() + 0.5 * weightedVertex2.getHeight());
            return d3 < 0.0 ? -1 : 1;
        });
    }
}

