/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.Collections;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.layout.Region;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import oracle.dbtools.raptor.metrics.control.AbstractGraphControl;
import oracle.dbtools.raptor.metrics.control.AreaComponent;
import oracle.dbtools.raptor.metrics.control.BezierComponent;
import oracle.dbtools.raptor.metrics.control.BezierPathComponent;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.GraphComponent;
import oracle.dbtools.raptor.metrics.control.LongLabel;
import oracle.dbtools.raptor.metrics.control.RectangleComponent;
import oracle.dbtools.raptor.metrics.control.RegionComponent;
import oracle.dbtools.raptor.metrics.control.SankeyEdge;
import oracle.dbtools.raptor.metrics.control.SankeyLayout;
import oracle.dbtools.raptor.metrics.control.SankeyVertex;

public class SankeyControl<T>
extends AbstractGraphControl<T, Graph<T, SankeyVertex<T>, SankeyEdge<T>>, SankeyVertex<T>, SankeyEdge<T>, BezierPathComponent> {
    public SankeyControl() {
        super(new SankeyLayout(new Graph()));
    }

    @Override
    protected AreaComponent createDefaultVertexRepresentation(SankeyVertex<T> sankeyVertex) {
        Rectangle rectangle = new Rectangle();
        rectangle.setWidth(20.0);
        rectangle.getStyleClass().setAll((Object[])new String[]{"sankey-vertex"});
        String string = sankeyVertex.getStyleClass();
        if (string != null && !string.isEmpty()) {
            rectangle.getStyleClass().add((Object)string);
        }
        return new RectangleComponent(rectangle);
    }

    @Override
    protected AreaComponent createDefaultVertexDisplay(SankeyVertex<T> sankeyVertex, double d) {
        RegionComponent regionComponent = null;
        String string = sankeyVertex.getLabel();
        if (string != null) {
            LongLabel longLabel = new LongLabel(string);
            longLabel.setMaxWidth(d);
            longLabel.setAlignment(Pos.BOTTOM_LEFT);
            longLabel.getStyleClass().setAll((Object[])new String[]{"sankey-label"});
            String string2 = sankeyVertex.getStyleClass();
            if (string2 != null && !string2.isEmpty()) {
                longLabel.getStyleClass().add((Object)string2);
            }
            regionComponent = new RegionComponent((Region)longLabel);
        }
        return regionComponent;
    }

    @Override
    protected BezierPathComponent createEdgeRepresentation(SankeyEdge<T> sankeyEdge) {
        Path path = new Path();
        path.getStyleClass().setAll((Object[])new String[]{"sankey-edge"});
        String string = sankeyEdge.getStyleClass();
        if (string != null && !string.isEmpty()) {
            path.getStyleClass().add((Object)string);
        }
        return new BezierPathComponent(path);
    }

    @Override
    protected void layoutUIModel(double d, double d2) {
        double d3;
        double d4;
        GraphComponent graphComponent;
        double d5;
        double d6 = 0.0;
        int n = ((Graph)this.getGraph()).getMaxVertexLevel();
        for (AbstractGraphControl.UIVertex object : this.getUIVertices()) {
            double d7;
            if (((SankeyVertex)object.getVertex()).getLevel() != n || !((d7 = object.getRepresentation().getWidth()) > d6)) continue;
            d6 = d7;
        }
        this.setPhysicalBounds(new Rectangle2D(0.0, 0.0, d - d6, d2));
        for (AbstractGraphControl.UIVertex uIVertex : this.getUIVertices()) {
            SankeyVertex sankeyVertex = (SankeyVertex)uIVertex.getVertex();
            double d8 = sankeyVertex.getHeight() / sankeyVertex.getWeight();
            ArrayList arrayList = new ArrayList(sankeyVertex.getOutEdges());
            Collections.sort(arrayList, (sankeyEdge, sankeyEdge2) -> ((SankeyVertex)sankeyEdge.getDest()).getY() > ((SankeyVertex)sankeyEdge2.getDest()).getY() ? 1 : -1);
            double d9 = 0.0;
            for (SankeyEdge sankeyEdge3 : arrayList) {
                BezierPathComponent bezierPathComponent = (BezierPathComponent)this.getUIEdge(sankeyEdge3).getRepresentation();
                bezierPathComponent.setHeight(d8 * sankeyEdge3.getWeight());
                bezierPathComponent.setStartX(sankeyVertex.getX());
                bezierPathComponent.setEndX(((SankeyVertex)sankeyEdge3.getDest()).getX());
                d9 += bezierPathComponent.getHeight();
            }
            int n2 = arrayList.size();
            d5 = n2 > 1 ? (sankeyVertex.getHeight() - d9) / (double)(n2 - 1) : 0.0;
            double d10 = sankeyVertex.getY() - 0.5 * sankeyVertex.getHeight();
            for (SankeyEdge sankeyEdge4 : arrayList) {
                graphComponent = (BezierPathComponent)this.getUIEdge(sankeyEdge4).getRepresentation();
                ((BezierComponent)graphComponent).setStartY(d10);
                d10 += ((BezierPathComponent)graphComponent).getHeight() + d5;
            }
        }
        for (AbstractGraphControl.UIVertex uIVertex : this.getUIVertices()) {
            SankeyVertex sankeyVertex = (SankeyVertex)uIVertex.getVertex();
            ArrayList arrayList = new ArrayList(sankeyVertex.getInEdges());
            Collections.sort(arrayList, (sankeyEdge, sankeyEdge2) -> ((SankeyVertex)sankeyEdge.getSource()).getY() > ((SankeyVertex)sankeyEdge2.getSource()).getY() ? 1 : -1);
            d4 = 0.0;
            for (SankeyEdge sankeyEdge5 : arrayList) {
                BezierPathComponent bezierPathComponent = (BezierPathComponent)this.getUIEdge(sankeyEdge5).getRepresentation();
                d4 += bezierPathComponent.getHeight();
            }
            int n3 = arrayList.size();
            d3 = n3 > 1 ? (sankeyVertex.getHeight() - d4) / (double)(n3 - 1) : 0.0;
            d5 = sankeyVertex.getY() - 0.5 * sankeyVertex.getHeight();
            for (Object object : arrayList) {
                BezierPathComponent bezierPathComponent = (BezierPathComponent)this.getUIEdge(object).getRepresentation();
                bezierPathComponent.setEndY(d5);
                d5 += bezierPathComponent.getHeight() + d3;
            }
        }
        for (AbstractGraphControl.UIEdge uIEdge : this.getUIEdges()) {
            BezierPathComponent bezierPathComponent = (BezierPathComponent)uIEdge.getRepresentation();
            double d11 = uIEdge.getSourceUIVertex().getRepresentation().getWidth();
            double d12 = this.getPhysicalX(bezierPathComponent.getStartX()) + d11;
            d3 = this.getPhysicalY(bezierPathComponent.getStartY());
            d5 = this.getPhysicalX(bezierPathComponent.getEndX());
            double d13 = this.getPhysicalY(bezierPathComponent.getEndY());
            double d14 = this.getPhysicalH(bezierPathComponent.getHeight());
            bezierPathComponent.setStartX(d12);
            bezierPathComponent.setStartY(d3);
            bezierPathComponent.setEndX(d5);
            bezierPathComponent.setEndY(d13);
            bezierPathComponent.setControlX1((2.0 * d12 + d5) / 3.0);
            bezierPathComponent.setControlY1(d3);
            bezierPathComponent.setControlX2((d12 + 2.0 * d5) / 3.0);
            bezierPathComponent.setControlY2(d13);
            bezierPathComponent.setHeight(d14);
            graphComponent = uIEdge.getDisplay();
            if (graphComponent == null) continue;
            ((AreaComponent)graphComponent).setCenterX(0.5 * (d12 + d5));
            ((AreaComponent)graphComponent).setCenterY(0.5 * (d3 + d13 + d14));
        }
        for (AbstractGraphControl.UIVertex uIVertex : this.getUIVertices()) {
            Object object;
            SankeyVertex sankeyVertex = (SankeyVertex)uIVertex.getVertex();
            AreaComponent areaComponent = uIVertex.getRepresentation();
            d4 = areaComponent.getWidth();
            double d15 = this.getPhysicalH(sankeyVertex.getHeight());
            double d16 = this.getPhysicalY(sankeyVertex.getY());
            double d17 = this.getPhysicalX(sankeyVertex.getX());
            areaComponent.setCenterX(d17 + 0.5 * d4);
            areaComponent.setCenterY(d16);
            areaComponent.setHeight(d15);
            object = uIVertex.getDisplay();
            if (object == null) continue;
            if (d17 > 0.5 * d) {
                ((AreaComponent)object).setCenterX(d17 - 3.0 - 0.5 * ((AreaComponent)object).getWidth());
            } else {
                ((AreaComponent)object).setCenterX(d17 + d4 + 3.0 + 0.5 * ((AreaComponent)object).getWidth());
            }
            ((AreaComponent)object).setCenterY(d16);
        }
    }

    @Override
    protected double computePrefHeight() {
        int n = ((Graph)this.getGraph()).getMaxVertexLevel() + 1;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
        }
        for (AbstractGraphControl.UIVertex object : this.getUIVertices()) {
            int n2;
            if (object.getStatus() == AbstractGraphControl.UIStatus.REMOVED) continue;
            int n3 = n2 = ((SankeyVertex)object.getVertex()).getLevel();
            nArray[n3] = nArray[n3] + 1;
        }
        int object = 0;
        for (int n4 : nArray) {
            if (n4 <= object) continue;
            object = n4;
        }
        return (object + 1) * 20;
    }

    @Override
    protected double computePrefWidth() {
        return (double)((Graph)this.getGraph()).getMaxVertexLevel() * 1.5 * this.getMaxDisplayWidth();
    }
}

