/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.layout.Region;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Ellipse;
import oracle.dbtools.raptor.metrics.control.AbstractGraphControl;
import oracle.dbtools.raptor.metrics.control.AreaComponent;
import oracle.dbtools.raptor.metrics.control.BezierCurveComponent;
import oracle.dbtools.raptor.metrics.control.Edge;
import oracle.dbtools.raptor.metrics.control.EllipseComponent;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.GraphEdge;
import oracle.dbtools.raptor.metrics.control.GraphLayout;
import oracle.dbtools.raptor.metrics.control.GraphVertex;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;
import oracle.dbtools.raptor.metrics.control.LongLabel;
import oracle.dbtools.raptor.metrics.control.RegionComponent;

public class GraphControl<T>
extends AbstractGraphControl<T, Graph<T, GraphVertex<T>, GraphEdge<T>>, GraphVertex<T>, GraphEdge<T>, BezierCurveComponent> {
    public GraphControl() {
        super(new GraphLayout(new Graph()));
    }

    @Override
    protected AreaComponent createDefaultVertexRepresentation(GraphVertex<T> graphVertex) {
        Ellipse ellipse = new Ellipse(10.0, 10.0);
        ellipse.getStyleClass().setAll((Object[])new String[]{"graph-vertex"});
        String string = graphVertex.getStyleClass();
        if (string != null && !string.isEmpty()) {
            ellipse.getStyleClass().add((Object)string);
        }
        return new EllipseComponent(ellipse);
    }

    @Override
    protected AreaComponent createDefaultVertexDisplay(GraphVertex<T> graphVertex, double d) {
        RegionComponent regionComponent = null;
        String string = graphVertex.getLabel();
        if (string != null) {
            LongLabel longLabel = new LongLabel(string);
            longLabel.setMaxWidth(d);
            longLabel.setAlignment(Pos.BOTTOM_LEFT);
            longLabel.getStyleClass().setAll((Object[])new String[]{"graph-label"});
            String string2 = graphVertex.getStyleClass();
            if (string2 != null && !string2.isEmpty()) {
                longLabel.getStyleClass().add((Object)string2);
            }
            regionComponent = new RegionComponent((Region)longLabel);
        }
        return regionComponent;
    }

    @Override
    protected BezierCurveComponent createEdgeRepresentation(GraphEdge<T> graphEdge) {
        CubicCurve cubicCurve = new CubicCurve();
        cubicCurve.getStyleClass().setAll((Object[])new String[]{"graph-edge"});
        String string = graphEdge.getStyleClass();
        if (string != null && !string.isEmpty()) {
            cubicCurve.getStyleClass().add((Object)string);
        }
        return new BezierCurveComponent(cubicCurve);
    }

    @Override
    protected void layoutUIModel(double d, double d2) {
        double d3;
        double d4;
        double d5;
        Object object;
        double d6 = 0.0;
        double d7 = 0.0;
        int n = ((Graph)this.getGraph()).getMaxVertexLevel();
        for (AbstractGraphControl.UIVertex object2 : this.getUIVertices()) {
            double d8;
            object = object2.getRepresentation();
            if (((GraphVertex)object2.getVertex()).getLevel() == n && (d8 = ((AreaComponent)object).getWidth()) > d6) {
                d6 = d8;
            }
            if (!((d8 = ((AreaComponent)object).getHeight()) > d7)) continue;
            d7 = d8;
        }
        this.setPhysicalBounds(new Rectangle2D(1.0, 0.5 * d7 + 1.0, d - d6, d2));
        for (AbstractGraphControl.UIEdge uIEdge : this.getUIEdges()) {
            object = (GraphEdge)uIEdge.getEdge();
            BezierCurveComponent bezierCurveComponent = (BezierCurveComponent)uIEdge.getRepresentation();
            d5 = this.getPhysicalX(((GraphVertex)((Edge)object).getSource()).getX());
            d4 = this.getPhysicalY(((GraphVertex)((Edge)object).getSource()).getY());
            d3 = this.getPhysicalX(((GraphVertex)((Edge)object).getDest()).getX());
            double d9 = this.getPhysicalY(((GraphVertex)((Edge)object).getDest()).getY());
            bezierCurveComponent.setStartX(d5);
            bezierCurveComponent.setStartY(d4);
            bezierCurveComponent.setEndX(d3);
            bezierCurveComponent.setEndY(d9);
            bezierCurveComponent.setControlX1((d5 + d3) / 2.0);
            bezierCurveComponent.setControlY1(d4);
            bezierCurveComponent.setControlX2((d5 + d3) / 2.0);
            bezierCurveComponent.setControlY2(d9);
            AreaComponent areaComponent = uIEdge.getDisplay();
            if (areaComponent == null) continue;
            areaComponent.setCenterX(0.5 * (d5 + d3));
            areaComponent.setCenterY(0.5 * (d4 + d9));
        }
        for (AbstractGraphControl.UIVertex uIVertex : this.getUIVertices()) {
            object = (GraphVertex)uIVertex.getVertex();
            AreaComponent areaComponent = uIVertex.getRepresentation();
            d5 = areaComponent.getWidth();
            d4 = this.getPhysicalY(((LocatedVertex)object).getY());
            d3 = this.getPhysicalX(((LocatedVertex)object).getX());
            areaComponent.setCenterX(d3 + 0.5 * d5);
            areaComponent.setCenterY(d4);
            AreaComponent areaComponent2 = uIVertex.getDisplay();
            if (areaComponent2 == null) continue;
            if (d3 > 0.5 * d2) {
                areaComponent2.setCenterX(d3 - 3.0 - 0.5 * areaComponent2.getWidth());
            } else {
                areaComponent2.setCenterX(d3 + d5 + 3.0 + 0.5 * areaComponent2.getWidth());
            }
            areaComponent2.setCenterY(d4);
        }
    }

    @Override
    protected double computePrefHeight() {
        int n = ((Graph)this.getGraph()).getMaxVertexLevel() + 1;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
        }
        double d = 0.0;
        for (AbstractGraphControl.UIVertex object : this.getUIVertices()) {
            int n2;
            if (object.getStatus() == AbstractGraphControl.UIStatus.REMOVED) continue;
            int n3 = n2 = ((GraphVertex)object.getVertex()).getLevel();
            nArray[n3] = nArray[n3] + 1;
            double d2 = object.getRepresentation().getHeight();
            if (!(d2 > d)) continue;
            d = d2;
        }
        int object = 0;
        for (int n4 : nArray) {
            if (n4 <= object) continue;
            object = n4;
        }
        return (double)(object + 1) * 20.0 + 2.0 * d;
    }

    @Override
    protected double computePrefWidth() {
        return (double)((Graph)this.getGraph()).getMaxVertexLevel() * 1.5 * this.getMaxDisplayWidth();
    }
}

