/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.shape.CubicCurve;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.control.BezierComponent;

public class BezierCurveComponent
extends BezierComponent {
    private final CubicCurve curve;

    public BezierCurveComponent(CubicCurve cubicCurve) {
        this.curve = cubicCurve;
    }

    public CubicCurve getNode() {
        return this.curve;
    }

    @Override
    protected void doMove() {
        this.curve.setControlX1(this.getControlX1());
        this.curve.setControlY1(this.getControlY1());
        this.curve.setControlX2(this.getControlX2());
        this.curve.setControlY2(this.getControlY2());
        this.curve.setStartX(this.getStartX());
        this.curve.setStartY(this.getStartY());
        this.curve.setEndX(this.getEndX());
        this.curve.setEndY(this.getEndY());
    }

    @Override
    protected void doAnimate(Timeline timeline, Duration duration, EventHandler<ActionEvent> eventHandler) {
        double d = this.getStartX();
        double d2 = this.getStartY();
        double d3 = this.getEndX();
        double d4 = this.getEndY();
        this.addKeyFrame(timeline, duration, this.curve.controlX1Property(), this.getControlX1());
        this.addKeyFrame(timeline, duration, this.curve.controlY1Property(), this.getControlY1());
        this.addKeyFrame(timeline, duration, this.curve.controlX2Property(), this.getControlX2());
        this.addKeyFrame(timeline, duration, this.curve.controlY2Property(), this.getControlY2());
        this.addKeyFrame(timeline, duration, this.curve.startXProperty(), d);
        this.addKeyFrame(timeline, duration, this.curve.startYProperty(), d2);
        this.addKeyFrame(timeline, duration, this.curve.endXProperty(), d3);
        this.addKeyFrame(timeline, duration, eventHandler, this.curve.endYProperty(), d4);
    }
}

