/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.control.BusyIndicator;
import oracle.dbtools.raptor.metrics.control.LayoutHelper;

public class BarbersPole
extends BusyIndicator {
    private final ProgressBar progressBar = new ProgressBar(1.0);
    private final StyleableDoubleProperty barWidthProperty = new SimpleStyleableDoubleProperty(cssBarWidth, (Object)this, "barWidth", 50.0){

        protected void invalidated() {
            BarbersPole.this.requestLayout();
        }
    };
    private final StyleableDoubleProperty barHeightProperty = new SimpleStyleableDoubleProperty(cssBarHeight, (Object)this, "barHeight", 8.0){

        protected void invalidated() {
            BarbersPole.this.requestLayout();
        }
    };
    private static final CssMetaData<BarbersPole, Number> cssBarWidth = new CssMetaData<BarbersPole, Number>("-sd-bar-width", StyleConverter.getSizeConverter()){

        public boolean isSettable(BarbersPole barbersPole) {
            return true;
        }

        public StyleableProperty<Number> getStyleableProperty(BarbersPole barbersPole) {
            return barbersPole.barWidthProperty;
        }
    };
    private static final CssMetaData<BarbersPole, Number> cssBarHeight = new CssMetaData<BarbersPole, Number>("-sd-bar-height", StyleConverter.getSizeConverter()){

        public boolean isSettable(BarbersPole barbersPole) {
            return true;
        }

        public StyleableProperty<Number> getStyleableProperty(BarbersPole barbersPole) {
            return barbersPole.barHeightProperty;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;

    public BarbersPole() {
        this.getStyleClass().add((Object)"barbers-pole");
        this.progressBar.getStyleClass().add((Object)"indicator");
        this.progressBar.setPrefWidth(100.0);
        this.progressBar.setMinWidth(100.0);
        this.progressBar.setMaxWidth(100.0);
        this.progressBar.setPrefHeight(-1.0);
        this.progressBar.setMinHeight(Double.NEGATIVE_INFINITY);
        this.progressBar.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.progressBar.setLayoutX(0.0);
        this.progressBar.setLayoutY(0.0);
        this.getChildren().setAll((Object[])new Node[]{this.progressBar});
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return BarbersPole.getClassCssMetaData();
    }

    public void setBarWidth(double d) {
        this.barWidthProperty.setValue((Number)d);
    }

    public double getBarWidth() {
        return this.barWidthProperty.getValue();
    }

    public DoubleProperty barWidthProperty() {
        return this.barWidthProperty;
    }

    protected double computePrefWidth(double d) {
        return this.barWidthProperty.get();
    }

    protected double computeMaxWidth(double d) {
        return this.computePrefWidth(d);
    }

    protected double computeMinWidth(double d) {
        return this.computePrefWidth(d);
    }

    protected double computePrefHeight(double d) {
        return this.barHeightProperty.get();
    }

    protected double computeMaxHeight(double d) {
        return this.computePrefHeight(d);
    }

    protected double computeMinHeight(double d) {
        return this.computePrefHeight(d);
    }

    protected void layoutChildren() {
        LayoutHelper layoutHelper = new LayoutHelper(this);
        double d = this.progressBar.prefWidth(-1.0);
        double d2 = this.progressBar.prefHeight(-1.0);
        double d3 = this.barWidthProperty.get();
        double d4 = this.barHeightProperty.get();
        double d5 = d3 / d;
        double d6 = d4 / d2;
        this.progressBar.setScaleX(d5);
        this.progressBar.setScaleY(d6);
        this.progressBar.setProgress(this.isBusy() ? -1.0 : 1.0);
        this.layoutInArea((Node)this.progressBar, layoutHelper.x(d * (d5 - 1.0) / 2.0), layoutHelper.y(d2 * (d6 - 1.0) / 2.0), d3, d4, 0.0, HPos.LEFT, VPos.TOP);
    }

    static {
        ArrayList<CssMetaData<BarbersPole, Number>> arrayList = new ArrayList<CssMetaData<BarbersPole, Number>>(Region.getClassCssMetaData());
        arrayList.add(cssBarWidth);
        arrayList.add(cssBarHeight);
        cssMetaDataList = Collections.unmodifiableList(arrayList);
    }
}

