/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.metrics.control.ExpandableEdge;
import oracle.dbtools.raptor.metrics.control.ExpandableVertex;
import oracle.dbtools.raptor.metrics.control.Layout;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;
import oracle.dbtools.raptor.metrics.control.Tree;
import oracle.dbtools.raptor.metrics.control.Vertex;

public abstract class AbstractTreeLayout<T, V extends ExpandableVertex<T, V, E>, E extends ExpandableEdge<T, V, E>>
implements Layout<T, Tree<T, V, E>, V, E> {
    private final Tree<T, V, E> graph;
    private static final double DISTANCE = 1.0;

    public AbstractTreeLayout(Tree<T, V, E> tree) {
        this.graph = tree;
    }

    @Override
    public Tree<T, V, E> getGraph() {
        return this.graph;
    }

    @Override
    public void run() {
        ExpandableVertex expandableVertex = (ExpandableVertex)this.graph.getRoot();
        if (expandableVertex != null) {
            Map<V, VertexLayout> map = this.initialize();
            VertexLayout vertexLayout = map.get(expandableVertex);
            Set<V> set = map.keySet();
            this.adjustLayoutModel(vertexLayout);
            this.firstWalk(vertexLayout);
            this.secondWalk(vertexLayout, -vertexLayout.prelim, 0);
            this.normalize(vertexLayout);
            this.convertLayoutCoordinates(vertexLayout, set);
        }
    }

    protected abstract void adjustLayoutModel(VertexLayout var1);

    protected abstract void convertLayoutCoordinates(VertexLayout var1, Collection<V> var2);

    private Map<V, VertexLayout> initialize() {
        Object object;
        VertexLayout vertexLayout;
        HashMap hashMap = new HashMap();
        this.populateLayoutMap(hashMap, (ExpandableVertex)this.graph.getRoot());
        for (ExpandableVertex expandableVertex : hashMap.keySet()) {
            vertexLayout = (VertexLayout)hashMap.get(expandableVertex);
            if (vertexLayout.isLeaf) continue;
            List<ExpandableVertex> list = this.sortChildVerticesById(expandableVertex);
            object = new ArrayList<VertexLayout>(list.size());
            for (ExpandableVertex expandableVertex2 : list) {
                object.add((VertexLayout)((VertexLayout)hashMap.get(expandableVertex2)));
            }
            vertexLayout.orderedChildren = object;
        }
        for (ExpandableVertex expandableVertex : hashMap.keySet()) {
            vertexLayout = (VertexLayout)hashMap.get(expandableVertex);
            if (vertexLayout.isLeaf) continue;
            vertexLayout.leftmostChild = vertexLayout.orderedChildren.get(0);
            vertexLayout.rightmostChild = vertexLayout.orderedChildren.get(vertexLayout.orderedChildren.size() - 1);
            for (int i = 0; i < vertexLayout.orderedChildren.size(); ++i) {
                object = vertexLayout.orderedChildren.get(i);
                ((VertexLayout)object).number = i;
                ((VertexLayout)object).parent = vertexLayout;
                if (i <= 0) continue;
                ((VertexLayout)object).leftSibling = vertexLayout.orderedChildren.get(i - 1);
                ((VertexLayout)object).leftmostSibling = vertexLayout.leftmostChild;
            }
        }
        return hashMap;
    }

    private void populateLayoutMap(Map<V, VertexLayout> map, V v) {
        VertexLayout vertexLayout = new VertexLayout();
        vertexLayout.treeVertex = v;
        vertexLayout.isLeaf = ((Vertex)v).isLeaf() || !((ExpandableVertex)v).isExpanded();
        vertexLayout.level = ((Vertex)v).getLevel();
        map.put((VertexLayout)v, vertexLayout);
        if (!vertexLayout.isLeaf) {
            for (ExpandableVertex expandableVertex : ((Vertex)v).getSuccessors()) {
                this.populateLayoutMap(map, expandableVertex);
            }
        }
    }

    private void firstWalk(VertexLayout vertexLayout) {
        if (vertexLayout.isLeaf) {
            if (vertexLayout.leftmostSibling != null) {
                vertexLayout.prelim = vertexLayout.leftSibling.prelim + 1.0;
            }
        } else {
            VertexLayout vertexLayout2 = vertexLayout.leftmostChild;
            for (VertexLayout vertexLayout3 : vertexLayout.orderedChildren) {
                this.firstWalk(vertexLayout3);
                vertexLayout2 = this.apportion(vertexLayout3, vertexLayout2);
            }
            this.executeShifts(vertexLayout);
            double d = 0.5 * (vertexLayout.leftmostChild.prelim + vertexLayout.rightmostChild.prelim);
            if (vertexLayout.leftSibling != null) {
                double d2;
                vertexLayout.prelim = d2 = vertexLayout.leftSibling.prelim + 1.0;
                vertexLayout.modifier = d2 - d;
            } else {
                vertexLayout.prelim = d;
            }
        }
    }

    private VertexLayout apportion(VertexLayout vertexLayout, VertexLayout vertexLayout2) {
        VertexLayout vertexLayout3;
        VertexLayout vertexLayout4;
        VertexLayout vertexLayout5 = null;
        VertexLayout vertexLayout6 = null;
        VertexLayout vertexLayout7 = null;
        VertexLayout vertexLayout8 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        VertexLayout vertexLayout9 = vertexLayout.leftSibling;
        if (vertexLayout9 != null) {
            vertexLayout5 = vertexLayout;
            vertexLayout6 = vertexLayout;
            vertexLayout7 = vertexLayout9;
            vertexLayout8 = vertexLayout5.leftmostSibling;
            d = vertexLayout5.modifier;
            d2 = vertexLayout6.modifier;
            d3 = vertexLayout7.modifier;
            d4 = vertexLayout8.modifier;
            vertexLayout4 = this.getNextRight(vertexLayout7);
            vertexLayout3 = this.getNextLeft(vertexLayout5);
            while (vertexLayout4 != null && vertexLayout3 != null) {
                vertexLayout7 = vertexLayout4;
                vertexLayout5 = vertexLayout3;
                vertexLayout8 = this.getNextLeft(vertexLayout8);
                vertexLayout6 = this.getNextRight(vertexLayout6);
                vertexLayout6.ancestor = vertexLayout;
                double d5 = vertexLayout7.prelim + d3 - (vertexLayout5.prelim + d) + 1.0;
                if (d5 > 0.0) {
                    this.moveSubTree(this.getUncommonAncestor(vertexLayout7, vertexLayout, vertexLayout2), vertexLayout, d5);
                    d += d5;
                    d2 += d5;
                }
                d3 += vertexLayout7.modifier;
                d += vertexLayout5.modifier;
                d4 += vertexLayout8.modifier;
                d2 += vertexLayout6.modifier;
                vertexLayout4 = this.getNextRight(vertexLayout7);
                vertexLayout3 = this.getNextLeft(vertexLayout5);
            }
        }
        vertexLayout4 = this.getNextRight(vertexLayout7);
        vertexLayout3 = this.getNextRight(vertexLayout6);
        if (vertexLayout4 != null && vertexLayout3 == null) {
            if (vertexLayout6 != null) {
                vertexLayout6.thread = vertexLayout4;
                vertexLayout6.modifier += d3 - d2;
            }
        } else {
            VertexLayout vertexLayout10 = this.getNextLeft(vertexLayout5);
            VertexLayout vertexLayout11 = this.getNextLeft(vertexLayout8);
            if (vertexLayout10 != null && vertexLayout11 == null) {
                if (vertexLayout8 != null) {
                    vertexLayout8.thread = vertexLayout10;
                    vertexLayout8.modifier += d - d4;
                }
                vertexLayout2 = vertexLayout;
            }
        }
        return vertexLayout2;
    }

    private void executeShifts(VertexLayout vertexLayout) {
        double d = 0.0;
        double d2 = 0.0;
        for (VertexLayout vertexLayout2 : vertexLayout.orderedChildren) {
            vertexLayout2.prelim += d;
            vertexLayout2.modifier += d;
            d += vertexLayout2.shift + (d2 += vertexLayout2.change);
        }
    }

    private VertexLayout getNextLeft(VertexLayout vertexLayout) {
        if (vertexLayout == null) {
            return null;
        }
        if (vertexLayout.isLeaf) {
            return vertexLayout.thread;
        }
        return vertexLayout.leftmostChild;
    }

    private VertexLayout getNextRight(VertexLayout vertexLayout) {
        if (vertexLayout == null) {
            return null;
        }
        if (vertexLayout.isLeaf) {
            return vertexLayout.thread;
        }
        return vertexLayout.rightmostChild;
    }

    private void moveSubTree(VertexLayout vertexLayout, VertexLayout vertexLayout2, double d) {
        int n = vertexLayout2.number - vertexLayout.number;
        vertexLayout2.change -= d / (double)n;
        vertexLayout.change += d / (double)n;
        vertexLayout2.shift += d;
        vertexLayout2.prelim += d;
        vertexLayout2.modifier += d;
    }

    private VertexLayout getUncommonAncestor(VertexLayout vertexLayout, VertexLayout vertexLayout2, VertexLayout vertexLayout3) {
        VertexLayout vertexLayout4 = vertexLayout.ancestor;
        if (vertexLayout2.parent.orderedChildren.contains(vertexLayout4)) {
            return vertexLayout4;
        }
        return vertexLayout3;
    }

    private void secondWalk(VertexLayout vertexLayout, double d, int n) {
        vertexLayout.prelim += d;
        if (vertexLayout.treeVertex != null) {
            ((LocatedVertex)vertexLayout.treeVertex).setX(n);
            ((LocatedVertex)vertexLayout.treeVertex).setY(vertexLayout.prelim);
        }
        d += vertexLayout.modifier;
        ++n;
        if (vertexLayout.orderedChildren != null) {
            for (VertexLayout vertexLayout2 : vertexLayout.orderedChildren) {
                this.secondWalk(vertexLayout2, d, n);
            }
        }
    }

    private void collectVertices(VertexLayout vertexLayout, Collection<VertexLayout> collection) {
        collection.add(vertexLayout);
        if (vertexLayout.orderedChildren != null) {
            for (VertexLayout vertexLayout2 : vertexLayout.orderedChildren) {
                this.collectVertices(vertexLayout2, collection);
            }
        }
    }

    private void normalize(VertexLayout vertexLayout) {
        ArrayList<VertexLayout> arrayList = new ArrayList<VertexLayout>();
        this.collectVertices(vertexLayout, arrayList);
        if (arrayList.size() <= 1) {
            for (VertexLayout vertexLayout2 : arrayList) {
                ((LocatedVertex)vertexLayout2.treeVertex).setX(0.0);
                ((LocatedVertex)vertexLayout2.treeVertex).setY(0.5);
            }
        } else {
            double d;
            double d2 = -1.7976931348623157E308;
            double d3 = Double.MAX_VALUE;
            for (VertexLayout vertexLayout3 : arrayList) {
                d = vertexLayout3.prelim;
                if (d < d3) {
                    d3 = d;
                }
                if (!(d > d2)) continue;
                d2 = d;
            }
            double d4 = 1.0 / (double)this.graph.getMaxVertexLevel();
            d = d2 > d3 ? 1.0 / (d2 - d3) : 1.0;
            for (VertexLayout vertexLayout4 : arrayList) {
                if (vertexLayout4.treeVertex == null) continue;
                ((LocatedVertex)vertexLayout4.treeVertex).setX(d4 * ((LocatedVertex)vertexLayout4.treeVertex).getX());
                ((LocatedVertex)vertexLayout4.treeVertex).setY(d * (((LocatedVertex)vertexLayout4.treeVertex).getY() - d3));
            }
        }
    }

    private List<V> sortChildVerticesById(V v) {
        Collection collection = ((Vertex)v).getSuccessors();
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, (expandableVertex, expandableVertex2) -> expandableVertex2.getId() > expandableVertex.getId() ? -1 : 1);
        return arrayList;
    }

    protected class VertexLayout {
        protected V treeVertex = null;
        protected int number = 0;
        protected int level = 0;
        protected boolean isLeaf = false;
        protected List<VertexLayout> orderedChildren = null;
        protected VertexLayout thread = null;
        protected VertexLayout parent = null;
        protected VertexLayout ancestor = null;
        protected VertexLayout leftSibling = null;
        protected VertexLayout leftmostSibling = null;
        protected VertexLayout leftmostChild = null;
        protected VertexLayout rightmostChild = null;
        protected double prelim = 0.0;
        protected double modifier = 0.0;
        protected double change = 0.0;
        protected double shift = 0.0;

        protected VertexLayout() {
        }
    }
}

