/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.Layout;
import oracle.dbtools.raptor.metrics.control.LocatedEdge;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;
import oracle.dbtools.raptor.metrics.control.Vertex;

public abstract class AbstractGraphLayout<T, V extends LocatedVertex<T, V, E>, E extends LocatedEdge<T, V, E>>
implements Layout<T, Graph<T, V, E>, V, E> {
    private final Graph<T, V, E> graph;
    private List<List<V>> verticesByLevel;
    private double alpha;
    private int maxIterations = 50;
    private double alphaFactor = 0.95;

    public AbstractGraphLayout(Graph<T, V, E> graph) {
        this.graph = graph;
    }

    @Override
    public Graph<T, V, E> getGraph() {
        return this.graph;
    }

    @Override
    public void run() {
        this.reset();
        for (int i = 0; i < this.maxIterations; ++i) {
            this.apply();
        }
        this.normalize(this.graph, this.verticesByLevel);
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public double getAlphaFactor() {
        return this.alphaFactor;
    }

    public void setAlphaFactor(double d) {
        this.alphaFactor = d;
    }

    public void reset() {
        if (this.alpha < 1.0) {
            this.verticesByLevel = this.getVerticesByLevel();
            this.alpha = 1.0;
            this.initializeVertices(this.graph, this.verticesByLevel);
            this.resolveCollisions(this.graph, this.verticesByLevel);
            this.normalize(this.graph, this.verticesByLevel);
        }
    }

    public void iterate() {
        this.apply();
        this.normalize(this.graph, this.verticesByLevel);
    }

    private void apply() {
        this.relaxRightToLeft();
        this.resolveCollisions(this.graph, this.verticesByLevel);
        this.relaxLeftToRight();
        this.resolveCollisions(this.graph, this.verticesByLevel);
        this.alpha *= this.alphaFactor;
    }

    private void relaxLeftToRight() {
        ListIterator<List<V>> listIterator = this.verticesByLevel.listIterator(0);
        while (listIterator.hasNext()) {
            this.relaxVertexLevel(listIterator.next(), this.graph, this.verticesByLevel, this.alpha);
        }
    }

    private void relaxRightToLeft() {
        ListIterator<List<V>> listIterator = this.verticesByLevel.listIterator(this.verticesByLevel.size());
        while (listIterator.hasPrevious()) {
            this.relaxVertexLevel(listIterator.previous(), this.graph, this.verticesByLevel, this.alpha);
        }
    }

    protected abstract void initializeVertices(Graph<T, V, E> var1, List<List<V>> var2);

    protected abstract void relaxVertexLevel(List<V> var1, Graph<T, V, E> var2, List<List<V>> var3, double var4);

    protected abstract void resolveCollisions(Graph<T, V, E> var1, List<List<V>> var2);

    protected abstract void normalize(Graph<T, V, E> var1, List<List<V>> var2);

    protected int getModifiedLevel(V v) {
        int n = ((Vertex)v).getSuccessorCount() == 0 ? this.graph.getMaxVertexLevel() : ((Vertex)v).getLevel();
        return n;
    }

    private List<List<V>> getVerticesByLevel() {
        int n = this.graph.getMaxVertexLevel();
        ArrayList<List<V>> arrayList = new ArrayList<List<V>>(n + 1);
        for (int i = 0; i <= n; ++i) {
            arrayList.add(new ArrayList());
        }
        for (LocatedVertex locatedVertex : this.graph.getVertices()) {
            int n2 = this.getModifiedLevel(locatedVertex);
            ((List)arrayList.get(n2)).add(locatedVertex);
        }
        return arrayList;
    }
}

