/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.PopupControl;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.panel.Action;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

@DefaultProperty(value="panelTemplate")
public class ShowPopup
implements Action {
    private final ObjectProperty<Node> ownerNodeProperty = new SimpleObjectProperty((Object)this, "ownerNode");
    private final ObjectProperty<PanelTemplate<Parent>> panelTemplateProperty = new SimpleObjectProperty((Object)this, "panelTemplate");

    public ShowPopup() {
        this.init();
    }

    public Node getOwnerNode() {
        return (Node)this.ownerNodeProperty.get();
    }

    public void setOwnerNode(Node node) {
        this.ownerNodeProperty.set((Object)node);
    }

    public ObjectProperty<Node> ownerNodeProperty() {
        return this.ownerNodeProperty;
    }

    public PanelTemplate<Parent> getPanelTemplate() {
        return (PanelTemplate)this.panelTemplateProperty.get();
    }

    public void setPanelTemplate(PanelTemplate<Parent> panelTemplate) {
        this.panelTemplateProperty.set(panelTemplate);
    }

    public ObjectProperty<PanelTemplate<Parent>> panelTemplateProperty() {
        return this.panelTemplateProperty;
    }

    @Override
    public Boolean get() {
        TemplateInstance<Parent> templateInstance = this.getPanelTemplate().newPanel();
        if (templateInstance != null) {
            Parent parent = templateInstance.getRootObject();
            PopupControl popupControl = new PopupControl();
            popupControl.setAutoHide(true);
            popupControl.getScene().setRoot(parent);
            popupControl.setOnHidden(windowEvent -> popupControl.getScene().setRoot((Parent)new Region()));
            Node node = this.getOwnerNode();
            Bounds bounds = node.getBoundsInLocal();
            Point2D point2D = node.localToScreen(0.0, bounds.getHeight());
            popupControl.show(node.getScene().getWindow(), point2D.getX(), point2D.getY());
        }
        return true;
    }
}

