/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import oracle.dbtools.raptor.metrics.actionobject.AbstractEventHandler;

public class MouseClickEventHandler
extends AbstractEventHandler<MouseEvent> {
    private final ObjectProperty<Button> buttonProperty = new SimpleObjectProperty((Object)this, "button", (Object)Button.PRIMARY);
    private final ObjectProperty<Clicks> clicksProperty = new SimpleObjectProperty((Object)this, "clicks", (Object)Clicks.ONE);
    private final BooleanProperty altDownProperty = new SimpleBooleanProperty((Object)this, "altDown", false);
    private final BooleanProperty controlDownProperty = new SimpleBooleanProperty((Object)this, "controlDown", false);
    private final BooleanProperty shiftDownProperty = new SimpleBooleanProperty((Object)this, "shiftDown", false);
    private final BooleanProperty middleButtonDownProperty = new SimpleBooleanProperty((Object)this, "middleButtonDown", false);
    private final BooleanProperty primaryButtonDownProperty = new SimpleBooleanProperty((Object)this, "primaryButtonDown", false);
    private final BooleanProperty secondaryButtonDownProperty = new SimpleBooleanProperty((Object)this, "secondaryButtonDown", false);

    public Button getButton() {
        return (Button)((Object)this.buttonProperty.get());
    }

    public void setButton(Button button) {
        this.buttonProperty.set((Object)button);
    }

    public ObjectProperty<Button> buttonProperty() {
        return this.buttonProperty;
    }

    public Clicks getClicks() {
        return (Clicks)((Object)this.clicksProperty.get());
    }

    public void setClicks(Clicks clicks) {
        this.clicksProperty.set((Object)clicks);
    }

    public ObjectProperty<Clicks> clicksProperty() {
        return this.clicksProperty;
    }

    public boolean isAltDown() {
        return this.altDownProperty.get();
    }

    public void setAltDown(boolean bl) {
        this.altDownProperty.set(bl);
    }

    public BooleanProperty altDownProperty() {
        return this.altDownProperty;
    }

    public boolean isControlDown() {
        return this.controlDownProperty.get();
    }

    public void setControlDown(boolean bl) {
        this.controlDownProperty.set(bl);
    }

    public BooleanProperty controlDownProperty() {
        return this.controlDownProperty;
    }

    public boolean isShiftDown() {
        return this.shiftDownProperty.get();
    }

    public void setShiftDown(boolean bl) {
        this.shiftDownProperty.set(bl);
    }

    public BooleanProperty shiftDownProperty() {
        return this.shiftDownProperty;
    }

    public boolean isMiddleButtonDown() {
        return this.middleButtonDownProperty.get();
    }

    public void setMiddleButtonDown(boolean bl) {
        this.middleButtonDownProperty.set(bl);
    }

    public BooleanProperty middleButtonDownProperty() {
        return this.middleButtonDownProperty;
    }

    public boolean isPrimaryButtonDown() {
        return this.primaryButtonDownProperty.get();
    }

    public void setPrimaryButtonDown(boolean bl) {
        this.primaryButtonDownProperty.set(bl);
    }

    public BooleanProperty primaryButtonDownProperty() {
        return this.primaryButtonDownProperty;
    }

    public boolean isSecondaryButtonDown() {
        return this.secondaryButtonDownProperty.get();
    }

    public void setSecondaryButtonDown(boolean bl) {
        this.secondaryButtonDownProperty.set(bl);
    }

    public BooleanProperty secondaryButtonDownProperty() {
        return this.secondaryButtonDownProperty;
    }

    @Override
    protected boolean setProperties(MouseEvent mouseEvent) {
        boolean bl;
        MouseButton mouseButton = mouseEvent.getButton();
        switch (this.getButton()) {
            case PRIMARY: {
                bl = mouseButton == MouseButton.PRIMARY;
                break;
            }
            case SECONDARY: {
                bl = mouseButton == MouseButton.SECONDARY;
                break;
            }
            case MIDDLE: {
                bl = mouseButton == MouseButton.MIDDLE;
                break;
            }
            default: {
                boolean bl2 = bl = mouseButton != MouseButton.NONE;
            }
        }
        if (bl) {
            int n = mouseEvent.getClickCount();
            switch (this.getClicks()) {
                case ONE: {
                    bl = n == 1;
                    break;
                }
                case TWO: {
                    bl = n == 2;
                    break;
                }
            }
        }
        if (bl) {
            boolean bl3 = bl = this.isAltDown() == mouseEvent.isAltDown();
        }
        if (bl) {
            boolean bl4 = bl = this.isControlDown() == mouseEvent.isControlDown();
        }
        if (bl) {
            boolean bl5 = bl = this.isShiftDown() == mouseEvent.isShiftDown();
        }
        if (bl) {
            boolean bl6 = bl = this.isPrimaryButtonDown() == mouseEvent.isPrimaryButtonDown();
        }
        if (bl) {
            boolean bl7 = bl = this.isMiddleButtonDown() == mouseEvent.isMiddleButtonDown();
        }
        if (bl) {
            boolean bl8 = bl = this.isSecondaryButtonDown() == mouseEvent.isSecondaryButtonDown();
        }
        if (bl) {
            bl = super.setProperties(mouseEvent);
        }
        return bl;
    }

    public static enum Clicks {
        ONE,
        TWO,
        ANY;

    }

    public static enum Button {
        PRIMARY,
        SECONDARY,
        MIDDLE,
        ANY;

    }
}

