/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.metrics.panel.TypedButton;
import oracle.dbtools.raptor.metrics.panel.TypedButtonType;

public class DialogButton
implements TypedButton {
    private Button button;
    private final ObjectProperty<TypedButtonType> typeProperty = new SimpleObjectProperty();
    private final BooleanProperty disableProperty = new SimpleBooleanProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onActionProperty = new SimpleObjectProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onFilterProperty = new SimpleObjectProperty();

    @Override
    public TypedButtonType getType() {
        return (TypedButtonType)((Object)this.typeProperty.get());
    }

    public void setType(TypedButtonType typedButtonType) {
        this.typeProperty.set((Object)typedButtonType);
    }

    public ObjectProperty<TypedButtonType> typeProperty() {
        return this.typeProperty;
    }

    public boolean isDisable() {
        return this.disableProperty.get();
    }

    public void setDisable(boolean bl) {
        this.disableProperty.set(bl);
    }

    public BooleanProperty disableProperty() {
        return this.disableProperty;
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty.get();
    }

    public void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty.set(eventHandler);
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onActionProperty;
    }

    public EventHandler<ActionEvent> getOnFilter() {
        return (EventHandler)this.onFilterProperty.get();
    }

    public void setOnFilter(EventHandler<ActionEvent> eventHandler) {
        this.onFilterProperty.set(eventHandler);
    }

    public ObjectProperty<EventHandler<ActionEvent>> onFilterProperty() {
        return this.onFilterProperty;
    }

    @Override
    public Button getButton() {
        return this.button;
    }

    void onCreateDialog(JDialog jDialog, DialogPane dialogPane) {
        ButtonType buttonType = this.getType().getButtonType();
        dialogPane.getButtonTypes().add((Object)buttonType);
        this.button = (Button)dialogPane.lookupButton(buttonType);
        this.button.setDisable(this.isDisable());
        EventHandler<ActionEvent> eventHandler = this.getOnAction();
        this.button.setOnAction(actionEvent -> {
            if (eventHandler != null) {
                eventHandler.handle(actionEvent);
            }
            SwingUtilities.invokeLater(() -> jDialog.setVisible(false));
        });
        EventHandler<ActionEvent> eventHandler2 = this.getOnFilter();
        if (eventHandler2 != null) {
            this.button.addEventFilter(ActionEvent.ACTION, eventHandler2);
        }
    }
}

