/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import oracle.dbtools.raptor.metrics.actionobject.AbstractConsumerAction;
import oracle.dbtools.raptor.metrics.panel.DataObject;

public class DeferredUpdate<T>
extends AbstractConsumerAction<DataObject<T>> {
    private final ObjectProperty<T> valueProperty = new SimpleObjectProperty();
    private boolean valid = false;
    private final InvalidationListener listener = observable -> {
        this.valid = false;
    };

    public DeferredUpdate() {
        this.init(new Listener());
    }

    public T getValue() {
        return (T)this.valueProperty.get();
    }

    public void setValue(T t) {
        this.valueProperty.set(t);
    }

    public ObjectProperty<T> valueProperty() {
        return this.valueProperty;
    }

    @Override
    protected boolean onInvokeAction(DataObject<T> dataObject) {
        if (!this.valid) {
            this.setValue(dataObject.valueProperty().getValue());
            this.valid = true;
        }
        return true;
    }

    @Override
    protected void onSetSource(DataObject<T> dataObject) {
        dataObject.valueProperty().addListener(this.listener);
    }

    @Override
    protected void onUnsetSource(DataObject<T> dataObject) {
        dataObject.valueProperty().removeListener(this.listener);
    }

    protected class Listener
    extends AbstractConsumerAction.Listener {
        protected Listener() {
        }
    }
}

