/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import oracle.dbtools.raptor.metrics.actionobject.AbstractHandler;

public abstract class AbstractEventHandler<T extends Event>
extends AbstractHandler
implements EventHandler<T> {
    private final ObjectProperty<Node> sourceNodeProperty = new SimpleObjectProperty((Object)this, "sourceNode");
    private final ObjectProperty<Object> eventSourceProperty = new SimpleObjectProperty((Object)this, "eventSource");
    private final ObjectProperty<Object> eventTargetProperty = new SimpleObjectProperty((Object)this, "eventTarget");

    public Node getSourceNode() {
        return (Node)this.sourceNodeProperty.get();
    }

    public ReadOnlyObjectProperty<Node> sourceNodeProperty() {
        return this.sourceNodeProperty;
    }

    public Object getEventSource() {
        return this.eventSourceProperty.get();
    }

    public ReadOnlyObjectProperty<Object> eventSourceProperty() {
        return this.eventSourceProperty;
    }

    public Object getEventTarget() {
        return this.eventTargetProperty.get();
    }

    public ReadOnlyObjectProperty<Object> eventTargetProperty() {
        return this.eventTargetProperty;
    }

    public void handle(T t) {
        if (this.setProperties(t)) {
            try {
                if (this.callAction()) {
                    t.consume();
                }
            }
            finally {
                this.clearProperties();
            }
        }
    }

    protected boolean setProperties(T t) {
        Node node = null;
        EventTarget eventTarget = t.getTarget();
        if (eventTarget != null) {
            if (eventTarget instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)eventTarget;
                ContextMenu contextMenu = menuItem.getParentPopup();
                if (contextMenu != null) {
                    node = contextMenu.getOwnerNode();
                }
            } else if (eventTarget instanceof Node) {
                node = (Node)eventTarget;
            }
        }
        this.sourceNodeProperty.set(node);
        this.eventSourceProperty.set(t.getSource());
        this.eventTargetProperty.set((Object)eventTarget);
        return true;
    }

    protected void clearProperties() {
        this.sourceNodeProperty.set(null);
        this.eventSourceProperty.set(null);
        this.eventTargetProperty.set(null);
    }
}

