/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.migration.workbench.core.util.Pollable;
import oracle.dbtools.migration.workbench.core.util.SchedulerKey;

public class Scheduler
implements Runnable {
    private long m_shortestInterval = 0L;
    private static Scheduler s_migrationTimer;
    private int m_key = 0;
    private Hashtable<Integer, InternalScheduledObject> m_listeners;
    private Thread m_thread = null;
    private Object m_syncObj = new Object();
    private boolean m_quit = false;

    private Scheduler() {
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public static Scheduler getInstance() {
        if (s_migrationTimer == null) {
            s_migrationTimer = new Scheduler();
        }
        return s_migrationTimer;
    }

    @Override
    public void run() {
        long l = 0L;
        while (!this.m_quit) {
            try {
                l = this.checkFireListeners(l);
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void fireListeners() {
        long l = this.m_shortestInterval;
        Set<Integer> set = this.getListeners().keySet();
        Iterator<Integer> iterator = set.iterator();
        while (iterator.hasNext()) {
            InternalScheduledObject internalScheduledObject = this.getListeners().get(iterator.next());
            if (internalScheduledObject.getTimeLeft() - this.m_shortestInterval <= 0L) {
                internalScheduledObject.getListener().poll();
                internalScheduledObject.setTimeLeft(internalScheduledObject.getInterval());
                continue;
            }
            if (internalScheduledObject.getTimeLeft() >= l) continue;
            l = internalScheduledObject.getTimeLeft();
            System.out.println(l);
        }
        System.out.println(l);
        this.m_shortestInterval = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkFireListeners(long l) {
        long l2 = Long.MAX_VALUE;
        Object object = this.m_syncObj;
        synchronized (object) {
            for (InternalScheduledObject internalScheduledObject : this.getListeners().values()) {
                internalScheduledObject.decrementTime(l);
                if (internalScheduledObject.getTimeLeft() <= 0L) {
                    internalScheduledObject.fireEvent();
                }
                if (internalScheduledObject.getTimeLeft() >= l2) continue;
                l2 = internalScheduledObject.getTimeLeft();
            }
        }
        return l2;
    }

    protected Hashtable<Integer, InternalScheduledObject> getListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new Hashtable();
        }
        return this.m_listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerKey addListener(Pollable pollable, long l) {
        ++this.m_key;
        Object object = this.m_syncObj;
        synchronized (object) {
            this.getListeners().put(this.m_key, new InternalScheduledObject(pollable, l));
        }
        this.m_thread.interrupt();
        return new SchedulerKey(this.m_key);
    }

    public void removeListener(SchedulerKey schedulerKey) {
        this.getListeners().remove(schedulerKey.getKey());
    }

    private class InternalScheduledObject {
        private Pollable m_listener = null;
        private long m_interval = 0L;
        private long m_timeLeft = 0L;

        protected InternalScheduledObject(Pollable pollable, long l) {
            this.m_listener = pollable;
            this.setInterval(l);
            this.setTimeLeft(l);
        }

        protected Pollable getListener() {
            return this.m_listener;
        }

        protected long getInterval() {
            return this.m_interval;
        }

        protected void setInterval(long l) {
            this.m_interval = l;
        }

        protected long getTimeLeft() {
            return this.m_timeLeft;
        }

        protected void setTimeLeft(long l) {
            this.m_timeLeft = l;
        }

        protected void decrementTime(long l) {
            this.m_timeLeft -= l;
        }

        protected void fireEvent() {
            this.getListener().poll();
            this.setTimeLeft(this.getInterval());
        }
    }
}

