/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.treeTable;

import java.sql.Date;
import java.sql.Time;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.treeTable.MigrationTreeNode;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;

public class MigrationLogModel
extends AbstractTreeTableModel {
    private static final String ROOT_MESSAGE = MigrationAddinArb.getString("MIGRATION_LOG_ROOT_MESSAGE");
    public static final String MESSAGE = MigrationAddinArb.getString("MIGRATION_LOG_COL_MESSAGE");
    public static final String DATE = MigrationAddinArb.getString("MIGRATION_LOG_COL_DATE");
    public static final String SOURCE = MigrationAddinArb.getString("MIGRATION_LOG_COL_SOURCE");
    private final String[] _cNames = new String[]{MESSAGE, DATE, SOURCE};
    private final Class[] _cTypes = new Class[]{TreeTableModel.class, Object.class, Object.class};

    public MigrationLogModel() {
        super((Object)new MigrationTreeNode(new LogRecord(Level.CONFIG, ROOT_MESSAGE)));
    }

    public MigrationTreeNode getRoot() {
        return (MigrationTreeNode)super.getRoot();
    }

    public Class getColumnClass(int n) {
        return this._cTypes[n];
    }

    public int getChildCount(Object object) {
        return ((MigrationTreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((MigrationTreeNode)object).getChildren().get(n);
    }

    public boolean isLeaf(Object object) {
        if (object == this.getRoot()) {
            return false;
        }
        return this.getChildCount(object) == 0;
    }

    public int getColumnCount() {
        return this._cNames.length;
    }

    public String getColumnName(int n) {
        return this._cNames[n];
    }

    public Object getValueAt(Object object, int n) {
        if (!(object instanceof MigrationTreeNode)) {
            return object;
        }
        MigrationTreeNode migrationTreeNode = (MigrationTreeNode)object;
        try {
            switch (n) {
                case 0: {
                    return migrationTreeNode.toString();
                }
                case 1: {
                    LogRecord logRecord = migrationTreeNode.getUserObject();
                    Date date = new Date(logRecord.getMillis());
                    Time time = new Time(logRecord.getMillis());
                    String string = MigrationUtils.formatNLSDate(date);
                    return string + "-" + time.toString();
                }
                case 2: {
                    LogRecord logRecord = migrationTreeNode.getUserObject();
                    List<LogInfo> list = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
                    String string = "";
                    if (list.size() == 1) {
                        string = list.get(0).getSourceDisplayString();
                        return string;
                    }
                    return string;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }
}

