/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.RepoRenderer;
import oracle.dbtools.raptor.connections.ConnectionComboRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public abstract class RepositoryDialog {
    private JEWTDialog m_dlg;
    private JPanel m_panel;
    private JComboBox m_repositoryCombo;
    private static final long serialVersionUID = 3721528190970465727L;
    private JButton m_btnSelect;
    private String[] m_repositoryTuples;
    private JLabel m_defaultRepositoryLabel;
    private String m_type;

    public RepositoryDialog(String string, String string2, String string3) {
        this.m_type = string3;
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new GridBagLayout());
        this.m_defaultRepositoryLabel = new JLabel();
        this.m_defaultRepositoryLabel.setText(StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_SELECT_REPOSITORY_TEXT")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.m_panel.add((Component)this.m_defaultRepositoryLabel, gridBagConstraints);
        this.m_repositoryCombo = new JComboBox();
        this.m_repositoryCombo.setRenderer(new RepoRenderer());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints2.weightx = 4.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        this.m_panel.add((Component)this.getRepositoryCombo(), gridBagConstraints2);
        this.setupData();
        this.m_repositoryCombo.setRenderer(new ConnectionComboRenderer());
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.m_panel, null, (String)string, (int)6);
        this.getGui().setSize(550, 130);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.getGui());
        this.getGui().setResizable(false);
        this.m_btnSelect = new JButton(string2);
        this.getGui().addCustomButton((Component)this.m_btnSelect);
    }

    public void addokActionListener(ActionListener actionListener) {
        this.m_btnSelect.addActionListener(actionListener);
    }

    public void setComboLabel(String string) {
        this.m_defaultRepositoryLabel.setText(string);
    }

    public void setHelpId(String string) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_panel, string);
    }

    private void setupData() {
        if (this.m_type.toLowerCase().equals("oracle")) {
            Connections connections = Connections.getInstance();
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = connections.getConnNames();
            this.getRepositoryCombo().removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!connections.isOracle(string)) continue;
                arrayList.add(string);
                this.getRepositoryCombo().addItem(string);
            }
            if (this.getRepositoryCombo().getModel().getSize() > 0) {
                this.getRepositoryCombo().setSelectedIndex(0);
            }
        } else {
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            this.m_repositoryTuples = migrationConfig.getRepositories();
            this.getRepositoryCombo().removeAllItems();
            String string = migrationConfig.getDefaultRepository();
            for (String string2 : this.m_repositoryTuples) {
                this.getRepositoryCombo().addItem(string2);
                if (!string2.equals(string)) continue;
                this.getRepositoryCombo().setSelectedItem(string2);
            }
        }
    }

    public JComboBox getRepositoryCombo() {
        return this.m_repositoryCombo;
    }

    public JEWTDialog getGui() {
        return this.m_dlg;
    }
}

