/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.repository.PrivilegeManager;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.migration.workbench.core.ui.PreReqListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBException;

public class FullMigrationPreRequisiteChecker {
    public static final int ALL_OK = 0;
    public static final int FAIL = 1;
    public static final int WARN = 2;
    private static final String CREATE_USER_PRIV = "CREATE USER";
    private static final String CREATE_SEQUENCE_PRIV = "CREATE SEQUENCE";
    private static final String CREATE_TRIGGER_PRIV = "CREATE TRIGGER";
    private static final String CREATE_SESSION_PRIV = "CREATE SESSION";
    private static final String CREATE_VIEW_PRIV = "CREATE VIEW";
    private static final String CREATE_CLUSTER_PRIV = "CREATE CLUSTER";
    private static final String CREATE_PROCEDURE_PRIV = "CREATE PROCEDURE";
    private static final String CREATE_TYPE_PRIV = "CREATE TYPE";
    private static final String CREATE_OPERATOR_PRIV = "CREATE OPERATOR";
    private static final String CREATE_TABLE_PRIV = "CREATE TABLE";
    private static final String CREATE_INDEXTYPE_PRIV = "CREATE INDEXTYPE";
    private static final String RESOURCE_ROLE = "RESOURCE";
    private static final String CREATE_ROLE_PRIV = "CREATE ROLE";
    private static final String ALTER_ANY_TRIGGER_PRIV = "ALTER ANY TRIGGER";
    private String m_PrivilegeWarning;
    private static final String[] LEAST_PRIVILEGE_PRIVILEGES = new String[]{"CREATE SESSION", "CREATE SEQUENCE", "CREATE TRIGGER", "CREATE CLUSTER", "CREATE PROCEDURE", "CREATE TYPE", "CREATE OPERATOR", "CREATE INDEXTYPE", "CREATE VIEW"};
    private static final PrivilegeManager.Privilege[] MULTI_SCHEMA_PRIVILEGES = new PrivilegeManager.Privilege[]{new PrivilegeManager.Privilege("CREATE ROLE", true), new PrivilegeManager.Privilege("CREATE USER", false), new PrivilegeManager.Privilege("ALTER ANY TRIGGER", true)};
    private static final PrivilegeManager.Privilege[] MULTI_SCHEMA_ROLES = new PrivilegeManager.Privilege[]{new PrivilegeManager.Privilege("RESOURCE", true)};
    private String m_srcConnName;
    private String m_trgConnName;
    private String m_repoName;
    private ArrayList<PreReqListener> m_audience;
    private Map<String, Boolean> m_conAlreadyOpen = new TreeMap<String, Boolean>();
    private Connection m_sourceConnection;
    private Connection m_targetConnection;
    private Connection m_repoConnection;
    private MigrationPlugin m_plugin;
    private PrivilegeManager m_privilegeManager;

    public FullMigrationPreRequisiteChecker(String string, String string2, String string3) {
        this.setSrcConnName(string);
        this.setTrgConnName(string2);
        this.setRepoName(string3);
        this.m_audience = new ArrayList();
        this.cleanupOutputVars();
    }

    public void allDone() {
        this.cleanupOutputVars();
    }

    private void cleanupOutputVars() {
        Boolean bl;
        if (this.m_sourceConnection != null) {
            bl = this.m_conAlreadyOpen.get(this.m_srcConnName);
            if (bl != null && !bl.booleanValue()) {
                Connections.getInstance().closeConnection(this.m_srcConnName);
                this.m_conAlreadyOpen.remove(this.m_srcConnName);
            }
            this.m_sourceConnection = null;
        }
        if (this.m_targetConnection != null) {
            bl = this.m_conAlreadyOpen.get(this.m_trgConnName);
            if (bl != null && !bl.booleanValue()) {
                Connections.getInstance().closeConnection(this.m_trgConnName);
                this.m_conAlreadyOpen.remove(this.m_trgConnName);
            }
            this.m_targetConnection = null;
        }
        if (this.m_repoConnection != null) {
            bl = this.m_conAlreadyOpen.get(this.m_repoName);
            if (bl != null && !bl.booleanValue()) {
                Connections.getInstance().closeConnection(this.m_repoName);
                MigrationAddin.disconnectRepository();
                this.m_conAlreadyOpen.remove(this.m_repoName);
            }
            this.m_repoConnection = null;
        }
        this.m_plugin = null;
    }

    public int runTests() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.checkSourceConnection();
        boolean bl4 = this.checkSourcePluginAvailable();
        boolean bl5 = this.checkTargetConnection();
        boolean bl6 = this.checkRepository();
        if (bl5 && (bl = this.checkLeastPrivilegePerms())) {
            bl2 = this.checkMultiPrivileges();
        }
        if (bl3 && bl4 && bl5 && bl6 && bl) {
            if (bl2) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    private boolean checkMultiPrivileges() {
        String string = MigrationAddinArb.getString("QM_PREREQ_MULTISCHEMA_PRIVS");
        String string2 = "";
        this.fireStartTest(string, null);
        for (PrivilegeManager.Privilege privilege : MULTI_SCHEMA_PRIVILEGES) {
            if (!this.m_privilegeManager.hasPrivilege(privilege.getName())) {
                this.m_PrivilegeWarning = string2 = MigrationAddinArb.format("QM_NO_PRIV", privilege.getName());
                return this.fireEndTest(string, false, string2);
            }
            if (!privilege.isGrantable() || this.m_privilegeManager.hasPrivilegeWithAdmin(privilege.getName())) continue;
            this.m_PrivilegeWarning = string2 = MigrationAddinArb.format("QM_NO_PRIV_ADMIN", privilege.getName());
            return this.fireEndTest(string, false, string2);
        }
        this.fireEndTest(string, true, null);
        string = MigrationAddinArb.getString("QM_PREREQ_MULTISCHEMA_ROLES");
        this.fireStartTest(string, null);
        for (PrivilegeManager.Privilege privilege : MULTI_SCHEMA_ROLES) {
            if (!this.m_privilegeManager.hasRole(privilege.getName())) {
                this.m_PrivilegeWarning = string2 = MigrationAddinArb.format("QM_NO_ROLE", privilege.getName());
                return this.fireEndTest(string, false, string2);
            }
            if (!privilege.isGrantable() || this.m_privilegeManager.hasRoleWithAdmin(privilege.getName())) continue;
            this.m_PrivilegeWarning = string2 = MigrationAddinArb.format("QM_NO_ROLE_ADMIN", privilege.getName());
            return this.fireEndTest(string, false, string2);
        }
        return this.fireEndTest(string, true, null);
    }

    private boolean checkRepoPerms() {
        String string = MigrationAddinArb.format("QM_PREREQ_CHECKING_REPO_PERMS", Connections.getDisplayName((String)this.m_trgConnName));
        boolean bl = true;
        this.fireStartTest(string, null);
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this.m_trgConnName);
        DBObject dBObject = new DBObject(uRL);
        bl = RepositoryManager.gotUserPermission(dBObject);
        this.fireEndTest(string, bl, null);
        return bl;
    }

    private boolean checkLeastPrivilegePerms() {
        String string = Messages.getString("FullMigrationPreRequisiteChecker.15");
        this.fireStartTest(string, null);
        try {
            this.m_privilegeManager = new PrivilegeManager(this.m_targetConnection);
            Object object = "";
            for (String string2 : LEAST_PRIVILEGE_PRIVILEGES) {
                if (this.m_privilegeManager.hasPrivilege(string2)) continue;
                object = (String)object + string2 + " \n";
            }
            if (((String)object).length() > 0) {
                return this.fireEndTest(string, false, Messages.getString("FullMigrationPreRequisiteChecker.18") + (String)object);
            }
            return this.fireEndTest(string, true, null);
        }
        catch (SQLException sQLException) {
            return this.fireEndTest(string, false, Messages.getString("FullMigrationPreRequisiteChecker.19") + sQLException.getLocalizedMessage());
        }
    }

    private Connection checkJDBCConnection(String string, String string2) {
        this.fireStartTest(string, null);
        String string3 = null;
        Connection connection = null;
        boolean bl = true;
        try {
            ConnectionSelectorUI.SELECTOR_ACTIVE = true;
            Boolean bl2 = Connections.getInstance().isConnectionOpen(string2);
            connection = Connections.getInstance().getConnection(string2);
            if (connection == null) {
                bl = false;
            } else {
                this.m_conAlreadyOpen.put(string2, bl2);
            }
        }
        catch (DBException dBException) {
            string3 = dBException.getLocalizedMessage();
            bl = false;
        }
        ConnectionSelectorUI.SELECTOR_ACTIVE = false;
        this.fireEndTest(string, bl, string3);
        return connection;
    }

    private boolean checkRepository() {
        String[] stringArray;
        boolean bl = false;
        for (String string : stringArray = MigrationAddin.getMigrationConfig().getRepositories()) {
            if (!string.equals(this.m_repoName)) continue;
            bl = true;
            break;
        }
        String string = MigrationAddinArb.getString("QM_PREREQ_CHECKING_REPO");
        if (bl) {
            String string2 = MigrationAddin.getRepositoryConnectionName();
            if (string2 != null && string2.equals(this.m_repoName)) {
                this.fireStartTest(string, null);
                this.fireEndTest(string, true, null);
                return true;
            }
            MigrationAddin.getMigrationConfig().setDefaultRepository(this.m_repoName);
            this.m_repoConnection = this.checkJDBCConnection(string, this.m_repoName);
            return this.m_repoConnection != null;
        }
        this.fireStartTest(string, null);
        int string3 = this.checkRepoPerms() ? 1 : 0;
        this.fireEndTest(string, true, null);
        return string3 != 0;
    }

    private boolean checkTargetConnection() {
        String string = MigrationAddinArb.format("QM_PREREQ_CHECKING_TARGET", Connections.getDisplayName((String)this.m_trgConnName));
        this.m_targetConnection = this.checkJDBCConnection(string, this.m_trgConnName);
        return this.m_targetConnection != null;
    }

    private boolean checkSourceConnection() {
        String string = MigrationAddinArb.format("QM_PREREQ_CHECKING_SOURCE", Connections.getDisplayName((String)this.m_srcConnName));
        this.m_sourceConnection = this.checkJDBCConnection(string, this.m_srcConnName);
        return this.m_sourceConnection != null;
    }

    private boolean checkSourcePluginAvailable() {
        String string = MigrationAddinArb.getString("QM_PREREQ_LOCATING_PLUGIN");
        this.m_plugin = MigrationAddin.getPluginForConnection(this.m_sourceConnection);
        this.fireEndTest(string, this.m_plugin != null, null);
        return this.m_plugin != null;
    }

    public void addListener(PreReqListener preReqListener) {
        if (!this.m_audience.contains(preReqListener)) {
            this.m_audience.add(preReqListener);
        }
    }

    protected void setRepoName(String string) {
        this.m_repoName = string;
    }

    protected void setSrcConnName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("FullMigrationPreRequisiteChecker.20"));
        }
        this.m_srcConnName = string;
    }

    protected void setTrgConnName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("FullMigrationPreRequisiteChecker.21"));
        }
        this.m_trgConnName = string;
    }

    protected void fireStartTest(String string, String string2) {
        for (PreReqListener preReqListener : this.m_audience) {
            preReqListener.testStarted(string, string2);
        }
    }

    protected boolean fireEndTest(String string, boolean bl, String string2) {
        for (PreReqListener preReqListener : this.m_audience) {
            preReqListener.testCompleted(string, bl, string2);
        }
        return bl;
    }

    public MigrationPlugin getPlugin() {
        return this.m_plugin;
    }

    public Connection getSourceConnection() {
        return this.m_sourceConnection;
    }

    public Connection getTargetConnection() {
        return this.m_targetConnection;
    }

    public String getSrcConnName() {
        return this.m_srcConnName;
    }

    public String getTrgConnName() {
        return this.m_trgConnName;
    }

    public String getPrivWarning() {
        return this.m_PrivilegeWarning;
    }
}

