/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.util.ArrayList;
import oracle.dbtools.migration.workbench.core.ui.AbstractUpdatableTableModel;

public class CountEventModel
extends AbstractUpdatableTableModel {
    private ArrayList<IdAndCounter> m_data = new ArrayList();
    private String[] m_columnNames;

    public CountEventModel(String[] stringArray) {
        this.m_columnNames = stringArray;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    protected boolean updateImpl(Object object) {
        if (object == null || !(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        for (IdAndCounter idAndCounter : this.m_data) {
            if (!idAndCounter.getId().equals(string)) continue;
            idAndCounter.increment();
            return true;
        }
        IdAndCounter idAndCounter = new IdAndCounter(string, 1);
        this.m_data.add(idAndCounter);
        return true;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.m_data.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n > this.getRowCount() - 1 || n2 > this.getColumnCount() - 1) {
            return null;
        }
        IdAndCounter idAndCounter = this.m_data.get(n);
        if (n2 == 0) {
            return idAndCounter.getId();
        }
        return idAndCounter.getCounter();
    }

    @Override
    public String getColumnName(int n) {
        if (n < 0 || n > this.getColumnCount()) {
            return null;
        }
        return this.m_columnNames[n];
    }

    @Override
    protected boolean clearImpl() {
        if (this.m_data.size() == 0) {
            return false;
        }
        while (this.m_data.size() > 0) {
            this.m_data.remove(0);
        }
        return true;
    }

    private static class IdAndCounter {
        private String m_id;
        private int m_counter;

        public IdAndCounter(String string, int n) {
            this.m_id = string;
            this.m_counter = n;
        }

        public void increment() {
            ++this.m_counter;
        }

        public int getCounter() {
            return this.m_counter;
        }

        public String getId() {
            return this.m_id;
        }
    }
}

