/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.workbench.core.ConvertInitiator;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.Messages;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;

public class CapturedNode
extends PlSqlNode {
    private static final String MD_PROCEDURE = "MD_PROCEDURE";
    private static final String MD_VIEW = "MD_VIEW";
    private static final String MD_FUNCTION = "MD_FUNCTION";
    private static final String MD_TRIGGER = "MD_TRIGGER";
    private String m_name;
    private String m_cName;
    private String m_type;
    private String m_schema;
    private boolean m_reconvert_flag;

    public CapturedNode() {
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.PRINTABLE);
        this.getAttributes().unset(ElementAttributes.BUILDABLE);
        this.setReadOnly(false);
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        if (uRL != null) {
            this.m_name = DBURLFormatHelper.getName((URL)uRL);
            this.m_cName = DBURLFormatHelper.getConnectionName((URL)uRL);
            this.m_type = DBURLFormatHelper.getBaseType((URL)uRL);
            this.m_schema = DBURLFormatHelper.getSchema((URL)uRL);
        }
    }

    public void setNodeInstance(DBObjectInstance dBObjectInstance) {
        DBObjectInstance dBObjectInstance2 = this.m_node = dBObjectInstance;
        this.m_node = dBObjectInstance;
    }

    public DBObjectInstance getNodeInstance() {
        return this.m_node;
    }

    public void setProperty(String string, Object object) {
        this.m_node.setProperty(string, object);
    }

    public Object getProperty(String string) {
        Object object = null;
        if ("NAME".equals(string)) {
            object = this.m_name;
        } else if ("SCHEMA".equals(string)) {
            object = this.m_schema;
        } else if ("TYPE".equals(string)) {
            object = this.m_type;
        } else if ("ConnectionName".equals(string)) {
            object = this.m_cName;
        } else if ("ConnectionType" == string && this.m_node == null) {
            object = "MIGREPO";
        } else if ("CATALOG" == string && this.m_node == null) {
            object = DBURLFormatHelper.getCatalog((URL)this.getURL());
        } else if (this.m_node != null) {
            object = this.m_node.getProperty(string);
        }
        return object;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public NavigationPoint getNavigationPoint(ChildObjectElement childObjectElement) {
        OffsetNavigationPoint offsetNavigationPoint = null;
        Integer n = (Integer)childObjectElement.getProperty("CODE_OFFSET");
        if (n != null) {
            Integer n2 = (Integer)childObjectElement.getProperty("CODE_LENGTH");
            offsetNavigationPoint = new OffsetNavigationPoint(Context.newIdeContext((Node)this), n.intValue(), n2 != null ? n2 : 0);
            offsetNavigationPoint.setPreferredEditorType(null);
        }
        return offsetNavigationPoint;
    }

    public boolean isValid() {
        return this.m_type != null;
    }

    protected Reader createReader(URL uRL) throws IOException {
        DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(uRL);
        if (dBObjectId == null) {
            return null;
        }
        try {
            ClobHelper clobHelper = null;
            if (MD_PROCEDURE.equals(this.m_type)) {
                MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                clobHelper = mdStoredProgram.getNativeSql();
            } else if (MD_VIEW.equals(this.m_type)) {
                MdView mdView = MdView.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                clobHelper = mdView.getNativeSql();
            } else if (MD_FUNCTION.equals(this.m_type)) {
                MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                clobHelper = mdStoredProgram.getNativeSql();
            } else if (MD_TRIGGER.equals(this.m_type)) {
                MdTrigger mdTrigger = MdTrigger.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                clobHelper = mdTrigger.getNativeSql();
            }
            if (clobHelper != null) {
                return clobHelper.getReader();
            }
            return new ClobHelper("").getReader();
        }
        catch (PersistenceException persistenceException) {
            Assert.printStackTrace((Throwable)persistenceException);
            IOException iOException = new IOException();
            iOException.initCause(persistenceException);
            throw iOException;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            Assert.printStackTrace((Throwable)noSuchObjectException);
            IOException iOException = new IOException();
            iOException.initCause(noSuchObjectException);
            throw iOException;
        }
    }

    protected void saveImpl() {
        URL uRL = this.getURL();
        DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(uRL);
        if (dBObjectId == null) {
            return;
        }
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer != null) {
            textBuffer.clearModified();
        }
        try {
            if (MD_PROCEDURE.equals(this.m_type)) {
                MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                mdStoredProgram.setNativeSql(textBuffer.getString(0, textBuffer.getLength()));
                mdStoredProgram.save(MigrationAddin.getPersistenceManager());
                if (this.isSetReconvertFlag()) {
                    this.doReconvert(mdStoredProgram);
                }
            } else if (MD_VIEW.equals(this.m_type)) {
                MdView mdView = MdView.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                mdView.setNativeSql(textBuffer.getString(0, textBuffer.getLength()));
                mdView.save(MigrationAddin.getPersistenceManager());
            } else if (MD_FUNCTION.equals(this.m_type)) {
                MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                mdStoredProgram.setNativeSql(textBuffer.getString(0, textBuffer.getLength()));
                mdStoredProgram.save(MigrationAddin.getPersistenceManager());
            } else if (MD_TRIGGER.equals(this.m_type)) {
                MdTrigger mdTrigger = MdTrigger.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                mdTrigger.setNativeSql(textBuffer.getString(0, textBuffer.getLength()));
                mdTrigger.save(MigrationAddin.getPersistenceManager());
            }
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(Messages.getString("CapturedNode.4"), new Object[]{MigrationURLFormatHelper.getName((URL)uRL)}, (Throwable)persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(Messages.getString("CapturedNode.5"), new Object[]{MigrationURLFormatHelper.getName((URL)uRL)}, (Throwable)noSuchObjectException);
        }
    }

    private void doReconvert(MdStoredProgram mdStoredProgram) {
        ConvertInitiator convertInitiator = new ConvertInitiator();
        convertInitiator.setContext(Context.newIdeContext((Node)this));
        convertInitiator.setDBObject(new DBObject((Element)this));
        convertInitiator.launch();
    }

    public boolean isSetReconvertFlag() {
        return this.m_reconvert_flag;
    }

    public void setReconvertFlag(boolean bl) {
        this.m_reconvert_flag = bl;
    }

    public boolean dictionarySupported() {
        return false;
    }

    public Icon getIcon() {
        return super.getIcon();
    }

    public String getName() {
        if (this.m_name == null) {
            return super.getSrcName();
        }
        return this.m_name;
    }
}

