/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.TargetDataStatsPanel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class TargetDataAction
extends AbstractMenuAction {
    public void launch() {
        ActionListener actionListener;
        TargetDataStatsPanel targetDataStatsPanel = new TargetDataStatsPanel(false);
        String string = MigrationProjectNavigatorArb.getString("REFRESH_TARGET_DATA_STATISTICS");
        boolean bl = UIUtils.showPanelAsDialog((JPanel)targetDataStatsPanel, (String)string, (ActionListener)(actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "apply") {
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                } else {
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            }
        }));
        if (bl) {
            String string2 = targetDataStatsPanel.getTargetConnection();
            Connection connection = null;
            String string3 = targetDataStatsPanel.getSourceConnection();
            Connection connection2 = null;
            try {
                connection = Connections.getInstance().getConnection(string2);
                connection2 = Connections.getInstance().getConnection(string3);
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
            try {
                Connection connection3 = this.getDBObject().getConnection();
                this.refreshTargetStats(connection, connection2, connection3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void refreshTargetStats(final Connection connection, final Connection connection2, final Connection connection3) throws TaskException {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(MigrationProjectNavigatorArb.getString("REFRESH_TARGET_DATA_STATISTICS"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected Void doWork() throws TaskException {
                try {
                    this.refreshTargetStatsWork(connection, connection2, connection3);
                }
                catch (SQLException sQLException) {
                    throw new TaskException((Throwable)sQLException);
                }
                return null;
            }

            public void refreshTargetStatsWork(Connection connection4, Connection connection22, Connection connection32) throws SQLException {
                TargetDataAction.this.truncateTargetDataStats(connection32);
                List<TableDetails> list = TargetDataAction.this.getListOfTables(connection32, "CAPTURED");
                List<TableDetails> list2 = TargetDataAction.this.getListOfTables(connection32, "CONVERTED");
                this.updateDataStats(list, connection22, connection32, "MD_NUMROW$SOURCE");
                this.updateDataStats(list2, connection4, connection32, "MD_NUMROW$TARGET");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateDataStats(List<TableDetails> list, Connection connection4, Connection connection22, String string) throws SQLException {
                Statement statement = null;
                Statement statement2 = null;
                ResultSet resultSet = null;
                String string2 = "SELECT count(*) FROM ";
                String string3 = "INSERT INTO " + string + "(NUMROWS,NAME,OBJID)VALUES(?,?,?)";
                for (TableDetails tableDetails : list) {
                    if (this.isInterupted()) break;
                    try {
                        statement = connection4.createStatement();
                        resultSet = statement.executeQuery(string2 + " " + tableDetails.getName());
                        statement2 = connection22.prepareStatement(string3);
                        while (resultSet.next()) {
                            statement2.setObject(1, resultSet.getObject(1));
                            statement2.setString(2, tableDetails.getName());
                            statement2.setLong(3, tableDetails.getObjectId());
                        }
                        statement2.executeUpdate();
                    }
                    catch (Throwable throwable) {}
                    continue;
                    finally {
                        if (statement2 != null && !statement2.isClosed()) {
                            statement2.close();
                        }
                        if (resultSet != null && !resultSet.isClosed()) {
                            resultSet.close();
                        }
                        if (statement == null || statement.isClosed()) continue;
                        statement.close();
                    }
                }
            }

            private boolean isInterupted() {
                return Thread.currentThread().isInterrupted();
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableDetails> getListOfTables(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<TableDetails> arrayList = new ArrayList<TableDetails>();
        try {
            String string2 = "select qualifiedname,objid from mgv_all_tables_details where UPPER(capturedorconverted)=UPPER(?)";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                Long l = resultSet.getLong(2);
                arrayList.add(new TableDetails(string3, l));
            }
        }
        finally {
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
            if (preparedStatement != null && !preparedStatement.isClosed()) {
                preparedStatement.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateTargetDataStats(Connection connection) throws SQLException {
        Statement statement = null;
        try {
            String string = "TRUNCATE TABLE md_numrow$source";
            String string2 = "TRUNCATE TABLE md_numrow$target";
            statement = connection.createStatement();
            int n = statement.executeUpdate(string);
            int n2 = statement.executeUpdate(string2);
        }
        finally {
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
    }

    class TableDetails {
        private final String name;
        private final Long objectId;

        public TableDetails(String string, Long l) {
            this.name = string;
            this.objectId = l;
        }

        public String getName() {
            return this.name;
        }

        public long getObjectId() {
            return this.objectId;
        }
    }
}

