/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class MigrationRepositoryDatabases
extends DefaultContainer
implements MigrationRepositoryStateListener {
    protected static final Logger LOGGER = Logger.getLogger(MigrationRepositoryDatabases.class.getName());
    protected HashSet<String> m_names = new HashSet();
    protected PersistenceUtility m_utility;
    protected PersistenceManager m_persistenceManager;
    protected Connection m_connection;
    private boolean _closing;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public abstract String getShortLabel();

    protected abstract MigrationConnectionNode createMdConnectionNode(String var1, String var2, MdConnection var3);

    public abstract CloseableIterator getMdConnectionsIterator() throws PersistenceException;

    protected String findUniqueName(String string) {
        Object object = string;
        int n = 2;
        while (this.m_names.contains(object)) {
            object = string + "(" + n++ + ")";
        }
        this.m_names.add((String)object);
        return object;
    }

    protected void addChild(MdConnection mdConnection, String string, boolean bl) {
        Object object2;
        for (Object object2 : this._children) {
            MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)object2;
            if (migrationConnectionNode.getMdConnection().getKey().getId() != mdConnection.getKey().getId()) continue;
            if (bl) {
                this.reload();
            }
            return;
        }
        String string2 = this.findUniqueName(mdConnection.getName());
        object2 = this.createMdConnectionNode(string2, string, mdConnection);
        this._children.add(object2);
        UpdateMessage.fireChildAdded((Subject)this, object2);
    }

    private void reload() {
        IconOverlayCache iconOverlayCache = IconOverlayCache.getInstance();
        iconOverlayCache.clearOverlays("MigrationNodeInfoType");
        iconOverlayCache.fireOverlaysChanged();
        UpdateMessage.fireObjectReloaded((Subject)this);
        this.repositoryClosed();
        try {
            this.open();
        }
        catch (IOException iOException) {
            MigrationRepositoryDatabases.log(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        if (!MigrationAddin.isRepositoryOpen()) {
            return;
        }
        String string = MigrationAddin.getRepositoryConnectionName();
        try (CloseableIterator closeableIterator = null;){
            closeableIterator = this.getMdConnectionsIterator();
            while (closeableIterator.hasNext()) {
                MdConnection mdConnection = (MdConnection)closeableIterator.next();
                this.addChild(mdConnection, string, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl() throws IOException {
        block6: {
            try {
                if (this._closing) break block6;
                this._closing = true;
                ArrayList arrayList = this._children;
                synchronized (arrayList) {
                    this._children.clear();
                }
                this.m_persistenceManager = null;
                this.m_utility = null;
                this.m_names.clear();
            }
            finally {
                this._closing = false;
            }
        }
    }

    public void addMdConnection(MdConnection mdConnection) {
        this.addChild(mdConnection, MigrationAddin.getDefaultMigrationRepository(), true);
    }

    protected abstract PersistenceManager getPersistenceManager();

    public PersistenceUtility getUtility() {
        if (null == this.m_utility && this.getPersistenceManager() != null) {
            this.m_utility = PersistenceUtility.getInstance(this.getPersistenceManager());
        }
        return this.m_utility;
    }

    public boolean deleteConnection(MigrationConnectionNode migrationConnectionNode) {
        MdConnection mdConnection = migrationConnectionNode.getMdConnection();
        boolean bl = false;
        for (MigrationConnectionNode migrationConnectionNode2 : this._children) {
            if (!migrationConnectionNode.getShortLabel().equals(migrationConnectionNode2.getShortLabel())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        try {
            mdConnection.delete(this.getPersistenceManager());
            this.getPersistenceManager().commit();
            this.m_names.remove(migrationConnectionNode.getShortLabel());
            this.remove((Element)migrationConnectionNode);
            UpdateMessage.fireStructureChanged((Subject)this);
            this.markDirty(false);
            this.repositoryClosed();
            try {
                this.open();
            }
            catch (IOException iOException) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").severe(iOException.getLocalizedMessage());
            }
        }
        catch (PersistenceException persistenceException) {
            return false;
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean renameConnection(MigrationConnectionNode migrationConnectionNode, String string) {
        MdConnection mdConnection = migrationConnectionNode.getMdConnection();
        mdConnection.setName(string);
        try {
            mdConnection.save(this.getPersistenceManager());
            this.getPersistenceManager().commit();
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getMessage(), "", (Throwable)persistenceException);
            return false;
        }
        catch (SQLException sQLException) {
            MigrationLogUtil.logThrowable(sQLException.getMessage(), "", (Throwable)sQLException);
            return false;
        }
        this.m_names.remove(migrationConnectionNode.getShortLabel());
        String string2 = this.findUniqueName(string);
        migrationConnectionNode.setShortLabel(string2);
        UpdateMessage.fireObjectRenamed((Subject)this);
        return true;
    }

    public MigrationConnectionNode[] getMigrationConnectionNodes() {
        return this._children.toArray(new MigrationConnectionNode[this._children.size()]);
    }

    public boolean isConnected() {
        return this.m_persistenceManager != null;
    }

    public void nullConnection() {
        this.m_connection = null;
    }

    @Override
    public void repositoryClosed() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").severe(iOException.getLocalizedMessage());
        }
    }

    @Override
    public void repositoryOpened(String string) {
        try {
            if (this.isOpen()) {
                this.revert();
            } else {
                MigrationProjectNavigatorManager.getInstance().refreshElement((Element)this);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").severe(iOException.getLocalizedMessage());
        }
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public MigrationConnectionNode[] findMatchingConnections(String string) {
        ArrayList<MigrationConnectionNode> arrayList = new ArrayList<MigrationConnectionNode>();
        for (Object e : this._children) {
            MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)e;
            if (!migrationConnectionNode.getMdConnection().getDburl().equals(string)) continue;
            arrayList.add(migrationConnectionNode);
        }
        return arrayList.toArray(new MigrationConnectionNode[arrayList.size()]);
    }

    public Iterator getChildren() {
        if (this.isLoaded()) {
            return super.getChildren();
        }
        return null;
    }
}

