/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;

public final class CapturedDatabases
extends MigrationRepositoryDatabases {
    private static CapturedDatabases s_instance;

    public static synchronized CapturedDatabases getInstance() {
        if (s_instance == null) {
            s_instance = new CapturedDatabases();
        }
        return s_instance;
    }

    @Override
    public String getShortLabel() {
        return MigrationAddinArb.getString("CAP_ROOT_LABEL");
    }

    @Override
    public CloseableIterator getMdConnectionsIterator() throws PersistenceException {
        return this.getUtility().getAllCapturedConnections();
    }

    @Override
    protected MigrationConnectionNode createMdConnectionNode(String string, String string2, MdConnection mdConnection) {
        return new CapturedConnectionNode(string, string2, mdConnection);
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    public Icon getIcon() {
        String string = MigrationAddinArb.getString("MIGRATION_CAPTURE_ICON");
        if (string == null) {
            return null;
        }
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            ImageIcon imageIcon = new ImageIcon(uRL);
            return imageIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

