/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogRecord;
import oracle.dbtools.metadata.persistence.PersistableObject;

public class LogInfo {
    private Object _sourceObject = null;
    private String _strPhase;
    private List<Object> _argumentList;
    private List<LogRecord> _childRecordsList;
    private int _lineNo = -1;
    private int _colNo = -1;

    public LogInfo(String string) {
        this(null, string, -1, -1);
    }

    public LogInfo(Object object, String string) {
        this(object, string, -1, -1);
    }

    public LogInfo(Object object, int n, int n2) {
        this(object, "", n, n2);
    }

    public LogInfo(Object object, String string, int n, int n2) {
        this._lineNo = n;
        this._colNo = n2;
        this._sourceObject = object;
        this._strPhase = string;
        this._argumentList = new ArrayList<Object>();
        this._childRecordsList = new ArrayList<LogRecord>();
    }

    public String toString() {
        if (this._sourceObject != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._sourceObject instanceof PersistableObject) {
                PersistableObject persistableObject = (PersistableObject)this._sourceObject;
                stringBuffer.append(persistableObject.getObjectName()).append(", ").append(persistableObject.getObjectType()).append(", ").append(persistableObject.getKey());
            } else {
                stringBuffer.append(this._sourceObject.toString());
            }
            if (this._strPhase != null) {
                stringBuffer.append(this._strPhase);
            }
            return stringBuffer.toString();
        }
        return super.toString();
    }

    public int getColNo() {
        return this._colNo;
    }

    public int getLineNo() {
        return this._lineNo;
    }

    public Object getSourceObject() {
        return this._sourceObject;
    }

    public void addSupplementaryInfo(Object object) {
        this._argumentList.add(object);
    }

    public List<Object> getSupplementaryInfo() {
        return this._argumentList;
    }

    public void addChild(LogRecord logRecord) {
        this._childRecordsList.add(logRecord);
    }

    public List<LogRecord> getChildRecords() {
        return this._childRecordsList;
    }

    public boolean hasChildren() {
        return this._childRecordsList.size() > 0;
    }

    public String getSourceDisplayString() {
        return this._strPhase;
    }
}

