/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.actions.Messages;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;
import oracle.dbtools.migration.workbench.core.ui.IdentifierMappingPanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.util.Assert;

public class DataTypeMapAction
extends AbstractMenuAction {
    private static Logger s_logger = Logger.getLogger(DataTypeMapAction.class.getName());

    public void launch() {
        SupportedDataTypesMap supportedDataTypesMap = this.getSupportedDataTypeMap();
        DataTypeSpecification[] dataTypeSpecificationArray = this.getDataTypesInUse();
        final DataMapPanel dataMapPanel = new DataMapPanel(supportedDataTypesMap, dataTypeSpecificationArray);
        dataMapPanel.setPersistedRules(this.getCurrentDataTypeRules());
        int n = 14;
        String string = MigrationAddinArb.getString("DATA_IDENTIFIER_TITLE");
        final IdentifierMappingPanel identifierMappingPanel = null;
        String string2 = MigrationAddinArb.getString("DATA_MAPPING_TAB");
        String string3 = MigrationAddinArb.getString("IDENTIFIER_MAPPING_TAB");
        JPanel[] jPanelArray = new JPanel[]{dataMapPanel, identifierMappingPanel};
        String[] stringArray = new String[]{string2, string3};
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "apply") {
                    DBObject dBObject = DataTypeMapAction.this.getDBObject();
                    DBObjectId dBObjectId = null;
                    Object object = actionEvent.getSource();
                    if (object instanceof JEWTDialog) {
                        JEWTDialog jEWTDialog = (JEWTDialog)object;
                        dBObjectId = dataMapPanel.save(dBObject);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                identifierMappingPanel.save();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                    if (dBObjectId != null) {
                        ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                    }
                }
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DBObject dBObject = DataTypeMapAction.this.getDBObject();
                Object object = changeEvent.getSource();
                if (object instanceof JTabbedPane) {
                    int n = ((JTabbedPane)object).getSelectedIndex();
                    if (n == 0) {
                        if (identifierMappingPanel.isInitialized()) {
                            identifierMappingPanel.save();
                        }
                    } else if (n == 1) {
                        dataMapPanel.save(dBObject);
                        if (!identifierMappingPanel.isInitialized()) {
                            identifierMappingPanel.init();
                        }
                    }
                }
            }
        };
        JEWTDialog jEWTDialog = UIUtils.createTabbedPanelDialog((JPanel[])jPanelArray, (String[])stringArray, (String)string, (ActionListener)actionListener, null, (ChangeListener)changeListener);
        jEWTDialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                    identifierMappingPanel.cleanUp();
                }
            }
        });
        jEWTDialog.runDialog();
    }

    private SupportedDataTypesMap getSupportedDataTypeMap() {
        SupportedDataTypesMap supportedDataTypesMap = null;
        try {
            DBObject dBObject = this.getDBObject();
            CapturedConnectionNode capturedConnectionNode = (CapturedConnectionNode)dBObject.getElement();
            MdConnection mdConnection = capturedConnectionNode.getMdConnection();
            String string = mdConnection.getProperty("PLUGIN_ID");
            if (string == null) {
                return null;
            }
            MigrationPlugin migrationPlugin = MigrationAddin.findPlugin(string);
            if (migrationPlugin == null) {
                Assert.println((String)(Messages.getString("DataTypeMapAction.0") + string));
                return null;
            }
            supportedDataTypesMap = migrationPlugin.getSupportedDataTypesMap();
        }
        catch (MigrationPluginException migrationPluginException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, migrationPluginException.getStackTrace()[0].toString(), migrationPluginException);
            return null;
        }
        return supportedDataTypesMap;
    }

    private DataTypeMappingRule[] getCurrentDataTypeRules() {
        MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)this.getDBObject().getElement().getData();
        DBObjectId dBObjectId = migrationConnectionNode.getMdConnection().getKey();
        DataTypeConversionMap dataTypeConversionMap = null;
        try {
            dataTypeConversionMap = ConvertUtils.getPersistedMap(MigrationAddin.getPersistenceManager(), dBObjectId);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, persistenceException.getMessage());
            return new DataTypeMappingRule[0];
        }
        Collection<DataTypeMappingRule> collection = dataTypeConversionMap.values();
        DataTypeMappingRule[] dataTypeMappingRuleArray = new DataTypeMappingRule[collection.size()];
        int n = 0;
        for (DataTypeMappingRule dataTypeMappingRule : collection) {
            dataTypeMappingRuleArray[n++] = dataTypeMappingRule;
        }
        return dataTypeMappingRuleArray;
    }

    private DataTypeSpecification[] getDataTypesInUse() {
        DBObject dBObject = this.getDBObject();
        CapturedConnectionNode capturedConnectionNode = (CapturedConnectionNode)dBObject.getElement();
        MdConnection mdConnection = capturedConnectionNode.getMdConnection();
        try {
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
            String[] stringArray = persistenceUtility.getAllDataTypesForConnection(mdConnection.getKey());
            DataTypeSpecification[] dataTypeSpecificationArray = new DataTypeSpecification[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dataTypeSpecificationArray[i] = new DataTypeSpecification(stringArray[i]);
            }
            return dataTypeSpecificationArray;
        }
        catch (PersistenceException persistenceException) {
            s_logger.warning(persistenceException.getMessage());
            return null;
        }
    }

    public void setArgs(String string) {
    }
}

