/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.OfflineCaptureWorker;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.convert.XMLSupportedDataTypesMap;
import oracle.dbtools.migration.core.util.RaptorGroupLoader;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.offline.streams.ExternalTableDMStream;
import oracle.dbtools.migration.datamove.offline.streams.Offline3rdPartyDMSAbstract;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;
import oracle.dbtools.migration.datamove.offline.streams.SQLLoaderDMStream;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveDrone;
import oracle.dbtools.migration.workbench.core.AbstractQuoter;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.xml.sax.SAXException;

public abstract class AbstractMigrationPlugin
implements MigrationPlugin {
    private SupportedDataTypesMap m_supportedDataTypesMap;
    private StringTemplateGroup m_templateGroup;

    @Override
    public abstract String getPlatformName();

    @Override
    public abstract String getPluginName();

    @Override
    public abstract String getVersionNumber();

    @Override
    public abstract MigrationPluginPreferences getPreferencePanel();

    public void initialize() {
    }

    protected String extractTblName(String string) {
        String string2 = string;
        if (string != null && string.trim().length() != 0) {
            string2 = string.substring(string.lastIndexOf(File.separator) + 1);
        }
        return string2;
    }

    protected String extractDir(String string) {
        String string2 = string;
        if (string != null && string.trim().length() != 0) {
            string2 = string.substring(0, string.lastIndexOf(File.separator));
        }
        return string2;
    }

    private void registerPreferencesPanel() {
        MigrationPluginPreferences migrationPluginPreferences = this.getPreferencePanel();
        if (migrationPluginPreferences != null) {
            // empty if block
        }
    }

    public abstract void registerMenuItems();

    protected String getSupportedMapsXMLFileName() {
        return "SupportedDataTypesMap.xml";
    }

    protected void loadSupportedDataTypesMap() throws MigrationPluginException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getSupportedMapsXMLFileName());
        try {
            this.m_supportedDataTypesMap = new XMLSupportedDataTypesMap(inputStream);
        }
        catch (SAXException sAXException) {
            throw new MigrationPluginException(sAXException);
        }
        catch (IOException iOException) {
            throw new MigrationPluginException(iOException);
        }
    }

    @Override
    public SupportedDataTypesMap getSupportedDataTypesMap() throws MigrationPluginException {
        if (this.m_supportedDataTypesMap == null) {
            this.loadSupportedDataTypesMap();
        }
        return this.m_supportedDataTypesMap;
    }

    @Override
    public abstract MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String var1, int var2, int var3, String var4);

    @Override
    public Icon getIcon() {
        String string = this.getIconFileName();
        if (string == null) {
            return null;
        }
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            ImageIcon imageIcon = new ImageIcon(uRL);
            return imageIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getIconFileName() {
        return null;
    }

    @Override
    public Quoter getQuoter() {
        return new AbstractQuoter();
    }

    @Override
    public String createDataFileName(String string, String string2) {
        return string + ".dat";
    }

    @Override
    public String maybeQuoteSqlldrFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        return mdColumn2.getColumnName();
    }

    @Override
    public boolean usesClobToBlob() {
        return false;
    }

    @Override
    public boolean usesIOT() {
        return false;
    }

    @Override
    public MigrationPlugin.ProjectMergeLevel getMergeProjectSupportLevel() {
        return MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_NONE;
    }

    @Override
    public boolean doIReturnUnloadScripts() {
        return true;
    }

    @Override
    public int getPlatformMask() {
        return 0;
    }

    @Override
    public OfflineCapturer getOfflineCapturer() {
        return null;
    }

    @Override
    public OfflineCaptureWorker getOfflineCaptureWorker(OfflineCapturer offlineCapturer, String string, String string2) {
        return null;
    }

    @Override
    public StatementProvider getStatementProviderForDataMove() {
        return new StatementProvider();
    }

    @Override
    public String getDataMoveColumnDelimiter() {
        return MigrationAddin.getMigrationConfig().getEndColumnDelimiter();
    }

    @Override
    public String getDataMoveRowDelimiter() {
        return MigrationAddin.getMigrationConfig().getEndRowDelimiter();
    }

    @Override
    public Offline3rdPartyDMSAbstract getOffline3rdPartyPrintStream(String string, String string2) {
        return null;
    }

    @Override
    public OfflineDMSAbstract getSQLLoaderDMStream(String string, String string2) {
        return new SQLLoaderDMStream(string2);
    }

    @Override
    public OfflineDMSAbstract getExternalLoaderDMStream(String string, String string2) {
        return new ExternalTableDMStream(string2);
    }

    @Override
    public Object[] generateExternalTableColumnDefinitions(MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        Object[] objectArray = null;
        return objectArray;
    }

    @Override
    public String generateExternalColumnDefinitions(MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return null;
    }

    @Override
    public String generateExternalSelectColumnList(MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return null;
    }

    @Override
    public StringTemplate getLoadCtlStatementTemplate() {
        return null;
    }

    @Override
    public void setConnectStatement(Offline3rdPartyDMSAbstract offline3rdPartyDMSAbstract) {
    }

    @Override
    public DataMoveDrone getDataMoveDrone(String string, DataMoveMarshal dataMoveMarshal, Connection connection, Connection connection2, Quoter quoter, StatementProvider statementProvider, boolean bl, int n, DataMoveAudience dataMoveAudience, boolean bl2) {
        return new DataMoveDrone(string, dataMoveMarshal, connection, connection2, quoter, statementProvider, bl, n, dataMoveAudience, bl2);
    }

    protected void loadPluginTemplates(String string, ClassLoader classLoader, String string2) {
        RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader(string, classLoader);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        this.m_templateGroup = StringTemplateGroup.loadGroup((String)string2);
    }

    protected StringTemplateGroup getPluginTemplateGroup() {
        return this.m_templateGroup;
    }
}

