/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.migration.datamove.online.DataMoveDrone;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.datamove.online.DroneState;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.datamove.online.ProgressCellRenderer;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;

public class DataMoveGui
implements DataMoveListener {
    private static final String[] S_CURRENT_ACTIVITY_HEADINGS = new String[]{MigrationAddinArb.getString("DATAMOVE_PROG_THREAD"), MigrationAddinArb.getString("DATAMOVE_PROG_TABLE"), MigrationAddinArb.getString("DATAMOVE_PROG_STATE"), MigrationAddinArb.getString("DATAMOVE_PROG_ROWSDONE"), MigrationAddinArb.getString("DATAMOVE_PROG_TOTALROWS"), MigrationAddinArb.getString("DATAMOVE_PROG_CURRENT_ERRORS"), MigrationAddinArb.getString("DATAMOVE_PROG_TOTAL_ERRORS")};
    private static final String[] S_FINISHED_ACTIVITY_HEADINGS = new String[]{MigrationAddinArb.getString("DATAMOVE_PROG_TABLE"), MigrationAddinArb.getString("DATAMOVE_PROG_ROWSDONE"), MigrationAddinArb.getString("DATAMOVE_PROG_TOTALROWS"), MigrationAddinArb.getString("DATAMOVE_PROG_CURRENT_ERRORS"), MigrationAddinArb.getString("DATAMOVE_PROG_TOTAL_ERRORS")};
    private JPanel m_currentActivityPanel;
    private JTable m_currentActiviyTable;
    private DefaultTableModel m_currentActivityTableModel;
    private JPanel m_finishedActivityPanel;
    private JTable m_finishedActivityTable;
    private DefaultTableModel m_finishedActivityTableModel = new DefaultTableModel();

    public String[] getColumnNames() {
        return S_CURRENT_ACTIVITY_HEADINGS;
    }

    public String[] getBelowColumnNames() {
        return S_FINISHED_ACTIVITY_HEADINGS;
    }

    public void setTableCellRenderer() {
    }

    public int getPanelWidth() {
        return 500;
    }

    public JPanel getCurrentActivityPanel() {
        if (this.m_currentActivityPanel == null) {
            this.m_currentActivityPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(5);
            this.m_currentActivityPanel.setLayout(borderLayout);
            this.m_currentActivityPanel.setPreferredSize(new Dimension(this.getPanelWidth(), 125));
            JScrollPane jScrollPane = new JScrollPane();
            this.m_currentActivityPanel.add((Component)jScrollPane, "Center");
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            this.m_currentActivityTableModel = new DefaultTableModel(null, S_CURRENT_ACTIVITY_HEADINGS){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.m_currentActiviyTable = new JTable(){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    Object object;
                    String string = null;
                    Point point = mouseEvent.getPoint();
                    int n = this.rowAtPoint(point);
                    int n2 = this.columnAtPoint(point);
                    int n3 = this.convertColumnIndexToModel(n2);
                    if ((n3 > 0 || n3 < 7) && (object = this.getValueAt(n, 1)) != null) {
                        string = object.toString();
                    }
                    return string;
                }
            };
            this.m_currentActiviyTable.setModel(this.m_currentActivityTableModel);
            ProgressCellRenderer progressCellRenderer = new ProgressCellRenderer();
            TableColumnModel tableColumnModel = this.m_currentActiviyTable.getColumnModel();
            tableColumnModel.getColumn(3).setCellRenderer(progressCellRenderer);
            jScrollPane.setViewportView(this.m_currentActiviyTable);
            this.setTableCellRenderer();
            JLabel jLabel = new JLabel();
            jLabel.setText(MigrationAddinArb.getString("DATAMOVE_CURRENT_TABLES_LABEL"));
            this.m_currentActivityPanel.add((Component)jLabel, "North");
        }
        return this.m_currentActivityPanel;
    }

    public JPanel getCompletedActivityPanel() {
        if (this.m_finishedActivityPanel == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(5);
            this.m_finishedActivityPanel = new JPanel(borderLayout);
            this.m_finishedActivityPanel.setPreferredSize(new Dimension(this.getPanelWidth(), 125));
            JLabel jLabel = new JLabel();
            jLabel.setText(MigrationAddinArb.getString("DATAMOVE_COMPLETED_TABLES_LABEL"));
            this.m_finishedActivityPanel.add((Component)jLabel, "North");
            JScrollPane jScrollPane = new JScrollPane();
            this.m_finishedActivityPanel.add((Component)jScrollPane, "Center");
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            Object[] objectArray = this.getBelowColumnNames();
            this.m_finishedActivityTableModel = new DefaultTableModel(null, objectArray){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.m_finishedActivityTable = new JTable(){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    String string = null;
                    Point point = mouseEvent.getPoint();
                    int n = this.rowAtPoint(point);
                    int n2 = this.columnAtPoint(point);
                    int n3 = this.convertColumnIndexToModel(n2);
                    if (n3 > 0 || n3 < 4) {
                        string = this.getValueAt(n, 0).toString();
                    }
                    return string;
                }
            };
            jScrollPane.setViewportView(this.m_finishedActivityTable);
            this.m_finishedActivityTable.setModel(this.m_finishedActivityTableModel);
        }
        return this.m_finishedActivityPanel;
    }

    @Override
    public void raiseEvent(final DataMoveEvent dataMoveEvent) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    try {
                        int n = 0;
                        if (dataMoveEvent.getEventId() == 3) {
                            DroneState droneState;
                            DataMoveDrone dataMoveDrone = (DataMoveDrone)dataMoveEvent.getSupplementaryData();
                            if (dataMoveDrone == null || (droneState = dataMoveDrone.getState()).getCurrentTable().length() == 0) break block9;
                            Vector<String> vector = new Vector<String>();
                            vector.add(droneState.getCurrentTable());
                            vector.add(new Long(droneState.getRowsMoved()).toString());
                            Object object = droneState.getTableRowCount() == -1L ? Messages.getString("DataMoveGui.0") : Long.valueOf(droneState.getTableRowCount());
                            vector.add(object.toString());
                            vector.add(new Long(droneState.getThisErrorCount()).toString());
                            vector.add(new Long(droneState.getTotalErrorCount()).toString());
                            DefaultTableModel defaultTableModel = DataMoveGui.this.m_finishedActivityTableModel;
                            synchronized (defaultTableModel) {
                                DataMoveGui.this.m_finishedActivityTableModel.addRow(vector);
                            }
                            DataMoveGui.this.m_finishedActivityTable.scrollRectToVisible(DataMoveGui.this.m_finishedActivityTable.getCellRect(DataMoveGui.this.m_finishedActivityTableModel.getRowCount() - 1, 0, true));
                            DataMoveGui.this.m_finishedActivityTableModel.fireTableDataChanged();
                            break block9;
                        }
                        DroneState[] droneStateArray = (DroneState[])dataMoveEvent.getSupplementaryData();
                        if (droneStateArray != null) {
                            while (DataMoveGui.this.m_currentActivityTableModel.getRowCount() < droneStateArray.length) {
                                Object[] objectArray = new Object[DataMoveGui.this.getColumnNames().length];
                                DataMoveGui.this.m_currentActivityTableModel.addRow(objectArray);
                            }
                            DataMoveGui.this.m_currentActivityTableModel.fireTableDataChanged();
                            for (int i = 0; i < droneStateArray.length; ++i) {
                                n += droneStateArray[i].getTotalTablesMoved();
                                DataMoveGui.this.m_currentActivityTableModel.setValueAt(droneStateArray[i].getId(), i, 0);
                                DataMoveGui.this.m_currentActivityTableModel.setValueAt(droneStateArray[i].getCurrentTable(), i, 1);
                                DataMoveGui.this.m_currentActivityTableModel.setValueAt(droneStateArray[i].getProcessState(), i, 2);
                                DataMoveGui.this.m_currentActivityTableModel.setValueAt(droneStateArray[i].getRowsMoved(), i, 3);
                                DataMoveGui.this.m_currentActivityTableModel.setValueAt(droneStateArray[i].getTableRowCount() == -1L ? Messages.getString("DataMoveGui.1") : Long.valueOf(droneStateArray[i].getTableRowCount()), i, 4);
                                DataMoveGui.this.m_currentActivityTableModel.setValueAt(droneStateArray[i].getThisErrorCount(), i, 5);
                                DataMoveGui.this.m_currentActivityTableModel.setValueAt(droneStateArray[i].getTotalErrorCount(), i, 6);
                            }
                            DataMoveGui.this.m_currentActivityTableModel.fireTableDataChanged();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

