/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public class ConstraintHandler {
    protected static final int ORA_ERR_NO_SUCH_CONSTAINT = 2431;
    private static final String QUERY_FIND_CONSTRAINTS = "SELECT A.SCHEMA_NAME, A.TABLE_NAME, B.NAME, B.CONSTRAINT_TYPE, DECODE(B.CONSTRAINT_TYPE, 'CHECK', 1, 'FOREIGN KEY',2, 'PK', 3, 'UNIQUE', 4) CONSCODE, B.ID FROM MGV_ALL_TABLES A, MD_CONSTRAINTS B WHERE A.TABLE_ID = B.TABLE_ID_FK AND A.CONNECTION_ID = ? ORDER BY CONSCODE";
    protected ArrayList<ConstraintDetail> m_disabledConstraints;
    protected DBObjectId m_connectionId;
    protected PersistenceManager m_persistenceManager;

    public ConstraintHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
        this.m_connectionId = dBObjectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableConstraints(Connection connection, boolean bl) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(Messages.getString("ConstraintHandler.4"));
        }
        this.m_disabledConstraints = new ArrayList();
        try (CloseableResultSet closeableResultSet = null;){
            PreparedStatement preparedStatement = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_CONSTRAINTS);
            preparedStatement.setLong(1, this.m_connectionId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                ConstraintDetail constraintDetail = new ConstraintDetail(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3));
                try {
                    try {
                        if (MdConstraint.retrieveExistingInstance(this.m_persistenceManager, new DBObjectId(resultSet.getLong(6))).getProperty("DO_NOT_ENABLE_DISABLE") != null) continue;
                        if (connection != null) {
                            ConstraintHandler.disableDetail(constraintDetail, connection, bl);
                        }
                        this.m_disabledConstraints.add(constraintDetail);
                    }
                    catch (PersistenceException persistenceException) {
                        MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{Messages.getString("ConstraintHandler.8"), new LogInfo(Messages.getString("ConstraintHandler.9"))}, (Throwable)persistenceException);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{Messages.getString("ConstraintHandler.8"), new LogInfo(Messages.getString("ConstraintHandler.9"))}, (Throwable)noSuchObjectException);
                    }
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 2431) continue;
                    MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{Messages.getString("ConstraintHandler.8"), new LogInfo(Messages.getString("ConstraintHandler.9"))}, (Throwable)sQLException);
                }
            }
        }
    }

    void reenableConstraints(Connection connection, boolean bl) {
        if (connection == null) {
            throw new IllegalArgumentException(Messages.getString("ConstraintHandler.10"));
        }
        while (this.m_disabledConstraints.size() > 0) {
            ConstraintDetail constraintDetail = this.m_disabledConstraints.remove(this.m_disabledConstraints.size() - 1);
            try {
                if (connection == null) continue;
                ConstraintHandler.enableDetail(constraintDetail, connection, bl);
            }
            catch (SQLException sQLException) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, "DataMove.ENABLE_CONSTRAINT_FAILED", sQLException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void disableDetail(ConstraintDetail constraintDetail, Connection connection, boolean bl) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate(constraintDetail.toOracleDisableString(bl));
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableDetail(ConstraintDetail constraintDetail, Connection connection, boolean bl) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate(constraintDetail.toOracleEnableString(bl));
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public static class ConstraintDetail {
        private String m_schemaName;
        private String m_tableName;
        private String m_constraintName;

        public ConstraintDetail(String string, String string2, String string3) {
            this.setSchemaName(string);
            this.setTableName(string2);
            this.setConstraintName(string3);
        }

        public String getConstraintName() {
            return this.m_constraintName;
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public String getSchemaName() {
            return this.m_schemaName;
        }

        protected void setConstraintName(String string) {
            this.m_constraintName = string;
        }

        protected void setTableName(String string) {
            this.m_tableName = string;
        }

        protected void setSchemaName(String string) {
            this.m_schemaName = string;
        }

        private String toOracleAlterStatement(boolean bl, boolean bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ALTER TABLE ");
            if (bl) {
                stringBuffer.append(this.getSchemaName());
                stringBuffer.append('.');
            }
            stringBuffer.append(this.getTableName());
            stringBuffer.append(' ');
            if (bl2) {
                stringBuffer.append("ENABLE");
            } else {
                stringBuffer.append("DISABLE");
            }
            stringBuffer.append(" CONSTRAINT ");
            stringBuffer.append(this.getConstraintName());
            return stringBuffer.toString();
        }

        public String toOracleDisableString(boolean bl) {
            return this.toOracleAlterStatement(bl, false);
        }

        public String toOracleEnableString(boolean bl) {
            return this.toOracleAlterStatement(bl, true);
        }
    }
}

