/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public abstract class DataMoveUtils {
    private static final String QUERY_LOAD_DESCRIPTOR = "SELECT DERIVED_TYPE, DERIVED_ID, SRC_ID FROM MD_COLUMNS INNER JOIN MD_DERIVATIVES ON TABLE_ID_FK = ? AND MD_DERIVATIVES.DERIVED_ID= MD_COLUMNS.ID  UNION  SELECT DERIVED_TYPE, DERIVED_ID, SRC_ID FROM MD_DERIVATIVES WHERE DERIVED_ID=?";
    private static final String GET_DERIVED_NAMES_QUERY = "SELECT ORIGINAL_IDENTIFIER, NEW_IDENTIFIER FROM MD_DERIVATIVES WHERE DERIVED_TYPE = 'MD_COLUMNS' AND SRC_TYPE = 'MD_COLUMNS' AND DERIVED_CONNECTION_ID_FK = ? AND DERIVED_ID IN (SELECT ID FROM MD_COLUMNS WHERE TABLE_ID_FK = ?)";
    private static final String FIND_PLUGIN_QUERY = "SELECT VALUE FROM MD_ADDITIONAL_PROPERTIES WHERE PROP_KEY = 'PLUGIN_ID' AND CONNECTION_ID_FK = REF_ID_FK AND CONNECTION_ID_FK IN  (SELECT SRC_ID FROM MD_DERIVATIVES WHERE DERIVED_ID = ?   AND SRC_TYPE = 'MD_CONNECTIONS' AND DERIVED_TYPE = 'MD_CONNECTIONS')";

    private DataMoveUtils() {
    }

    public static LinkedHashMap<String, String> getMappedColumnNames(PersistenceManager persistenceManager, DBObjectId dBObjectId, DBObjectId dBObjectId2) throws PersistenceException {
        try (CloseableResultSet closeableResultSet = null;){
            Object object;
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(GET_DERIVED_NAMES_QUERY);
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setLong(2, dBObjectId2.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                String string = resultSet.getString(2);
                linkedHashMap.put(string, object);
            }
            closeableResultSet.close();
            object = linkedHashMap;
            return object;
        }
    }

    public static Hashtable<String, Integer> getColumnTypes(String string, Connection connection) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from ");
        stringBuffer.append(string);
        stringBuffer.append(" where 1=0");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            hashtable.put(resultSetMetaData.getColumnName(i).toUpperCase(), resultSetMetaData.getColumnType(i));
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MigrationPlugin findPluginUsed(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        Object object;
        String string = null;
        try (CloseableResultSet closeableResultSet = null;){
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(FIND_PLUGIN_QUERY);
            preparedStatement.setLong(1, dBObjectId.getId());
            object = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, (ResultSet)object);
            object.next();
            string = object.getString(1);
        }
        if (string == null) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").severe(Messages.getString("DataMoveUtils.17"));
            return null;
        }
        object = MigrationAddin.findPlugin(string);
        if (object == null) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").severe(Messages.getString("DataMoveUtils.18"));
            return null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataMoveDescriptor loadDescriptor(PersistenceManager persistenceManager, DBObjectId dBObjectId, DBObjectId dBObjectId2) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        MdTable mdTable = null;
        MdTable mdTable2 = null;
        MdSchema mdSchema = null;
        MdSchema mdSchema2 = null;
        DataMoveDescriptor dataMoveDescriptor = null;
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(QUERY_LOAD_DESCRIPTOR);
            preparedStatement.setLong(1, dBObjectId.getId());
            preparedStatement.setLong(2, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            LinkedHashMap<MdColumn, MdColumn> linkedHashMap = new LinkedHashMap<MdColumn, MdColumn>();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                Long l = resultSet.getLong(2);
                Long l2 = resultSet.getLong(3);
                if (string.equals("MD_TABLES")) {
                    try {
                        mdTable = MdTable.retrieveExistingInstance(persistenceManager, new DBObjectId(l2));
                        mdSchema = MdSchema.retrieveExistingInstance(persistenceManager, mdTable.getSchemaId());
                        mdTable2 = MdTable.retrieveExistingInstance(persistenceManager, new DBObjectId(l));
                        mdSchema2 = MdSchema.retrieveExistingInstance(persistenceManager, mdTable2.getSchemaId());
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("DataMoveUtils.19"), (Throwable)noSuchObjectException);
                    }
                    continue;
                }
                if (!string.equals("MD_COLUMNS")) continue;
                try {
                    linkedHashMap.put(MdColumn.retrieveExistingInstance(persistenceManager, new DBObjectId(l)), MdColumn.retrieveExistingInstance(persistenceManager, new DBObjectId(l2)));
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("DataMoveUtils.20"), (Throwable)noSuchObjectException);
                }
            }
            if (mdTable == null || mdSchema == null || mdTable2 == null || mdTable2 == null || linkedHashMap == null || linkedHashMap.size() == 0) {
                MigrationLogUtil.logThrowable(Messages.getString("DataMoveUtils.21"), Messages.getString("DataMoveUtils.21"), null);
            } else {
                dataMoveDescriptor = new DataMoveDescriptor(mdSchema, mdTable, mdSchema2, mdTable2);
                dataMoveDescriptor.setColumnMap(linkedHashMap);
            }
        }
        catch (SQLException sQLException) {
            MigrationLogUtil.logThrowable(sQLException.getLocalizedMessage(), Messages.getString("DataMoveUtils.22"), (Throwable)sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
        return dataMoveDescriptor;
    }
}

