/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import oracle.dbtools.migration.convert.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;

public class DataTypeSpecification {
    protected String m_name;
    protected Integer m_precision;
    protected Integer m_scale;

    public String getName() {
        return this.m_name;
    }

    protected void setName(String string) {
        this.m_name = string;
    }

    public Integer getPrecision() {
        return this.m_precision;
    }

    public void setPrecision(Integer n) {
        this.m_precision = n;
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public void setScale(Integer n) {
        this.m_scale = n;
    }

    public DataTypeSpecification(String string) {
        this(string, null, null);
    }

    public DataTypeSpecification(String string, int n) {
        this(string, (Integer)n, null);
    }

    public DataTypeSpecification(String string, int n, int n2) {
        this(string, (Integer)n, (Integer)n2);
    }

    public DataTypeSpecification(String string, Integer n, Integer n2) {
        if (n == null && n2 != null) {
            throw new IllegalArgumentException(Messages.getString("DataTypeSpecification.0"));
        }
        this.setName(string);
        this.setPrecision(n);
        this.setScale(n2);
    }

    public DataTypeSpecification(DataTypeSpecification dataTypeSpecification) {
        this(dataTypeSpecification.m_name, dataTypeSpecification.m_precision, dataTypeSpecification.m_scale);
    }

    public boolean hasPrecision() {
        return this.m_precision != null;
    }

    public boolean hasScale() {
        return this.m_scale != null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.toUpperCase().hashCode());
        n = 31 * n + (this.m_precision == null ? 0 : this.m_precision.hashCode());
        n = 31 * n + (this.m_scale == null ? 0 : this.m_scale.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataTypeSpecification dataTypeSpecification = (DataTypeSpecification)object;
        if (this.m_name == null ? dataTypeSpecification.m_name != null : !this.m_name.equalsIgnoreCase(dataTypeSpecification.m_name)) {
            return false;
        }
        if (this.m_precision == null ? dataTypeSpecification.m_precision != null : !this.m_precision.equals(dataTypeSpecification.m_precision)) {
            return false;
        }
        return !(this.m_scale == null ? dataTypeSpecification.m_scale != null : !this.m_scale.equals(dataTypeSpecification.m_scale));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        if (this.hasPrecision()) {
            stringBuffer.append('[');
            Integer n = this.getPrecision();
            if (n == -999) {
                stringBuffer.append(MigrationAddinArb.getString("MAX"));
            } else {
                stringBuffer.append(this.getPrecision().toString());
            }
            if (this.hasScale()) {
                stringBuffer.append(',');
                stringBuffer.append(this.getScale().toString());
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }
}

