/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.DerivativesIterator;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdMigrParameter;
import oracle.dbtools.metadata.persistence.MdPackage;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.MgvAllConnectionsRec;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.MgvAllStoredProgramsRec;
import oracle.dbtools.metadata.persistence.MgvAllTableTriggersRec;
import oracle.dbtools.metadata.persistence.MgvAllViewTriggersRec;
import oracle.dbtools.metadata.persistence.MgvAllViewsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PropertyBasedPersitableObjectIterator;
import oracle.dbtools.metadata.persistence.TextIndexesIterator;
import oracle.dbtools.migration.convert.ConvertAudience;
import oracle.dbtools.migration.convert.ConvertContext;
import oracle.dbtools.migration.convert.ConvertEvent;
import oracle.dbtools.migration.convert.ConvertEventListener;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.convert.Messages;
import oracle.dbtools.migration.convert.NoCopyFoundException;
import oracle.dbtools.migration.convert.ObjectTranslationList;
import oracle.dbtools.migration.convert.TextMappingResult;
import oracle.dbtools.migration.convert.TextMappingRuleSet;
import oracle.dbtools.migration.convert.TransformDefaultWrapper;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.convert.TranslationLogging;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.core.util.MultiLevelLogManager;
import oracle.dbtools.migration.core.util.StopWatch;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.persistence.MigrGenerationOrder;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.ITranslationMetaData;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.dbtools.migration.translation.api.TranslationResult;
import oracle.dbtools.migration.translation.api.TranslationSession;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogPhase;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class ConverterWorker
implements Cancelable,
ITranslationManager {
    private static final String QUERY_COLS_WITH_DEFAULTS = "SELECT ID,DEFAULT_VALUE FROM MD_COLUMNS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?) AND DEFAULT_VALUE IS NOT NULL";
    private static final String SELECT_COMMENTS_QUERY_RENAMED_TABLES = "SELECT COMMENTS FROM MD_TABLES WHERE ID=?";
    private static final String SELECT_COMMENTS_QUERY_RENAMED_COLS = "SELECT COMMENTS FROM MD_COLUMNS WHERE ID=?";
    private static final String UPDATE_COMMENTS_QUERY_RENAMED_TABLES = "UPDATE MD_TABLES SET COMMENTS=? WHERE ID=?";
    private static final String UPDATE_COMMENTS_QUERY_RENAMED_COLS = "UPDATE MD_COLUMNS SET COMMENTS=? WHERE ID=?";
    private static final String HALFCONVERTED = "/*HALF CONVERTED*/";
    public static final String FULLCONVERTED = "/*CONVERTED COMPLETE*/";
    private ConvertContext m_context = new ConvertContext();
    private DBObjectId m_sourceConnectionId;
    private DBObjectId m_convertedConnectionId;
    private MdConnection m_convertedConnection;
    private DBObjectId m_mapId;
    private PersistenceManager m_persistenceManager;
    private Converter m_platformConverter;
    private ConvertAudience m_audience;
    private TranslationSession m_translationSession;
    private int m_generationOrder;
    private HashSet<DBObjectId> m_translatedTargetObjects;
    private HashSet<DBObjectId> m_translatedSourceObjects;
    private boolean m_targettingMultibyte = true;
    private Stack<Long> m_translatingObjects = new Stack();
    private MigrationObjectFilterList m_filterList;
    private static Logger s_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle", "oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private ITranslationLogging m_translationLogging = null;
    private MultiLevelLogManager m_translationLogManager = new MultiLevelLogManager();
    private ArrayList<String> m_tableAndViewTriggers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterWorker(PersistenceManager persistenceManager, DBObjectId dBObjectId, Converter converter, DBObjectId dBObjectId2, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        this.setPersistenceManager(persistenceManager);
        this.setSourceConnectionId(dBObjectId);
        this.setPlatformConverter(converter);
        this.setMapId(dBObjectId2);
        this.setFilterList(migrationObjectFilterList);
        this.m_audience = new ConvertAudience();
        this.m_generationOrder = 0;
        Connection connection = persistenceManager.getConn();
        if (Connections.getInstance().lock(connection)) {
            try {
                try {
                    if (connection.getMetaData().getDriverMajorVersion() > 11) {
                        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"NAMELIST", (Connection)connection, (boolean)true, (boolean)true);
                        ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)"OBJECTIDLIST", (Connection)connection, (boolean)true, (boolean)true);
                        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)"NAME_AND_COUNT_T", (Connection)connection, (boolean)true, (boolean)true);
                        ArrayDescriptor arrayDescriptor3 = ArrayDescriptor.createDescriptor((String)"MIGR_FILTER_SET", (Connection)connection, (boolean)true, (boolean)true);
                        StructDescriptor structDescriptor2 = StructDescriptor.createDescriptor((String)"MIGR_FILTER", (Connection)connection, (boolean)true, (boolean)true);
                        ArrayDescriptor arrayDescriptor4 = ArrayDescriptor.createDescriptor((String)"NAME_AND_COUNT_ARRAY", (Connection)connection, (boolean)true, (boolean)true);
                    }
                }
                catch (SQLException sQLException) {
                    MigrationLogUtil.logThrowable(sQLException.getLocalizedMessage(), Messages.getString("ConvertLoadTypeCache"), (Throwable)sQLException);
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public ConverterWorker(PersistenceManager persistenceManager, DBObjectId dBObjectId, Converter converter, DBObjectId dBObjectId2, MigrationObjectFilterList migrationObjectFilterList, MdConnection mdConnection) throws PersistenceException {
        this(persistenceManager, dBObjectId, converter, dBObjectId2, migrationObjectFilterList);
        this.m_convertedConnection = mdConnection;
        this.m_convertedConnectionId = this.m_convertedConnection.getKey();
    }

    private void setFilterList(MigrationObjectFilterList migrationObjectFilterList) {
        this.m_filterList = migrationObjectFilterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runConvert() throws PersistenceException, ConvertException {
        ConvertEvent convertEvent = new ConvertEvent(19, "", "");
        this.getAudience().fireListeners(convertEvent);
        if (this.shouldCancel()) {
            ConvertEvent convertEvent2 = new ConvertEvent(-1, "", "");
            this.getAudience().fireListeners(convertEvent2);
            this.rollbackConvert();
            return false;
        }
        MigrationUtils.setOracleDatabaseLongIdentifier(this.getPersistenceManager().getConn(), this.getClass().getName());
        this.m_translatedTargetObjects = new HashSet();
        this.m_translatedSourceObjects = new HashSet();
        ConvertException convertException = null;
        try {
            if (this.isFullConvertRequired()) {
                this.m_convertedConnectionId = this.copyModel();
                if (this.shouldCancel()) {
                    ConvertEvent convertEvent3 = new ConvertEvent(-1, "COPY", "");
                    this.getAudience().fireListeners(convertEvent3);
                    this.rollbackConvert();
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.reportCoalascedCatalogs();
                    this.reportRemovedIndexes();
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), Messages.getString("ConverterWorker.12"), (Throwable)exception);
                }
                this.transformIdentifiers();
                this.addCommentForTransformedColTabs();
                if (this.shouldCancel()) {
                    ConvertEvent convertEvent4 = new ConvertEvent(-1, "IDENTIFIER TRANSFORM", "");
                    this.getAudience().fireListeners(convertEvent4);
                    this.rollbackConvert();
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.reportTransformedIdentifiers();
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), Messages.getString("ConverterWorker.15"), (Throwable)exception);
                }
                this.transformDataTypes();
                if (this.shouldCancel()) {
                    ConvertEvent convertEvent5 = new ConvertEvent(-1, "DATATYPE TRANSFORM", "");
                    this.getAudience().fireListeners(convertEvent5);
                    this.rollbackConvert();
                    boolean bl = false;
                    return bl;
                }
                this.reportDataTypeTransformResults();
                this.transformDefaults();
                if (this.shouldCancel()) {
                    ConvertEvent convertEvent6 = new ConvertEvent(-1, "DEFAULT TRANSFORM", "");
                    this.getAudience().fireListeners(convertEvent6);
                    this.rollbackConvert();
                    boolean bl = false;
                    return bl;
                }
            } else {
                MigrationLogUtil.startMigrationLogSession(this.getConvertedConnectionId());
                this.setTranslatedSourceObjects();
            }
            this.removeDuplicateForeignKeys();
            this.removeUnwantedUniqueKeys();
            this.checkForUniqueKeyToForeignKeys();
            this.updateStatistics(HALFCONVERTED);
            this.getPersistenceManager().releaseCache();
            if (this.shouldCancel()) {
                ConvertEvent convertEvent7 = new ConvertEvent(-1, "IDENTITY TRANSFORM", "");
                this.getAudience().fireListeners(convertEvent7);
                this.rollbackConvert();
                boolean bl = false;
                return bl;
            }
            this.getPersistenceManager().setCacheOn(false);
            this.transformIdentityColumns();
            this.checkPlatformSpecificConversions();
            this.getPersistenceManager().releaseCache();
            this.finalClashCheck();
            this.rewriteTriggerText();
            this.getPersistenceManager().releaseCache();
            this.updateStatistics(FULLCONVERTED);
            convertEvent.setEventId(20);
            this.getAudience().fireListeners(convertEvent);
            this.getPersistenceManager().releaseCache();
        }
        finally {
            try {
                TranslationContext translationContext = new TranslationContext(this.getPersistenceManager(), this.getConvertedConnectionId(), 100, this.m_mapId);
                this.getEmulationPackages(this.getPlatformConverter().getPlaformTranslator(), translationContext);
            }
            catch (PersistenceException persistenceException) {
                MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), "Convert Exception", (Throwable)persistenceException);
                convertException = new ConvertException(persistenceException);
            }
            this.getPersistenceManager().releaseCache();
        }
        if (convertException != null) {
            throw convertException;
        }
        return true;
    }

    public boolean runTranslate(String[] stringArray) throws ConvertException {
        ConvertEvent convertEvent = null;
        ConvertEvent convertEvent2 = new ConvertEvent(21, "", "");
        this.getAudience().fireListeners(convertEvent2);
        this.m_translatedTargetObjects = new HashSet();
        this.m_translatedSourceObjects = new HashSet();
        ITranslator iTranslator = this.getPlatformConverter().getPlaformTranslator();
        ObjectTranslationList objectTranslationList = this.m_platformConverter.getSupportedTranslationObjects();
        this.m_translationLogging = new TranslationLogging(this.getPersistenceManager(), this.m_translationLogManager);
        if (iTranslator == null) {
            return false;
        }
        TranslationContext translationContext = null;
        try {
            translationContext = new TranslationContext(this.getPersistenceManager(), this.getConvertedConnectionId(), 10000, this.m_mapId, true);
        }
        catch (PersistenceException persistenceException) {
            throw new ConvertException(persistenceException);
        }
        this.setTranslationSession(iTranslator.startTranslationSession());
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        if ((this.groupFound(stringArray, QMWizardArb.getString("AllConstraints")) || this.groupFound(stringArray, QMWizardArb.getString("AllObjects"))) && (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("CONSTRAINTS"))) {
            this.translateCheckConstraints(iTranslator, persistenceUtility, translationContext);
        }
        if ((this.groupFound(stringArray, QMWizardArb.getString("AllViews")) || this.groupFound(stringArray, QMWizardArb.getString("AllObjects"))) && (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("VIEWS"))) {
            this.getPersistenceManager().releaseCache();
            this.translateViewDefinitions(iTranslator, persistenceUtility, translationContext);
        }
        if ((this.groupFound(stringArray, QMWizardArb.getString("AllFunctions")) || this.groupFound(stringArray, QMWizardArb.getString("AllObjects"))) && (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("STORED_PROGRAMS"))) {
            this.getPersistenceManager().releaseCache();
            this.translateFunctions(iTranslator, persistenceUtility, translationContext);
        }
        if ((this.groupFound(stringArray, QMWizardArb.getString("AllProcedures")) || this.groupFound(stringArray, QMWizardArb.getString("AllObjects"))) && (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("STORED_PROGRAMS"))) {
            this.getPersistenceManager().releaseCache();
            this.translateProcedures(iTranslator, persistenceUtility, translationContext);
        }
        if ((this.groupFound(stringArray, QMWizardArb.getString("AllTriggers")) || this.groupFound(stringArray, QMWizardArb.getString("AllObjects"))) && (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("TRIGGERS"))) {
            this.getPersistenceManager().releaseCache();
            this.translateTriggers(iTranslator, persistenceUtility, translationContext);
        }
        if (this.shouldCancel()) {
            convertEvent = new ConvertEvent(-1, "TRANSLATE", "");
            this.getAudience().fireListeners(convertEvent);
            return false;
        }
        System.gc();
        convertEvent2.setEventId(22);
        this.getAudience().fireListeners(convertEvent2);
        this.getPersistenceManager().releaseCache();
        return true;
    }

    private boolean groupFound(String[] stringArray, String string) {
        boolean bl = false;
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean translateSelectedObjects(HashMap<Long, String> hashMap) throws PersistenceException, ConvertException {
        int n;
        ConvertEvent convertEvent = null;
        if (this.m_translationLogging == null) {
            this.m_translationLogging = new TranslationLogging(this.getPersistenceManager(), this.m_translationLogManager);
        }
        ConvertEvent convertEvent2 = new ConvertEvent(21, "", "");
        this.getAudience().fireListeners(convertEvent2);
        this.m_translatedTargetObjects = new HashSet();
        this.m_translatedSourceObjects = new HashSet();
        TranslationContext translationContext = new TranslationContext(this.getPersistenceManager(), this.getConvertedConnectionId(), 100, this.m_mapId);
        String string = "";
        ArrayList<Long> arrayList = null;
        PersistableObject persistableObject = null;
        if (this.m_platformConverter.getSupportedTranslationObjects() == null || this.m_platformConverter.getSupportedTranslationObjects().getSupportedObjects().contains("CONSTRAINTS")) {
            arrayList = this.filterSQLObjByType(hashMap, "Constraint");
            translationContext.setObjCount(arrayList.size());
            translationContext.setObjIndex(0);
            for (n = 0; n < arrayList.size(); ++n) {
                try {
                    string = "MD_CONSTRAINTS";
                    persistableObject = MdConstraint.retrieveExistingInstance(this.getPersistenceManager(), ConvertUtils.findOriginalObject(this.getPersistenceManager(), new DBObjectId(arrayList.get(n)), string, this.m_convertedConnectionId));
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), "Translate Exception", (Throwable)exception);
                }
                if (persistableObject != null) {
                    this.translate(persistableObject, translationContext);
                }
                if (this.shouldCancel()) {
                    convertEvent = new ConvertEvent(-1, "CODE TRANSFORM", "");
                    this.getAudience().fireListeners(convertEvent);
                    this.rollbackConvert();
                    return false;
                }
                System.gc();
            }
        }
        if (this.m_platformConverter.getSupportedTranslationObjects() == null || this.m_platformConverter.getSupportedTranslationObjects().getSupportedObjects().contains("VIEWS")) {
            arrayList = this.filterSQLObjByType(hashMap, "View");
            translationContext.setObjCount(arrayList.size());
            translationContext.setObjIndex(0);
            for (n = 0; n < arrayList.size(); ++n) {
                try {
                    string = "MD_VIEWS";
                    persistableObject = MdView.retrieveExistingInstance(this.getPersistenceManager(), ConvertUtils.findOriginalObject(this.getPersistenceManager(), new DBObjectId(arrayList.get(n)), string, this.m_convertedConnectionId));
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), "Translate Exception", (Throwable)exception);
                }
                if (persistableObject != null) {
                    this.translate(persistableObject, translationContext);
                }
                if (this.shouldCancel()) {
                    convertEvent = new ConvertEvent(-1, "CODE TRANSFORM", "");
                    this.getAudience().fireListeners(convertEvent);
                    this.rollbackConvert();
                    return false;
                }
                System.gc();
            }
        }
        if (this.m_platformConverter.getSupportedTranslationObjects() == null || this.m_platformConverter.getSupportedTranslationObjects().getSupportedObjects().contains("STORED_PROGRAMS")) {
            arrayList = this.filterSQLObjByType(hashMap, "Stored Program");
            translationContext.setObjCount(arrayList.size());
            translationContext.setObjIndex(0);
            for (n = 0; n < arrayList.size(); ++n) {
                try {
                    string = "MD_STORED_PROGRAMS";
                    persistableObject = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), ConvertUtils.findOriginalObject(this.getPersistenceManager(), new DBObjectId(arrayList.get(n)), string, this.m_convertedConnectionId));
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), "Translate Exception", (Throwable)exception);
                }
                if (persistableObject != null) {
                    this.translate(persistableObject, translationContext);
                }
                if (this.shouldCancel()) {
                    convertEvent = new ConvertEvent(-1, "CODE TRANSFORM", "");
                    this.getAudience().fireListeners(convertEvent);
                    this.rollbackConvert();
                    return false;
                }
                System.gc();
            }
        }
        if (this.m_platformConverter.getSupportedTranslationObjects() == null || this.m_platformConverter.getSupportedTranslationObjects().getSupportedObjects().contains("TRIGGERS")) {
            arrayList = this.filterSQLObjByType(hashMap, "Trigger");
            translationContext.setObjCount(arrayList.size());
            translationContext.setObjIndex(0);
            for (n = 0; n < arrayList.size(); ++n) {
                try {
                    string = "MD_TRIGGERS";
                    persistableObject = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), ConvertUtils.findOriginalObject(this.getPersistenceManager(), new DBObjectId(arrayList.get(n)), string, this.m_convertedConnectionId));
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), "Translate Exception", (Throwable)exception);
                }
                if (persistableObject != null) {
                    this.translate(persistableObject, translationContext);
                }
                if (this.shouldCancel()) {
                    convertEvent = new ConvertEvent(-1, "CODE TRANSFORM", "");
                    this.getAudience().fireListeners(convertEvent);
                    this.rollbackConvert();
                    return false;
                }
                System.gc();
            }
        }
        convertEvent2.setEventId(22);
        this.getAudience().fireListeners(convertEvent2);
        this.getPersistenceManager().releaseCache();
        return true;
    }

    private ArrayList<Long> filterSQLObjByType(HashMap<Long, String> hashMap, String string) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (long l : hashMap.keySet()) {
            if (!hashMap.get(l).equals(string)) continue;
            arrayList.add(l);
        }
        return arrayList;
    }

    private boolean isFullConvertRequired() {
        if (this.m_convertedConnection == null) {
            return true;
        }
        if (this.m_convertedConnection.getComments() == null) {
            return true;
        }
        return this.m_convertedConnection.getComments().indexOf(HALFCONVERTED) == -1;
    }

    private void setTranslatedSourceObjects() {
        this.findTranslatedProcedures();
        this.findTranslatedViews();
        this.findTranslatedTableTriggers();
        this.findTranslatedViewTriggers();
    }

    private void findTranslatedProcedures() {
        String string = " SELECT t.\"ID\" FROM( SELECT \"STORED_PROGRAM_ID\" FROM mgv_all_stored_programs WHERE connection_id = ? ) v, md_stored_programs t WHERE  (t.language = 'OracleSQL' OR t.language ='FailedSQL')  AND t.\"ID\" = v.STORED_PROGRAM_ID ";
        String string2 = "MD_STORED_PROGRAMS";
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall(string);
            oracleCallableStatement.setLong(1, this.m_convertedConnectionId.getId());
            resultSet = oracleCallableStatement.executeQuery();
            long l = 0L;
            while (resultSet.next()) {
                l = resultSet.getLong(1);
                MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), new DBObjectId(l));
                MdStoredProgram mdStoredProgram2 = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), ConvertUtils.findOriginalObject(this.getPersistenceManager(), mdStoredProgram.getKey(), string2, this.m_convertedConnectionId));
                this.m_translatedSourceObjects.add(mdStoredProgram2.getKey());
            }
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), "ReConvert Exception", (Throwable)exception);
        }
    }

    private void findTranslatedViews() {
        String string = " SELECT t.\"ID\" FROM( SELECT \"VIEW_ID\" FROM mgv_all_views WHERE connection_id = ? ) v, md_views t WHERE  (t.language = 'OracleSQL' OR t.language ='FailedSQL') AND t.\"ID\" = v.VIEW_ID";
        String string2 = "MD_VIEWS";
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall(string);
            oracleCallableStatement.setLong(1, this.m_convertedConnectionId.getId());
            resultSet = oracleCallableStatement.executeQuery();
            long l = 0L;
            while (resultSet.next()) {
                l = resultSet.getLong(1);
                MdView mdView = MdView.retrieveExistingInstance(this.getPersistenceManager(), new DBObjectId(l));
                MdView mdView2 = MdView.retrieveExistingInstance(this.getPersistenceManager(), ConvertUtils.findOriginalObject(this.getPersistenceManager(), mdView.getKey(), string2, this.m_convertedConnectionId));
                this.m_translatedSourceObjects.add(mdView2.getKey());
            }
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), "ReConvert Exception", (Throwable)exception);
        }
    }

    private void findTranslatedTableTriggers() {
        String string = " SELECT t.\"ID\" FROM( SELECT \"TRIGGER_ID\" FROM mgv_all_table_triggers WHERE connection_id = ? ) v, md_triggers t WHERE  (t.language = 'OracleSQL' OR t.language ='FailedSQL') AND t.\"ID\" = v.TRIGGER_ID";
        String string2 = "MD_TRIGGERS";
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall(string);
            oracleCallableStatement.setLong(1, this.m_convertedConnectionId.getId());
            resultSet = oracleCallableStatement.executeQuery();
            long l = 0L;
            while (resultSet.next()) {
                l = resultSet.getLong(1);
                MdTrigger mdTrigger = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), new DBObjectId(l));
                try {
                    MdTrigger mdTrigger2 = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), ConvertUtils.findOriginalObject(this.getPersistenceManager(), mdTrigger.getKey(), string2, this.m_convertedConnectionId));
                    this.m_translatedSourceObjects.add(mdTrigger2.getKey());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), "ReConvert Exception", (Throwable)exception);
        }
    }

    private void findTranslatedViewTriggers() {
        String string = " SELECT t.\"ID\" FROM( SELECT \"TRIGGER_ID\" FROM mgv_all_view_triggers WHERE connection_id = ? ) v, md_triggers t WHERE  (t.language = 'OracleSQL' OR t.language ='FailedSQL') AND t.\"ID\" = v.TRIGGER_ID ";
        String string2 = "MD_TRIGGERS";
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall(string);
            oracleCallableStatement.setLong(1, this.m_convertedConnectionId.getId());
            resultSet = oracleCallableStatement.executeQuery();
            long l = 0L;
            while (resultSet.next()) {
                l = resultSet.getLong(1);
                MdTrigger mdTrigger = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), new DBObjectId(l));
                MdTrigger mdTrigger2 = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), ConvertUtils.findOriginalObject(this.getPersistenceManager(), mdTrigger.getKey(), string2, this.m_convertedConnectionId));
                this.m_translatedSourceObjects.add(mdTrigger2.getKey());
            }
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), "ReConvert Exception", (Throwable)exception);
        }
    }

    private void rewriteTriggerText() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.TRANSFORM_REWRITE_TRIGGER(?)}");
            oracleCallableStatement.registerOutParameter(1, 4);
            oracleCallableStatement.setLong(2, this.m_convertedConnectionId.getId());
            oracleCallableStatement.execute();
            long l = oracleCallableStatement.getLong(1);
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void finalClashCheck() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        ConvertEvent convertEvent = new ConvertEvent(3, "", "");
        this.getAudience().fireListeners(convertEvent);
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call MIGRATION.TRANSFORM_CLASHES(?)}");
            oracleCallableStatement.setLong(1, this.m_convertedConnectionId.getId());
            oracleCallableStatement.execute();
            convertEvent.setEventId(4);
            this.getAudience().fireListeners(convertEvent);
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void reportRemovedIndexes() {
        this.reportRemovedDuplicateIndexes();
        this.reportRemovedConstraintIndexes();
    }

    private void reportRemovedDuplicateIndexes() {
        try {
            ConvertUtils.logRemovedDuplicateIndexes(this.getPersistenceManager(), this.getConvertedConnectionId(), s_logger);
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("ConverterWorker.28"), (Throwable)persistenceException);
            return;
        }
    }

    private void reportRemovedConstraintIndexes() {
        try {
            ConvertUtils.logDroppedIndexesConstraintClash(this.getPersistenceManager(), this.getSourceConnectionId(), this.getConvertedConnectionId(), s_logger);
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("ConverterWorker.29"), (Throwable)persistenceException);
            return;
        }
    }

    private void reportCoalascedCatalogs() {
        ConvertUtils.CoalescedSchemaInfo[] coalescedSchemaInfoArray = null;
        try {
            coalescedSchemaInfoArray = ConvertUtils.getCoalascedSchema(this.getPersistenceManager(), this.getConvertedConnectionId());
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("ConverterWorker.30"), (Throwable)persistenceException);
            return;
        }
        if (coalescedSchemaInfoArray != null && coalescedSchemaInfoArray.length > 0) {
            for (ConvertUtils.CoalescedSchemaInfo coalescedSchemaInfo : coalescedSchemaInfoArray) {
                if (coalescedSchemaInfo.m_originalCatalogName == null || coalescedSchemaInfo.m_originalCatalogName.trim().length() <= 0) continue;
                s_logger.log(Level.INFO, "Convert.COALESCED", coalescedSchemaInfo.getDataAsObjectArray());
            }
        }
    }

    private void addCommentForTransformedColTabs() {
        DerivativesIterator derivativesIterator = ConvertUtils.getTransformedIdentifiers(this.getPersistenceManager(), this.getConvertedConnectionId());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        while (derivativesIterator.hasNext()) {
            MdDerivative mdDerivative = (MdDerivative)derivativesIterator.next();
            String string = resourceBundle.getString(mdDerivative.getSrcType());
            if (string.equalsIgnoreCase("Table")) {
                this.processTableColComment(mdDerivative, true);
            }
            if (!string.equalsIgnoreCase("Column")) continue;
            this.processTableColComment(mdDerivative, false);
        }
    }

    private void processTableColComment(MdDerivative mdDerivative, boolean bl) {
        long l = mdDerivative.getDerivedId().getId();
        try {
            Object object;
            PreparedStatement preparedStatement = bl ? this.getPersistenceManager().getConn().prepareStatement(SELECT_COMMENTS_QUERY_RENAMED_TABLES) : this.getPersistenceManager().getConn().prepareStatement(SELECT_COMMENTS_QUERY_RENAMED_COLS);
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            object = resultSet.next() ? ((object = resultSet.getString(1)) == null ? "" : " , " + (String)object) : "";
            object = "ORIGINAL NAME:" + mdDerivative.getOriginalIdentifier() + (String)object;
            PreparedStatement preparedStatement2 = bl ? this.getPersistenceManager().getConn().prepareStatement(UPDATE_COMMENTS_QUERY_RENAMED_TABLES) : this.getPersistenceManager().getConn().prepareStatement(UPDATE_COMMENTS_QUERY_RENAMED_COLS);
            preparedStatement2.setString(1, (String)object);
            preparedStatement2.setLong(2, l);
            preparedStatement2.executeQuery();
            preparedStatement.close();
            preparedStatement2.close();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    private void reportTransformedIdentifiers() {
        DerivativesIterator derivativesIterator = ConvertUtils.getTransformedIdentifiers(this.getPersistenceManager(), this.getConvertedConnectionId());
        int n = MigrationUtils.getMaxOracleIdentifierLength();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        if (derivativesIterator.hasNext()) {
            MultiLevelLogManager multiLevelLogManager = new MultiLevelLogManager();
            Object object = new Object();
            do {
                MdDerivative mdDerivative = (MdDerivative)derivativesIterator.next();
                String string = resourceBundle.getString(mdDerivative.getSrcType());
                String string2 = mdDerivative.getNewIdentifier().length() > n ? resourceBundle.getString("REASON_TOO_LONG") : resourceBundle.getString("REASON_RESERVED");
                Object[] objectArray = this.getLogParameters(mdDerivative, string, string2);
                multiLevelLogManager.logMessage(object, Level.INFO, "Convert.IDENTIFIER_TRANSFORM", objectArray);
                if (!this.shouldCancel()) continue;
                derivativesIterator.close();
                break;
            } while (derivativesIterator.hasNext());
            multiLevelLogManager.commitLog(Level.INFO, object, "Convert.IDENTIFIER_TRANSFORMED_HEADING", MigrationLogPhase.CONVERTSTR);
        }
    }

    private Object[] getLogParameters(MdDerivative mdDerivative, String string, String string2) {
        Object[] objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, MigrationLogPhase.CONVERT};
        try {
            if ("MD_VIEWS".equals(mdDerivative.getDerivedType())) {
                MdView mdView = MdView.retrieveExistingInstance(this.getPersistenceManager(), mdDerivative.getDerivedId());
                objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, new ClickableLogInfo(mdView, Messages.getString("ConverterWorker.42"))};
            } else if ("MD_STORED_PROGRAMS".equals(mdDerivative.getDerivedType())) {
                MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), mdDerivative.getDerivedId());
                objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, new ClickableLogInfo(mdStoredProgram, Messages.getString("ConverterWorker.43"))};
            } else if ("MD_TABLES".equals(mdDerivative.getDerivedType())) {
                MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdDerivative.getDerivedId());
                objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, new ClickableLogInfo(mdTable, Messages.getString("ConverterWorker.44"))};
            } else if ("MD_CONSTRAINTS".equals(mdDerivative.getDerivedType())) {
                MdConstraint mdConstraint = MdConstraint.retrieveExistingInstance(this.getPersistenceManager(), mdDerivative.getDerivedId());
                objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, new ClickableLogInfo(mdConstraint, Messages.getString("ConverterWorker.45"))};
            } else if ("MD_INDEXES".equals(mdDerivative.getDerivedType())) {
                MdIndexe mdIndexe = MdIndexe.retrieveExistingInstance(this.getPersistenceManager(), mdDerivative.getDerivedId());
                objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, new ClickableLogInfo(mdIndexe, Messages.getString("ConverterWorker.46"))};
            } else if ("MD_TRIGGERS".equals(mdDerivative.getDerivedType())) {
                MdTrigger mdTrigger = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), mdDerivative.getDerivedId());
                objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, new ClickableLogInfo(mdTrigger, Messages.getString("ConverterWorker.47"))};
            } else if ("MD_USERS".equals(mdDerivative.getDerivedType())) {
                MdUser mdUser = MdUser.retrieveExistingInstance(this.getPersistenceManager(), mdDerivative.getDerivedId());
                objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, new ClickableLogInfo(mdUser, Messages.getString("ConverterWorker.48"))};
            } else if ("MD_SEQUENCES".equals(mdDerivative.getDerivedType())) {
                MdSequence mdSequence = MdSequence.retrieveExistingInstance(this.getPersistenceManager(), mdDerivative.getDerivedId());
                objectArray = new Object[]{string, mdDerivative.getOriginalIdentifier(), mdDerivative.getNewIdentifier(), string2, new ClickableLogInfo(mdSequence, Messages.getString("ConverterWorker.49"))};
            }
        }
        catch (PersistenceException persistenceException) {
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        return objectArray;
    }

    private void checkForUniqueKeyToForeignKeys() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        ConvertEvent convertEvent = new ConvertEvent(23, "", "");
        this.getAudience().fireListeners(convertEvent);
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call MIGRATION.UNIQUEKEY_CONSTRAINT_COLUMNS(?)}");
            oracleCallableStatement.setLong(1, this.getConvertedConnectionId().getId());
            oracleCallableStatement.execute();
            convertEvent = new ConvertEvent(24, "", "");
            this.getAudience().fireListeners(convertEvent);
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void removeUnwantedUniqueKeys() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        ConvertEvent convertEvent = new ConvertEvent(27, "", "");
        this.getAudience().fireListeners(convertEvent);
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call MIGRATION.REMOVE_UNWANTED_UNIQUEKEYS(?)}");
            oracleCallableStatement.setLong(1, this.getConvertedConnectionId().getId());
            oracleCallableStatement.execute();
            convertEvent = new ConvertEvent(28, "", "");
            this.getAudience().fireListeners(convertEvent);
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void removeDuplicateForeignKeys() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        ConvertEvent convertEvent = new ConvertEvent(25, "", "");
        this.getAudience().fireListeners(convertEvent);
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call MIGRATION.REMOVE_DUPLICATE_FOREIGNKEYS(?)}");
            oracleCallableStatement.setLong(1, this.getConvertedConnectionId().getId());
            oracleCallableStatement.execute();
            convertEvent = new ConvertEvent(26, "", "");
            this.getAudience().fireListeners(convertEvent);
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void reportDataTypeTransformResults() {
        try {
            this.reportTextIndexes();
            this.reportAutoChangedDataTypes();
            this.reportDroppedIndexes();
        }
        catch (Throwable throwable) {
            s_logger.log(Level.WARNING, "problem running report on Data Type Transform Results");
        }
    }

    private void reportDroppedIndexes() {
        try {
            ConvertUtils.logDroppedNClobIndexes(this.getPersistenceManager(), this.getConvertedConnectionId(), s_logger);
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("ConverterWorker.50"), (Throwable)persistenceException);
        }
    }

    private void reportAutoChangedDataTypes() {
        try {
            ConvertUtils.logAutoChangedDataTypes(this.getPersistenceManager(), this.getConvertedConnectionId(), s_logger);
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("ConverterWorker.51"), (Throwable)persistenceException);
        }
    }

    private void reportTextIndexes() {
        TextIndexesIterator textIndexesIterator = new TextIndexesIterator(this.getPersistenceManager(), this.getConvertedConnectionId(), "PROP_KEY = 'EXTENDEDINDEXTYPE'");
        if (textIndexesIterator.hasNext()) {
            do {
                try {
                    MdIndexe mdIndexe = (MdIndexe)textIndexesIterator.next();
                    s_logger.log(Level.INFO, "Convert.TEXT_INDEX_CREATED", new Object[]{mdIndexe.getIndexName(), mdIndexe.getProperty("EXTENDEDINDEXTYPE"), new ClickableLogInfo(mdIndexe, MigrationLogPhase.CONVERTSTR)});
                }
                catch (NoSuchElementException noSuchElementException) {
                    s_logger.log(Level.WARNING, "Failed To Reference Index");
                }
            } while (textIndexesIterator.hasNext());
        }
    }

    public void checkPlatformSpecificConversions() throws ConvertException {
        String[] stringArray = this.m_platformConverter.getPropertyKeyList();
        String string = null;
        if (stringArray != null && stringArray.length > 0) {
            List<String> list = Arrays.asList(stringArray);
            PropertyBasedPersitableObjectIterator propertyBasedPersitableObjectIterator = new PropertyBasedPersitableObjectIterator(stringArray, this.getPersistenceManager(), this.m_convertedConnectionId);
            while (propertyBasedPersitableObjectIterator.hasNext()) {
                ConvertEvent convertEvent;
                if (this.shouldCancel()) {
                    convertEvent = new ConvertEvent(-1, "PLATFORM TRANSFORM", "");
                    this.getAudience().fireListeners(convertEvent);
                    propertyBasedPersitableObjectIterator.close();
                    return;
                }
                Object object = propertyBasedPersitableObjectIterator.next();
                AdditionalProperty[] additionalPropertyArray = ((PersistableObject)object).getAdditionalProperties();
                for (AdditionalProperty additionalProperty : additionalPropertyArray) {
                    if (!list.contains(additionalProperty.getKey())) continue;
                    string = additionalProperty.getKey();
                    break;
                }
                convertEvent = new ConvertEvent(16, ((PersistableObject)object).getObjectType(), "");
                this.getAudience().fireListeners(convertEvent);
                try {
                    ConvertResult convertResult = this.m_platformConverter.convertObject((PersistableObject)object, string, this.getPersistenceManager());
                    convertEvent.setEventId(17);
                    this.getAudience().fireListeners(convertEvent);
                    if (convertResult == null) continue;
                    if (convertResult.getOriginal().isChanged()) {
                        convertResult.getOriginal().save(this.getPersistenceManager());
                    }
                    if (convertResult.getDerivedObjects() == null) continue;
                    for (PersistableObject persistableObject : convertResult.getDerivedObjects()) {
                        persistableObject.save(this.getPersistenceManager());
                        MdDerivative mdDerivative = new MdDerivative(convertResult.getOriginal().getKey(), persistableObject.getKey(), this.m_convertedConnectionId);
                        mdDerivative.save(this.getPersistenceManager());
                        if (!convertResult.maintainOrder()) continue;
                        this.storeGenerationOrder(persistableObject);
                    }
                }
                catch (ConvertException convertException) {
                    convertEvent.setEventId(18);
                    this.getAudience().fireListeners(convertEvent);
                }
                catch (PersistenceException persistenceException) {
                    throw new ConvertException(persistenceException);
                }
            }
            propertyBasedPersitableObjectIterator.close();
        }
    }

    private void updateStatistics(String string) throws PersistenceException {
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        persistenceUtility.updateConnectionStatistics(this.getConvertedConnection(), string);
    }

    protected ConvertAudience getAudience() {
        return this.m_audience;
    }

    protected void setAudience(ConvertAudience convertAudience) {
        this.m_audience = convertAudience;
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    public void addEventListener(ConvertEventListener convertEventListener) {
        this.getAudience().addListener(convertEventListener);
    }

    @Override
    public void signalCancel() {
        this.m_context.signalCancel();
    }

    protected boolean shouldCancel() {
        return this.m_context.shouldCancel();
    }

    protected DBObjectId getSourceConnectionId() {
        return this.m_sourceConnectionId;
    }

    protected void setSourceConnectionId(DBObjectId dBObjectId) {
        this.m_sourceConnectionId = dBObjectId;
    }

    protected Converter getPlatformConverter() {
        return this.m_platformConverter;
    }

    protected void setPlatformConverter(Converter converter) {
        this.m_platformConverter = converter;
    }

    protected DBObjectId getConvertedConnectionId() {
        return this.m_convertedConnectionId;
    }

    public MdConnection getConvertedConnection() {
        return this.m_convertedConnection;
    }

    protected void setConvertedConnectionId(DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        this.m_convertedConnectionId = dBObjectId;
        this.m_convertedConnection = MdConnection.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
    }

    protected DBObjectId copyModel() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        ConvertEvent convertEvent = new ConvertEvent(1, "MD_CONNECTIONS", "");
        this.getAudience().fireListeners(convertEvent);
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.COPY_CONNECTION_CASCADE(?)}");
            oracleCallableStatement.registerOutParameter(1, 4);
            oracleCallableStatement.setLong(2, this.m_sourceConnectionId.getId());
            oracleCallableStatement.execute();
            long l = oracleCallableStatement.getLong(1);
            this.setConvertedConnectionId(new DBObjectId(l));
            this.setConvertedConnectionName();
            convertEvent.setEventId(2);
            MigrationLogUtil.startMigrationLogSession(this.getConvertedConnectionId());
            this.getAudience().fireListeners(convertEvent);
            DBObjectId dBObjectId = new DBObjectId(l);
            return dBObjectId;
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        catch (PersistenceException persistenceException) {
            throw new ConvertException(persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new ConvertException(noSuchObjectException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setConvertedConnectionName() {
        int n = this.m_convertedConnection.getName().lastIndexOf("@");
        if (n < 0) {
            return;
        }
        String string = MigrationAddin.removeSpaces(this.m_convertedConnection.getName().substring(0, n));
        Date date = new Date();
        this.m_convertedConnection.setName(string + "@" + new SimpleDateFormat("dd-MMM-yyyy_hh:mm:ss_a").format(date));
        try {
            this.m_convertedConnection.save(this.getPersistenceManager());
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    protected void transformIdentifiers() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        ConvertEvent convertEvent = new ConvertEvent(3, "", "");
        this.getAudience().fireListeners(convertEvent);
        try {
            Datum[] datumArray;
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.TRANSFORM_ALL_IDENTIFIERS(?,?)}");
            oracleCallableStatement.registerOutParameter(1, 2003, "NAME_AND_COUNT_ARRAY");
            oracleCallableStatement.setLong(2, this.getConvertedConnectionId().getId());
            oracleCallableStatement.setString(3, MigrationAddin.getMigrationConfig().getNamePrefix());
            oracleCallableStatement.execute();
            ARRAY aRRAY = oracleCallableStatement.getARRAY(1);
            for (Datum datum : datumArray = aRRAY.getOracleArray()) {
                if (this.shouldCancel()) break;
                STRUCT sTRUCT = (STRUCT)datum;
                Object[] objectArray = sTRUCT.getAttributes();
                String string = (String)objectArray[0];
                BigDecimal bigDecimal = (BigDecimal)objectArray[1];
                convertEvent = new ConvertEvent(5, string, "");
                this.getAudience().fireListeners(convertEvent);
            }
            convertEvent = new ConvertEvent(4, "", "");
            this.getAudience().fireListeners(convertEvent);
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void transformDataTypes() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        ConvertEvent convertEvent = new ConvertEvent(6, "", "");
        this.getAudience().fireListeners(convertEvent);
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.TRANSFORM_DATATYPES(?, ?, ?, ?)}");
            oracleCallableStatement.registerOutParameter(1, 4);
            oracleCallableStatement.setLong(2, this.getConvertedConnectionId().getId());
            oracleCallableStatement.setLong(3, this.getMapId().getId());
            if (this.m_targettingMultibyte) {
                oracleCallableStatement.setInt(4, 2);
            } else {
                oracleCallableStatement.setInt(4, 1);
            }
            if (MigrationAddin.getConfigurationData().get32kChars()) {
                oracleCallableStatement.setString(5, "Y");
            } else {
                oracleCallableStatement.setString(5, "N");
            }
            oracleCallableStatement.execute();
            long l = oracleCallableStatement.getLong(1);
            convertEvent = new ConvertEvent(7, "", "");
            this.getAudience().fireListeners(convertEvent);
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                CloseableResultSet.close((Statement)oracleCallableStatement, null);
            }
        }
    }

    protected void transformDefaults() throws ConvertException {
        String string = MigrationAddinArb.getString("CONVERT_DEFAULT_TRANSFORM_RESULT");
        CloseableResultSet closeableResultSet = null;
        ConvertEvent convertEvent = new ConvertEvent(10, "MD_COLUMNS", "");
        this.getAudience().fireListeners(convertEvent);
        TextMappingRuleSet textMappingRuleSet = this.getPlatformConverter().getDefaultValueMappingRules();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(QUERY_COLS_WITH_DEFAULTS);
            preparedStatement.setLong(1, this.getConvertedConnectionId().getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            HashMap hashMap = new HashMap();
            while (resultSet.next() && !this.shouldCancel()) {
                TransformDefaultWrapper transformDefaultWrapper;
                object10 = resultSet.getString(2);
                TextMappingResult textMappingResult = textMappingRuleSet.applyRules((String)object10);
                object9 = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), new DBObjectId(resultSet.getLong(1)));
                object8 = ((MdColumn)object9).getTableId();
                object7 = MdTable.retrieveExistingInstance(this.getPersistenceManager(), (DBObjectId)object8);
                object6 = ((MdTable)object7).getSchemaId();
                object5 = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), (DBObjectId)object6);
                object4 = ((MdColumn)object9).getColumnType().toUpperCase();
                if (textMappingResult == null && !((String)object4).equals("RAW") && !((String)object4).equals("LONG RAW") && !((String)object4).equals("BLOB") && !((String)object4).equals("CLOB") && !((String)object4).equals("NCLOB")) continue;
                object3 = object10;
                if (textMappingResult != null) {
                    object3 = textMappingResult.getResultingString();
                }
                object2 = "";
                if (((String)object4).equals("NUMBER") || ((String)object4).equals("DECIMAL") || ((String)object4).equals("FLOAT")) {
                    if (((String)object3).startsWith("'(")) {
                        object3 = ((String)object3).substring(2);
                        object3 = ((String)object3).substring(0, ((String)object3).indexOf(41));
                    } else if (((String)object3).matches("^\\s*$|^\\'\\s*\\'$")) {
                        object3 = null;
                    }
                } else if (((String)object4).equals("RAW") || ((String)object4).equals("LONG RAW") || ((String)object4).equals("BLOB")) {
                    boolean bl = false;
                    if (!(((String)object3).startsWith("('") || ((String)object3).endsWith("')") || ((String)object3).equalsIgnoreCase("null"))) {
                        if (((String)object3).matches("'*(?i:0x|x|b)'*\\w*(\\u0000)*'*'*")) {
                            object3 = ((String)object3).replaceFirst("(0x|x|X|b)", "");
                            object3 = ((String)object3).replaceAll("\\u0000", "");
                            bl = true;
                        } else if (((String)object3).matches("'*\\w*'*(?i:xbv)*")) {
                            object3 = ((String)object3).replaceFirst("(?i:xbv)", "");
                            bl = true;
                        }
                        int n = ((String)object3).indexOf(39);
                        if (n == 0) {
                            object3 = ((String)object3).substring(1, ((String)object3).length());
                        }
                        if ((n = ((String)object3).lastIndexOf(39)) >= 0) {
                            object3 = ((String)object3).substring(0, n);
                        }
                        if ((n = ((String)object3).indexOf(39)) < 0) {
                            if (((String)object3).equals("")) {
                                object3 = "0";
                            }
                            object3 = "'" + (String)object3 + "'";
                        }
                        if (bl) {
                            object3 = "HEXTORAW(" + (String)object3 + ")";
                        } else if (!((String)object4).equals("BLOB")) {
                            object3 = "'" + this.getRawValue((String)object3) + "'";
                        }
                    } else {
                        if (((String)object3).startsWith("NVL")) {
                            object3 = object10;
                            if (((String)object3).equals("")) {
                                object3 = "0";
                            }
                            if (!((String)object4).equals("BLOB")) {
                                object3 = "'" + this.getRawValue((String)object3) + "'";
                            }
                        }
                        object3 = ((String)object3).replaceAll("\\(|\\)", "");
                    }
                    if (((String)object4).equals("BLOB")) {
                        if (((String)object3).equals("") || ((String)object3).equals("''") || ((String)object3).equalsIgnoreCase("null")) {
                            object3 = "EMPTY_BLOB()";
                        } else {
                            if (!bl) {
                                object3 = "'" + this.getRawValue((String)object3) + "'";
                            }
                            object3 = "TO_BLOB(" + (String)object3 + ")";
                        }
                    }
                } else if (((String)object4).equals("CLOB")) {
                    if (((String)object3).startsWith("NVL")) {
                        object3 = object10;
                    }
                    object3 = ((String)object3).equals("") || ((String)object3).equals("''") ? "EMPTY_CLOB()" : "TO_CLOB(" + (String)object3 + ")";
                } else if (((String)object4).equals("NCLOB")) {
                    if (((String)object3).startsWith("NVL")) {
                        object3 = object10;
                    }
                    object3 = ((String)object3).equals("") || ((String)object3).equals("''") ? "EMPTY_CLOB()" : "TO_NCLOB(" + (String)object3 + ")";
                } else if (((String)object4).startsWith("CHAR") || ((String)object4).startsWith("NCHAR") || ((String)object4).startsWith("VARCHAR2") || ((String)object4).startsWith("NVARCHAR2") || ((String)object4).equals("LONG")) {
                    if (((String)object3).matches("'b'\\d+''")) {
                        object3 = ((String)object3).replaceAll("b|'", "");
                        object3 = "'" + (String)object3 + "'";
                    } else if (((String)object3).matches("[\\'\\p{Punct}*\\']*[\\s]*[\\+\\s*\\'*\\w+\\'*[\\(\\'\\w\\'\\)]*[\\s]*\\+]*[\\s]*[\\'\\p{Punct}*\\']*")) {
                        object3 = ((String)object3).replaceAll("\\+", "||");
                    }
                    if (((String)object4).startsWith("NCHAR")) {
                        object3 = "TO_NCHAR(" + (String)object3 + ")";
                    }
                }
                object = MessageFormat.format(string, object10, object3);
                ArrayList<TransformDefaultWrapper> arrayList = (ArrayList<TransformDefaultWrapper>)hashMap.get(object);
                if (!hashMap.containsKey(object)) {
                    arrayList = new ArrayList<TransformDefaultWrapper>();
                }
                if (textMappingResult != null && textMappingResult.shouldWarn()) {
                    transformDefaultWrapper = this.createDefaultWrapper((MdColumn)object9, (MdTable)object7, (MdSchema)object5, Level.WARNING);
                    arrayList.add(transformDefaultWrapper);
                    hashMap.put(object, arrayList);
                } else {
                    transformDefaultWrapper = this.createDefaultWrapper((MdColumn)object9, (MdTable)object7, (MdSchema)object5, Level.INFO);
                    arrayList.add(transformDefaultWrapper);
                    hashMap.put(object, arrayList);
                }
                this.getAudience().fireListeners(convertEvent);
                ((MdColumn)object9).setDefaultValue((String)object3);
                ((PersistableObject)object9).save(this.getPersistenceManager());
            }
            object10 = MigrationLogPhase.CONVERT;
            object9 = hashMap.keySet();
            object8 = object9.iterator();
            while (object8.hasNext()) {
                object7 = (String)object8.next();
                object6 = (ArrayList)hashMap.get(object7);
                object5 = new LogInfo(Messages.getString("ConverterWorker.77"));
                object4 = ((ArrayList)object6).iterator();
                while (object4.hasNext()) {
                    object3 = (TransformDefaultWrapper)object4.next();
                    object2 = new LogRecord(((TransformDefaultWrapper)object3).getLevel(), ((TransformDefaultWrapper)object3).getMessage());
                    object = new ClickableLogInfo(((TransformDefaultWrapper)object3).getTable(), Messages.getString("ConverterWorker.78"));
                    ((LogInfo)object).addSupplementaryInfo(((TransformDefaultWrapper)object3).getColumn());
                    ((LogRecord)object2).setParameters(new Object[]{object});
                    ((LogInfo)object5).addChild((LogRecord)object2);
                }
                object4 = new LogRecord(Level.WARNING, (String)object7);
                ((LogRecord)object4).setParameters(new Object[]{object5});
                ((LogInfo)object10).addChild((LogRecord)object4);
            }
            if (((LogInfo)object10).hasChildren()) {
                object8 = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
                ((Logger)object8).log(Level.WARNING, Messages.getString("ConverterWorker.79"), new Object[]{object10});
            }
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new ConvertException(noSuchObjectException);
        }
        catch (PersistenceException persistenceException) {
            throw new ConvertException(persistenceException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
        convertEvent = new ConvertEvent(12, "MD_COLUMNS", "");
        this.getAudience().fireListeners(convertEvent);
    }

    private TransformDefaultWrapper createDefaultWrapper(MdColumn mdColumn, MdTable mdTable, MdSchema mdSchema, Level level) {
        TransformDefaultWrapper transformDefaultWrapper = new TransformDefaultWrapper();
        transformDefaultWrapper.setSchema(mdSchema);
        transformDefaultWrapper.setTable(mdTable);
        transformDefaultWrapper.setColumn(mdColumn);
        transformDefaultWrapper.setLevel(level);
        transformDefaultWrapper.setMessage(mdSchema.getName() + "." + mdTable.getTableName() + "." + mdColumn.getColumnName());
        return transformDefaultWrapper;
    }

    protected void transformCodeSegments() throws ConvertException {
        this.getPersistenceManager().releaseCache();
        ITranslator iTranslator = this.getPlatformConverter().getPlaformTranslator();
        ObjectTranslationList objectTranslationList = this.m_platformConverter.getSupportedTranslationObjects();
        this.m_translationLogging = new TranslationLogging(this.getPersistenceManager(), this.m_translationLogManager);
        if (iTranslator == null) {
            return;
        }
        TranslationContext translationContext = null;
        try {
            translationContext = new TranslationContext(this.getPersistenceManager(), this.getConvertedConnectionId(), 10000, this.m_mapId, true);
        }
        catch (PersistenceException persistenceException) {
            throw new ConvertException(persistenceException);
        }
        this.setTranslationSession(iTranslator.startTranslationSession());
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        System.gc();
        if (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("CONSTRAINTS")) {
            this.translateCheckConstraints(iTranslator, persistenceUtility, translationContext);
            if (this.shouldCancel()) {
                ConvertEvent convertEvent = new ConvertEvent(-1, "TRANSLATE", "");
                this.getAudience().fireListeners(convertEvent);
                return;
            }
        }
        if (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("VIEWS")) {
            System.gc();
            this.getPersistenceManager().releaseCache();
            this.translateViewDefinitions(iTranslator, persistenceUtility, translationContext);
            if (this.shouldCancel()) {
                ConvertEvent convertEvent = new ConvertEvent(-1, "TRANSLATE", "");
                this.getAudience().fireListeners(convertEvent);
                return;
            }
        }
        if (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("STORED_PROGRAMS")) {
            System.gc();
            this.getPersistenceManager().releaseCache();
            this.translateStoredPrograms(iTranslator, persistenceUtility, translationContext);
            if (this.shouldCancel()) {
                ConvertEvent convertEvent = new ConvertEvent(-1, "TRANSLATE", "");
                this.getAudience().fireListeners(convertEvent);
                return;
            }
        }
        if (objectTranslationList == null || objectTranslationList.getSupportedObjects().contains("TRIGGERS")) {
            System.gc();
            this.getPersistenceManager().releaseCache();
            this.translateTriggers(iTranslator, persistenceUtility, translationContext);
        }
    }

    private void storeGenerationOrder(PersistableObject persistableObject) throws PersistenceException {
        MigrGenerationOrder migrGenerationOrder = null;
        migrGenerationOrder = new MigrGenerationOrder(this.m_convertedConnectionId, persistableObject.getKey(), persistableObject.getObjectType(), this.m_generationOrder++);
        if (this.m_translatedTargetObjects != null) {
            this.m_translatedTargetObjects.add(persistableObject.getKey());
            try {
                migrGenerationOrder.save(this.getPersistenceManager());
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
        }
    }

    protected void translateCheckConstraints(ITranslator iTranslator, PersistenceUtility persistenceUtility, ITranslationContext iTranslationContext) throws ConvertException {
        MdConstraint mdConstraint = null;
        try (CloseableIterator closeableIterator = null;){
            closeableIterator = persistenceUtility.getCheckConstraintsForConectionId(this.getSourceConnectionId(), this.m_filterList);
            while (closeableIterator.hasNext() && !this.shouldCancel()) {
                mdConstraint = (MdConstraint)closeableIterator.next();
                if (!persistenceUtility.isDBObjectEnabled(mdConstraint.getKey().getId())) continue;
                if (!this.isTranslating(mdConstraint.getKey().getId()) && !this.isTranslated(mdConstraint.getKey().getId())) {
                    this.translateIndividualCheckConstraint(iTranslator, mdConstraint, iTranslationContext);
                }
                System.gc();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualCheckConstraint(ITranslator iTranslator, MdConstraint mdConstraint, ITranslationContext iTranslationContext) throws ConvertException {
        this.m_translatingObjects.push(mdConstraint.getKey().getId());
        try {
            MdColumn mdColumn;
            Object object;
            CloseableIterator closeableIterator;
            MdTable mdTable;
            String string = MigrationUtils.findCheckConstraintCondition(mdConstraint, this.getPersistenceManager());
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
            String string2 = persistenceUtility.getHostForConnection(this.getSourceConnectionId());
            String string3 = null;
            String string4 = null;
            try {
                mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getTableId());
                string3 = mdTable.getTableName();
                closeableIterator = persistenceUtility.getConstraintDetails(mdConstraint.getKey());
                if (closeableIterator != null && closeableIterator.hasNext() && (object = (MdConstraintDetail)closeableIterator.next()) != null) {
                    mdColumn = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), ((MdConstraintDetail)object).getColumnId());
                    string4 = mdColumn.getColumnName();
                    iTranslationContext.addInfoKeyValue("CONSTRAINT_COLUMN", string4);
                    closeableIterator.close();
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.90"), Messages.getString("ConverterWorker.91"), noSuchObjectException.getMessage(), noSuchObjectException);
                s_logger.warning(noSuchObjectException.getLocalizedMessage());
            }
            mdTable = new TranslationDBObjectReference(string2, "NA", "NA", string3, mdConstraint.getName(), TranslationObjectType.CONSTRAINT_TYPE, (Object)mdConstraint);
            closeableIterator = new TranslationDBObject((TranslationDBObjectReference)mdTable, string);
            ConvertEvent convertEvent = new ConvertEvent(8, Messages.getString("ConverterWorker.94"), mdConstraint.getName());
            this.getAudience().fireListeners(convertEvent);
            s_logger.log(Level.INFO, Messages.getString("ConverterWorker.AttemptingConvert") + mdConstraint.getName(), new Object[]{new ClickableLogInfo(mdConstraint, Messages.getString("ConverterWorker.123"))});
            object = new StopWatch();
            mdColumn = iTranslator.translate((TranslationDBObject)closeableIterator, iTranslationContext, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            long l = ((StopWatch)object).getDuration();
            iTranslationContext.clearInfoKey();
            if (mdColumn != null) {
                MdConstraint mdConstraint2 = null;
                if (mdColumn.getTargetObject().getType().equals(TranslationObjectType.CONSTRAINT_TYPE)) {
                    mdConstraint2 = ConvertUtils.findConstraintCopy(mdConstraint, this.getPersistenceManager(), this.getConvertedConnectionId());
                    mdConstraint2.setConstraintText(mdColumn.getTargetObject().getDdl());
                    mdConstraint2.setLanguage("OracleSQL");
                    mdConstraint2.save(this.getPersistenceManager());
                    this.m_translationLogManager.commitLog(Level.INFO, (Object)mdConstraint, ConverterWorker.multiLogHeader("MD_CONSTRAINTS", mdConstraint.getName()), mdConstraint2);
                    this.storeGenerationOrder(mdConstraint2);
                } else if (mdColumn.getTargetObject().getType().equals(TranslationObjectType.TRIGGER_TYPE)) {
                    mdConstraint2 = ConvertUtils.findConstraintCopy(mdConstraint, this.getPersistenceManager(), this.getConvertedConnectionId());
                    MdTrigger mdTrigger = new MdTrigger(mdConstraint2.getTableId(), "T", "OracleSQL");
                    ConvertUtils.removeDerivedConstraint(this.getPersistenceManager(), mdConstraint2, this.m_convertedConnectionId);
                    mdTrigger.setTriggerName(mdColumn.getTargetObject().getObjName());
                    mdTrigger.setNativeSql(new ClobHelper(mdColumn.getTargetObject().getDdl()));
                    mdTrigger.save(this.getPersistenceManager());
                    MdDerivative mdDerivative = new MdDerivative(mdConstraint.getKey(), mdTrigger.getKey(), this.m_convertedConnectionId);
                    mdDerivative.save(this.getPersistenceManager());
                    this.m_translationLogManager.commitLog(Level.INFO, (Object)mdConstraint, ConverterWorker.multiLogHeader("MD_CONSTRAINTS", mdConstraint.getName()), mdTrigger);
                    this.storeGenerationOrder(mdTrigger);
                }
                s_logger.log(Level.INFO, MessageFormat.format(Messages.getString("ConverterWorker.SuccessfulConvert"), mdConstraint.getName(), TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS)), new Object[]{new ClickableLogInfo(mdConstraint2, Messages.getString("ConverterWorker.123"))});
            }
            convertEvent.setEventId(9);
            this.getAudience().fireListeners(convertEvent);
        }
        catch (TranslationException translationException) {
            s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_CONSTRAINTS") + " " + mdConstraint.getName() + " " + translationException.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdConstraint, Messages.getString("ConverterWorker.98"))});
        }
        catch (Exception exception) {
            try {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_CONSTRAINTS") + " " + mdConstraint.getName() + " " + exception.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdConstraint, Messages.getString("ConverterWorker.98"))});
            }
            catch (Exception exception2) {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + ":" + exception2.getMessage(), exception);
            }
        }
        finally {
            this.setSourceTranslated(mdConstraint);
            this.m_translatingObjects.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualCheckConstraint(ITranslator iTranslator, ITranslationContext iTranslationContext, TranslationDBObject translationDBObject, MdConstraint mdConstraint) throws PersistenceException, NoSuchObjectException {
        CloseableIterator closeableIterator;
        Object object;
        ConvertEvent convertEvent = null;
        this.m_translatingObjects.push(mdConstraint.getKey().getId());
        iTranslationContext.setObjIndex(iTranslationContext.getObjIndex() + 1);
        this.deletePreviousLogs(mdConstraint.getKey().getId());
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        String string = null;
        String string2 = null;
        try {
            MdConstraintDetail mdConstraintDetail;
            object = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getTableId());
            string = ((MdTable)object).getTableName();
            closeableIterator = persistenceUtility.getConstraintDetails(mdConstraint.getKey());
            if (closeableIterator != null && closeableIterator.hasNext() && (mdConstraintDetail = (MdConstraintDetail)closeableIterator.next()) != null) {
                MdColumn mdColumn = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), mdConstraintDetail.getColumnId());
                string2 = mdColumn.getColumnName();
                iTranslationContext.addInfoKeyValue("CONSTRAINT_COLUMN", string2);
                closeableIterator.close();
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.90"), Messages.getString("ConverterWorker.91"), noSuchObjectException.getMessage(), noSuchObjectException);
            s_logger.warning(noSuchObjectException.getLocalizedMessage());
        }
        try {
            convertEvent = new ConvertEvent(8, "MD_CONSTRAINTS", mdConstraint.getName() + this.getCountString(iTranslationContext));
            this.getAudience().fireListeners(convertEvent);
            s_logger.log(Level.INFO, Messages.getString("ConverterWorker.AttemptingConvert") + mdConstraint.getName(), new Object[]{new ClickableLogInfo(mdConstraint, Messages.getString("ConverterWorker.123"))});
            object = new StopWatch();
            closeableIterator = iTranslator.translate(translationDBObject, iTranslationContext, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            long l = ((StopWatch)object).getDuration();
            iTranslationContext.clearInfoKey();
            if (closeableIterator != null) {
                MdConstraint mdConstraint2 = null;
                if (closeableIterator.getTargetObject().getType().equals(TranslationObjectType.CONSTRAINT_TYPE)) {
                    mdConstraint2 = ConvertUtils.findConstraintCopy(mdConstraint, this.getPersistenceManager(), this.getConvertedConnectionId());
                    mdConstraint2.setConstraintText(closeableIterator.getTargetObject().getDdl());
                    mdConstraint2.setLanguage("OracleSQL");
                    mdConstraint2.save(this.getPersistenceManager());
                    this.m_translationLogManager.commitLog(Level.INFO, (Object)mdConstraint, ConverterWorker.multiLogHeader("MD_CONSTRAINTS", mdConstraint.getName()), mdConstraint2);
                    this.storeGenerationOrder(mdConstraint2);
                } else if (closeableIterator.getTargetObject().getType().equals(TranslationObjectType.TRIGGER_TYPE)) {
                    mdConstraint2 = ConvertUtils.findConstraintCopy(mdConstraint, this.getPersistenceManager(), this.getConvertedConnectionId());
                    MdTrigger mdTrigger = new MdTrigger(mdConstraint2.getTableId(), "T", "OracleSQL");
                    ConvertUtils.removeDerivedConstraint(this.getPersistenceManager(), mdConstraint2, this.m_convertedConnectionId);
                    mdTrigger.setTriggerName(closeableIterator.getTargetObject().getObjName());
                    mdTrigger.setNativeSql(new ClobHelper(closeableIterator.getTargetObject().getDdl()));
                    mdTrigger.save(this.getPersistenceManager());
                    MdDerivative mdDerivative = new MdDerivative(mdConstraint.getKey(), mdTrigger.getKey(), this.m_convertedConnectionId);
                    mdDerivative.save(this.getPersistenceManager());
                    this.m_translationLogManager.commitLog(Level.INFO, (Object)mdConstraint, ConverterWorker.multiLogHeader("MD_CONSTRAINTS", mdConstraint.getName()), mdTrigger);
                    this.storeGenerationOrder(mdTrigger);
                }
                s_logger.log(Level.INFO, MessageFormat.format(Messages.getString("ConverterWorker.SuccessfulConvert"), mdConstraint.getName(), TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS)), new Object[]{new ClickableLogInfo(mdConstraint2, Messages.getString("ConverterWorker.123"))});
            }
            convertEvent.setEventId(9);
            this.getAudience().fireListeners(convertEvent);
        }
        catch (NoCopyFoundException noCopyFoundException) {
            MigrationLogUtil.logThrowable(noCopyFoundException.getLocalizedMessage(), Messages.getString("ConverterWorker.128"), (Throwable)noCopyFoundException);
        }
        catch (TranslationException translationException) {
            s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_CONSTRAINTS") + " " + mdConstraint.getName() + " " + translationException.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdConstraint, Messages.getString("ConverterWorker.98"))});
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("ConverterWorker.98"), (Throwable)persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("ConverterWorker.98"), (Throwable)noSuchObjectException);
        }
        catch (Exception exception) {
            try {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_CONSTRAINTS") + " " + mdConstraint.getName() + " " + exception.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdConstraint, Messages.getString("ConverterWorker.98"))});
            }
            catch (Exception exception2) {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + ":" + exception2.getMessage(), exception);
            }
        }
        finally {
            this.setSourceTranslated(mdConstraint);
            this.m_translatingObjects.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getEmulationPackages(ITranslator iTranslator, ITranslationContext iTranslationContext) throws PersistenceException {
        boolean bl = false;
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        try (CloseableIterator<MgvAllSchemasRec> closeableIterator = persistenceUtility.getSchemasForConnectionId(this.m_convertedConnectionId);){
            int n = 0;
            Object var7_7 = null;
            while (closeableIterator.hasNext()) {
                MdSchema mdSchema;
                ++n;
                MgvAllSchemasRec mgvAllSchemasRec = (MgvAllSchemasRec)closeableIterator.next();
                try {
                    mdSchema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), mgvAllSchemasRec.getSchemaId());
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new PersistenceException(noSuchObjectException);
                }
                this.addPackageForSchema(mdSchema, iTranslator, iTranslationContext);
            }
        }
    }

    private void addSynonymForPackage(MdSchema mdSchema, MdPackage mdPackage) {
    }

    private MdPackage addPackageForSchema(MdSchema mdSchema, ITranslator iTranslator, ITranslationContext iTranslationContext) {
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference("N/A", "N/A", mdSchema.getName(), this.getPlatformConverter().getEmulationPkgName(), null, TranslationObjectType.PACKAGE_TYPE);
        TranslationResult translationResult = null;
        try {
            TranslationHelper translationHelper = new TranslationHelper(new TranslationDBObject(translationDBObjectReference, ""), iTranslationContext, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            if (iTranslator != null) {
                translationResult = iTranslator.getEmulationPackageForSchema((Object)mdSchema.getKey(), translationDBObjectReference, iTranslationContext, this.m_tableAndViewTriggers, translationHelper);
            }
        }
        catch (Exception exception) {
            s_logger.log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        if (translationResult != null) {
            return this.saveResultAsPackage(translationResult, mdSchema);
        }
        return null;
    }

    private MdPackage addPackageForSchema(MdSchema mdSchema, ITranslator iTranslator, DBObjectId dBObjectId, ITranslationContext iTranslationContext) {
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference("N/A", "N/A", mdSchema.getName(), this.getPlatformConverter().getEmulationPkgName(), null, TranslationObjectType.PACKAGE_TYPE);
        TranslationResult translationResult = null;
        try {
            TranslationHelper translationHelper = new TranslationHelper(new TranslationDBObject(translationDBObjectReference, ""), iTranslationContext, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            if (iTranslator != null) {
                translationResult = iTranslator.getEmulationPackageForConnection((Object)dBObjectId, translationDBObjectReference, iTranslationContext, this.m_tableAndViewTriggers, translationHelper);
            }
        }
        catch (TranslationException translationException) {
            s_logger.log(Level.WARNING, translationException.getLocalizedMessage(), translationException);
        }
        if (translationResult != null) {
            return this.saveResultAsPackage(translationResult, mdSchema);
        }
        return null;
    }

    private MdPackage saveResultAsPackage(TranslationResult translationResult, MdSchema mdSchema) {
        if (translationResult == null) {
            return null;
        }
        TranslationDBObject translationDBObject = null;
        TranslationDBObject translationDBObject2 = null;
        MdPackage mdPackage = null;
        translationDBObject = translationResult.getTargetObject();
        if (translationResult.getExtraObjects() != null) {
            translationDBObject2 = (TranslationDBObject)translationResult.getExtraObjects().get(0);
        }
        mdPackage = new MdPackage(mdSchema.getKey(), translationDBObject.getObjName(), "OracleSQL");
        mdPackage.setPackageHeader(translationDBObject.getDdl());
        if (translationDBObject2 != null) {
            mdPackage.setNativeSql(translationDBObject2.getDdl());
        }
        mdPackage.addProperty("MIGRATIONEMULATION", "Y", this.m_convertedConnectionId);
        mdPackage.setComments(this.getPlatformConverter().getEmulationPkgName());
        try {
            mdPackage.save(this.getPersistenceManager());
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("ConverterWorker.105"), (Throwable)persistenceException);
        }
        return mdPackage;
    }

    protected void translateViewTriggers(ITranslator iTranslator, PersistenceUtility persistenceUtility, ITranslationContext iTranslationContext) throws ConvertException {
        try (CloseableIterator<MgvAllViewTriggersRec> closeableIterator = null;){
            closeableIterator = persistenceUtility.getViewTriggersForConnectionId(this.getSourceConnectionId());
            iTranslationContext.setObjCount(persistenceUtility.getObjectCount(this.getSourceConnectionId(), "MD_TRIGGERSV"));
            iTranslationContext.setObjIndex(0);
            while (closeableIterator.hasNext()) {
                Object object;
                if (this.shouldCancel()) {
                    object = new ConvertEvent(-1, "TRANSLATE", "");
                    this.getAudience().fireListeners((ConvertEvent)object);
                    return;
                }
                object = (MgvAllViewTriggersRec)closeableIterator.next();
                MdTrigger mdTrigger = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), ((MgvAllViewTriggersRec)object).getTriggerId());
                if (!persistenceUtility.isDBObjectEnabled(mdTrigger.getKey().getId()) || !persistenceUtility.isDBObjectEnabled(mdTrigger.getTableOrViewId().getId())) continue;
                if (!this.isTranslated(((MgvAllViewTriggersRec)object).getTriggerId().getId()) && !this.isTranslating(((MgvAllViewTriggersRec)object).getTriggerId().getId())) {
                    TranslationDBObject translationDBObject = null;
                    try {
                        String string = persistenceUtility.getHostForConnection(((MgvAllConnectionsRec)object).getConnectionId());
                        translationDBObject = ConvertUtils.asTranslationDBObject(string, ((MgvAllCatalogsRec)object).getCatalogName(), ((MgvAllSchemasRec)object).getSchemaName(), mdTrigger);
                    }
                    catch (IOException iOException) {
                        MigrationLogUtil.logThrowable(iOException.getLocalizedMessage(), Messages.getString("ConverterWorker.106"), (Throwable)iOException);
                    }
                    this.translateIndividualViewTrigger(iTranslator, iTranslationContext, translationDBObject, mdTrigger);
                }
                System.gc();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualViewTrigger(ITranslator iTranslator, ITranslationContext iTranslationContext, TranslationDBObject translationDBObject, MdTrigger mdTrigger) throws PersistenceException, NoSuchObjectException {
        this.m_translatingObjects.push(mdTrigger.getKey().getId());
        iTranslationContext.setObjIndex(iTranslationContext.getObjIndex() + 1);
        try {
            MdTrigger mdTrigger2 = ConvertUtils.findTriggerCopy(mdTrigger, this.getPersistenceManager(), this.getConvertedConnectionId());
            try {
                this.deletePreviousLogs(mdTrigger2.getKey().getId());
                ConvertEvent convertEvent = new ConvertEvent(8, "MD_TRIGGERS", mdTrigger.getTriggerName() + this.getCountString(iTranslationContext));
                this.getAudience().fireListeners(convertEvent);
                s_logger.log(Level.INFO, Messages.getString("ConverterWorker.AttemptingConvert") + mdTrigger.getTriggerName(), new Object[]{new ClickableLogInfo(mdTrigger, Messages.getString("ConverterWorker.123"))});
                StopWatch stopWatch = new StopWatch();
                TranslationResult translationResult = iTranslator.translate(translationDBObject, iTranslationContext, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
                mdTrigger2.setNativeSql(translationResult.getFullDdlScript());
                long l = stopWatch.getDuration();
                mdTrigger2.setLanguage("OracleSQL");
                mdTrigger2.save(this.getPersistenceManager());
                try {
                    if (mdTrigger2.getTableOrViewId() != null) {
                        MdView mdView = MdView.retrieveExistingInstance(this.getPersistenceManager(), mdTrigger2.getTableOrViewId());
                        DBObjectId dBObjectId = mdView.getSchemaId();
                        MdSchema mdSchema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                        String string = mdView.getViewName();
                        String string2 = mdSchema.getName();
                        this.m_tableAndViewTriggers.add(string2 + "." + string);
                    }
                }
                catch (Exception exception) {
                    this.m_tableAndViewTriggers.add(mdTrigger2.getTriggerName());
                }
                this.m_translationLogManager.commitLog(Level.INFO, (Object)mdTrigger, ConverterWorker.multiLogHeader("MD_TRIGGERS", mdTrigger.getTriggerName()), mdTrigger2);
                this.storeGenerationOrder(mdTrigger2);
                s_logger.log(Level.INFO, MessageFormat.format(Messages.getString("ConverterWorker.SuccessfulConvert"), mdTrigger.getTriggerName(), TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS)), new Object[]{new ClickableLogInfo(mdTrigger2, Messages.getString("ConverterWorker.123"))});
                convertEvent.setEventId(9);
                this.getAudience().fireListeners(convertEvent);
            }
            catch (TranslationException translationException) {
                mdTrigger2.setLanguage("FailedSQL");
                mdTrigger2.save(this.getPersistenceManager());
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_TRIGGERS") + " " + mdTrigger.getTriggerName() + " " + translationException.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdTrigger, Messages.getString("ConverterWorker.111"))});
            }
        }
        catch (NoCopyFoundException noCopyFoundException) {
            MigrationLogUtil.logThrowable(noCopyFoundException.getLocalizedMessage(), Messages.getString("ConverterWorker.107"), (Throwable)noCopyFoundException);
        }
        catch (Exception exception) {
            try {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_TRIGGERS") + " " + mdTrigger.getTriggerName() + " " + exception.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdTrigger, Messages.getString("ConverterWorker.111"))});
            }
            catch (Exception exception2) {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + ":" + exception2.getMessage(), exception);
            }
        }
        finally {
            this.setSourceTranslated(mdTrigger);
            this.m_translatingObjects.pop();
        }
    }

    private String getCountString(ITranslationContext iTranslationContext) {
        if (iTranslationContext != null) {
            return " [" + iTranslationContext.getObjIndex() + " of " + iTranslationContext.getObjCount() + "]";
        }
        return "";
    }

    private void translateTableTriggers(ITranslator iTranslator, PersistenceUtility persistenceUtility, ITranslationContext iTranslationContext) throws ConvertException {
        try (CloseableIterator<MgvAllTableTriggersRec> closeableIterator = null;){
            closeableIterator = persistenceUtility.getTableTriggersForConnectionId(this.getSourceConnectionId());
            iTranslationContext.setObjCount(persistenceUtility.getObjectCount(this.getSourceConnectionId(), "MD_TRIGGERST"));
            iTranslationContext.setObjIndex(0);
            while (closeableIterator.hasNext()) {
                Object object;
                if (this.shouldCancel()) {
                    object = new ConvertEvent(-1, "TRANSLATE", "");
                    this.getAudience().fireListeners((ConvertEvent)object);
                    return;
                }
                object = (MgvAllTableTriggersRec)closeableIterator.next();
                MdTrigger mdTrigger = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), ((MgvAllTableTriggersRec)object).getTriggerId());
                if (!persistenceUtility.isDBObjectEnabled(mdTrigger.getKey().getId()) || !persistenceUtility.isDBObjectEnabled(mdTrigger.getTableOrViewId().getId())) continue;
                if (!(this.isTranslated(((MgvAllTableTriggersRec)object).getTriggerId().getId()) || this.isTranslating(((MgvAllTableTriggersRec)object).getTriggerId().getId()) || mdTrigger.getLanguage().equals("OracleSQL"))) {
                    try {
                        String string = persistenceUtility.getHostForConnection(((MgvAllConnectionsRec)object).getConnectionId());
                        TranslationDBObject translationDBObject = ConvertUtils.asTranslationDBObject(string, ((MgvAllCatalogsRec)object).getCatalogName(), ((MgvAllSchemasRec)object).getSchemaName(), mdTrigger);
                        this.translateIndividualTableTrigger(iTranslator, iTranslationContext, translationDBObject, mdTrigger);
                    }
                    catch (IOException iOException) {
                        MigrationLogUtil.logThrowable(iOException.getLocalizedMessage(), Messages.getString("ConverterWorker.112"), (Throwable)iOException);
                    }
                }
                System.gc();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualTableTrigger(ITranslator iTranslator, ITranslationContext iTranslationContext, TranslationDBObject translationDBObject, MdTrigger mdTrigger) throws PersistenceException, NoSuchObjectException {
        this.m_translatingObjects.push(mdTrigger.getKey().getId());
        iTranslationContext.setObjIndex(iTranslationContext.getObjIndex() + 1);
        try {
            MdTrigger mdTrigger2 = ConvertUtils.findTriggerCopy(mdTrigger, this.getPersistenceManager(), this.getConvertedConnectionId());
            try {
                this.deletePreviousLogs(mdTrigger2.getKey().getId());
                ConvertEvent convertEvent = new ConvertEvent(8, "MD_TRIGGERS", mdTrigger.getTriggerName() + this.getCountString(iTranslationContext));
                this.getAudience().fireListeners(convertEvent);
                s_logger.log(Level.INFO, Messages.getString("ConverterWorker.AttemptingConvert") + mdTrigger.getTriggerName(), new Object[]{new ClickableLogInfo(mdTrigger, Messages.getString("ConverterWorker.123"))});
                StopWatch stopWatch = new StopWatch();
                TranslationResult translationResult = iTranslator.translate(translationDBObject, iTranslationContext, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
                long l = stopWatch.getDuration();
                mdTrigger2.setNativeSql(translationResult.getFullDdlScript());
                mdTrigger2.setLanguage("OracleSQL");
                mdTrigger2.save(this.getPersistenceManager());
                try {
                    if (mdTrigger2.getTableOrViewId() != null) {
                        MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdTrigger2.getTableOrViewId());
                        DBObjectId dBObjectId = mdTable.getSchemaId();
                        MdSchema mdSchema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                        String string = mdTable.getTableName();
                        String string2 = mdSchema.getName();
                        this.m_tableAndViewTriggers.add(string2 + "." + string);
                    }
                }
                catch (Exception exception) {
                    this.m_tableAndViewTriggers.add(mdTrigger2.getTriggerName());
                }
                this.m_translationLogManager.commitLog(Level.INFO, (Object)mdTrigger, ConverterWorker.multiLogHeader("MD_TRIGGERS", mdTrigger.getTriggerName()), mdTrigger2);
                this.storeGenerationOrder(mdTrigger2);
                s_logger.log(Level.INFO, MessageFormat.format(Messages.getString("ConverterWorker.SuccessfulConvert"), mdTrigger.getTriggerName(), TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS)), new Object[]{new ClickableLogInfo(mdTrigger2, Messages.getString("ConverterWorker.123"))});
                convertEvent.setEventId(9);
                this.getAudience().fireListeners(convertEvent);
            }
            catch (TranslationException translationException) {
                mdTrigger2.setLanguage("FailedSQL");
                mdTrigger2.save(this.getPersistenceManager());
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_TRIGGERS") + " " + mdTrigger.getTriggerName() + " " + translationException.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdTrigger, Messages.getString("ConverterWorker.116"))});
            }
        }
        catch (NoCopyFoundException noCopyFoundException) {
            MigrationLogUtil.logThrowable(noCopyFoundException.getLocalizedMessage(), "", (Throwable)noCopyFoundException);
        }
        catch (Exception exception) {
            try {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_TRIGGERS") + " " + mdTrigger.getTriggerName() + " " + exception.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdTrigger, Messages.getString("ConverterWorker.116"))});
            }
            catch (Exception exception2) {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + ":" + exception2.getMessage(), exception);
            }
        }
        finally {
            this.setSourceTranslated(mdTrigger);
            this.m_translatingObjects.pop();
        }
    }

    private void translateTriggers(ITranslator iTranslator, PersistenceUtility persistenceUtility, ITranslationContext iTranslationContext) throws ConvertException {
        this.translateViewTriggers(iTranslator, persistenceUtility, iTranslationContext);
        this.translateTableTriggers(iTranslator, persistenceUtility, iTranslationContext);
    }

    private void translateStoredPrograms(ITranslator iTranslator, PersistenceUtility persistenceUtility, ITranslationContext iTranslationContext) throws ConvertException {
        try (CloseableIterator<MgvAllStoredProgramsRec> closeableIterator = null;){
            closeableIterator = persistenceUtility.getStoredProgramsForConnectionId(this.getSourceConnectionId());
            iTranslationContext.setObjCount(persistenceUtility.getObjectCount(this.getSourceConnectionId(), "MD_STORED_PROGRAMS"));
            iTranslationContext.setObjIndex(0);
            while (closeableIterator.hasNext()) {
                Object object;
                if (this.shouldCancel()) {
                    object = new ConvertEvent(-1, "TRANSLATE", "");
                    this.getAudience().fireListeners((ConvertEvent)object);
                    return;
                }
                object = (MgvAllStoredProgramsRec)closeableIterator.next();
                if (!persistenceUtility.isDBObjectEnabled(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId())) continue;
                if (!this.isTranslated(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId()) && !this.isTranslating(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId())) {
                    MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), ((MgvAllStoredProgramsRec)object).getStoredProgramId());
                    try {
                        String string = persistenceUtility.getHostForConnection(((MgvAllConnectionsRec)object).getConnectionId());
                        TranslationDBObject translationDBObject = ConvertUtils.asDBObject(string, ((MgvAllCatalogsRec)object).getCatalogName(), ((MgvAllSchemasRec)object).getSchemaName(), mdStoredProgram);
                        this.translateIndividualStoredProgram(iTranslator, iTranslationContext, translationDBObject, mdStoredProgram);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.118"), Messages.getString("ConverterWorker.119"), iOException.getMessage(), iOException);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
                System.gc();
            }
        }
    }

    private void translateFunctions(ITranslator iTranslator, PersistenceUtility persistenceUtility, ITranslationContext iTranslationContext) throws ConvertException {
        try (CloseableIterator<MgvAllStoredProgramsRec> closeableIterator = null;){
            closeableIterator = persistenceUtility.getFunctionsForConnectionId(this.getSourceConnectionId());
            iTranslationContext.setObjCount(persistenceUtility.getFunctionCountForConnectionId(this.getSourceConnectionId()));
            iTranslationContext.setObjIndex(0);
            while (closeableIterator.hasNext()) {
                Object object;
                if (this.shouldCancel()) {
                    object = new ConvertEvent(-1, "TRANSLATE", "");
                    this.getAudience().fireListeners((ConvertEvent)object);
                    return;
                }
                object = (MgvAllStoredProgramsRec)closeableIterator.next();
                if (!persistenceUtility.isDBObjectEnabled(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId())) continue;
                if (!this.isTranslated(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId()) && !this.isTranslating(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId())) {
                    MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), ((MgvAllStoredProgramsRec)object).getStoredProgramId());
                    try {
                        String string = persistenceUtility.getHostForConnection(((MgvAllConnectionsRec)object).getConnectionId());
                        TranslationDBObject translationDBObject = ConvertUtils.asDBObject(string, ((MgvAllCatalogsRec)object).getCatalogName(), ((MgvAllSchemasRec)object).getSchemaName(), mdStoredProgram);
                        this.translateIndividualStoredProgram(iTranslator, iTranslationContext, translationDBObject, mdStoredProgram);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.118"), Messages.getString("ConverterWorker.119"), iOException.getMessage(), iOException);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
                System.gc();
            }
        }
    }

    private void translateProcedures(ITranslator iTranslator, PersistenceUtility persistenceUtility, ITranslationContext iTranslationContext) throws ConvertException {
        try (CloseableIterator<MgvAllStoredProgramsRec> closeableIterator = null;){
            closeableIterator = persistenceUtility.getProceduresForConnectionId(this.getSourceConnectionId());
            iTranslationContext.setObjCount(persistenceUtility.getProcedureCountForConnectionId(this.getSourceConnectionId()));
            iTranslationContext.setObjIndex(0);
            while (closeableIterator.hasNext()) {
                Object object;
                if (this.shouldCancel()) {
                    object = new ConvertEvent(-1, "TRANSLATE", "");
                    this.getAudience().fireListeners((ConvertEvent)object);
                    return;
                }
                object = (MgvAllStoredProgramsRec)closeableIterator.next();
                if (!persistenceUtility.isDBObjectEnabled(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId())) continue;
                if (!this.isTranslated(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId()) && !this.isTranslating(((MgvAllStoredProgramsRec)object).getStoredProgramId().getId())) {
                    MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), ((MgvAllStoredProgramsRec)object).getStoredProgramId());
                    try {
                        String string = persistenceUtility.getHostForConnection(((MgvAllConnectionsRec)object).getConnectionId());
                        TranslationDBObject translationDBObject = ConvertUtils.asDBObject(string, ((MgvAllCatalogsRec)object).getCatalogName(), ((MgvAllSchemasRec)object).getSchemaName(), mdStoredProgram);
                        this.translateIndividualStoredProgram(iTranslator, iTranslationContext, translationDBObject, mdStoredProgram);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.118"), Messages.getString("ConverterWorker.119"), iOException.getMessage(), iOException);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
                System.gc();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualStoredProgram(ITranslator iTranslator, ITranslationContext iTranslationContext, TranslationDBObject translationDBObject, MdStoredProgram mdStoredProgram) throws PersistenceException, NoSuchObjectException {
        ConvertEvent convertEvent = null;
        this.m_translatingObjects.push(mdStoredProgram.getKey().getId());
        iTranslationContext.setObjIndex(iTranslationContext.getObjIndex() + 1);
        try {
            MdStoredProgram mdStoredProgram2 = ConvertUtils.findProgramCopy(mdStoredProgram, this.getPersistenceManager(), this.getConvertedConnectionId());
            try {
                this.deletePreviousLogs(mdStoredProgram2.getKey().getId());
                convertEvent = new ConvertEvent(8, "MD_STORED_PROGRAMS", mdStoredProgram.getName() + this.getCountString(iTranslationContext));
                this.getAudience().fireListeners(convertEvent);
                s_logger.log(Level.INFO, Messages.getString("ConverterWorker.AttemptingConvert") + mdStoredProgram.getName(), new Object[]{new ClickableLogInfo(mdStoredProgram2, Messages.getString("ConverterWorker.123"))});
                StopWatch stopWatch = new StopWatch();
                TranslationResult translationResult = iTranslator.translate(translationDBObject, iTranslationContext, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
                mdStoredProgram2.setNativeSql(translationResult.getFullDdlScript());
                long l = stopWatch.getDuration();
                mdStoredProgram2.setLanguage("OracleSQL");
                mdStoredProgram2.save(this.getPersistenceManager());
                this.m_translationLogManager.commitLog(Level.INFO, (Object)mdStoredProgram, ConverterWorker.multiLogHeader("MD_STORED_PROGRAMS", mdStoredProgram.getName()), mdStoredProgram2);
                s_logger.log(Level.INFO, MessageFormat.format(Messages.getString("ConverterWorker.SuccessfulConvert"), mdStoredProgram.getName(), TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS)), new Object[]{new ClickableLogInfo(mdStoredProgram2, Messages.getString("ConverterWorker.123"))});
                this.storeGenerationOrder(mdStoredProgram2);
                this.persistMetaData(translationResult, translationDBObject.getDBObjectReference());
                convertEvent.setEventId(9);
                this.getAudience().fireListeners(convertEvent);
            }
            catch (TranslationException translationException) {
                try {
                    mdStoredProgram2.setLanguage("FailedSQL");
                    mdStoredProgram2.save(this.getPersistenceManager());
                    s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_STORED_PROGRAMS") + " " + mdStoredProgram2.getName() + " " + translationException.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdStoredProgram2, Messages.getString("ConverterWorker.123"))});
                }
                catch (Exception exception) {
                    s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_STORED_PROGRAMS") + " " + mdStoredProgram.getName() + " " + translationException.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdStoredProgram, Messages.getString("ConverterWorker.127"))});
                }
            }
        }
        catch (NoCopyFoundException noCopyFoundException) {
            MigrationLogUtil.logThrowable(noCopyFoundException.getLocalizedMessage(), Messages.getString("ConverterWorker.128"), (Throwable)noCopyFoundException);
        }
        catch (Exception exception) {
            try {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_STORED_PROGRAMS") + " " + mdStoredProgram.getName() + " " + exception.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdStoredProgram, Messages.getString("ConverterWorker.127"))});
            }
            catch (Exception exception2) {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + ":" + exception2.getMessage(), exception);
            }
        }
        finally {
            this.setSourceTranslated(mdStoredProgram);
            this.m_translatingObjects.pop();
        }
    }

    private String numTranslatingObj(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i <= this.m_translatingObjects.size(); ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void persistMetaData(TranslationResult translationResult, TranslationDBObjectReference translationDBObjectReference) {
        ITranslationMetaData iTranslationMetaData = translationResult.getTranslationMetaData();
        if (iTranslationMetaData == null) {
            return;
        }
        DBObjectId dBObjectId = this.getSourceConnectionId();
        DBObjectId dBObjectId2 = this.getConvertedConnectionId();
        DBObjectId dBObjectId3 = ((PersistableObject)translationResult.getTargetObject().getOMWBObj()).getKey();
        DBObjectId dBObjectId4 = ((PersistableObject)translationDBObjectReference.getOMWBObj()).getKey();
        String string = ((PersistableObject)translationResult.getTargetObject().getOMWBObj()).getObjectType();
        String string2 = ((PersistableObject)translationDBObjectReference.getOMWBObj()).getObjectType();
        this.dropExistingParameters(dBObjectId4);
        this.dropExistingParameters(dBObjectId3);
        this.persistSourceParameters(iTranslationMetaData.getSourceParameters(), dBObjectId, dBObjectId4, string2);
        this.persistTargetParameters(iTranslationMetaData.getTargetParameters(), dBObjectId2, dBObjectId3, string);
    }

    private void dropExistingParameters(DBObjectId dBObjectId) {
        MdMigrParameter.deleteParamInfo(dBObjectId, this.getPersistenceManager());
    }

    private void persistTargetParameters(ArrayList<TranslationParameter> arrayList, DBObjectId dBObjectId, DBObjectId dBObjectId2, String string) {
        for (TranslationParameter translationParameter : arrayList) {
            int n = translationParameter.isExtra() ? 1 : 0;
            int n2 = translationParameter.getParamPosition();
            String string2 = translationParameter.getName();
            String string3 = translationParameter.getParamType();
            if (translationParameter.getDataType() == null) {
                return;
            }
            String string4 = translationParameter.getDataType().getDataType();
            String string5 = "Y";
            MdMigrParameter mdMigrParameter = new MdMigrParameter(dBObjectId, dBObjectId2, string, n, n2, string2, string3, string4, string5);
            try {
                if (translationParameter.getDefaultValue() != null) {
                    String string6 = translationParameter.getDefaultValue().toString();
                    mdMigrParameter.setDefaultValue(string6);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                mdMigrParameter.save(this.getPersistenceManager());
            }
            catch (PersistenceException persistenceException) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.130"), Messages.getString("ConverterWorker.131"), persistenceException.getMessage(), persistenceException);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
            }
        }
    }

    private void persistSourceParameters(ArrayList<TranslationParameter> arrayList, DBObjectId dBObjectId, DBObjectId dBObjectId2, String string) {
        for (TranslationParameter translationParameter : arrayList) {
            int n = 0;
            int n2 = translationParameter.getParamPosition();
            String string2 = translationParameter.getName();
            String string3 = translationParameter.getParamType();
            String string4 = translationParameter.getDataType().getDataType();
            String string5 = "Y";
            MdMigrParameter mdMigrParameter = new MdMigrParameter(dBObjectId, dBObjectId2, string, n, n2, string2, string3, string4, string5);
            try {
                mdMigrParameter.save(this.getPersistenceManager());
            }
            catch (PersistenceException persistenceException) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.133"), Messages.getString("ConverterWorker.134"), persistenceException.getMessage(), persistenceException);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
            }
        }
    }

    private void translateViewDefinitions(ITranslator iTranslator, PersistenceUtility persistenceUtility, ITranslationContext iTranslationContext) throws ConvertException {
        try (CloseableIterator<MgvAllViewsRec> closeableIterator = null;){
            closeableIterator = persistenceUtility.getViewsForConnectionId(this.getSourceConnectionId());
            iTranslationContext.setObjCount(persistenceUtility.getObjectCount(this.getSourceConnectionId(), "MD_VIEWS"));
            iTranslationContext.setObjIndex(0);
            while (closeableIterator.hasNext()) {
                Object object;
                if (this.shouldCancel()) {
                    object = new ConvertEvent(-1, "TRANSLATE", "");
                    this.getAudience().fireListeners((ConvertEvent)object);
                    return;
                }
                object = (MgvAllViewsRec)closeableIterator.next();
                if (!persistenceUtility.isDBObjectEnabled(((MgvAllViewsRec)object).getViewId().getId())) continue;
                if (!this.isTranslated(((MgvAllViewsRec)object).getViewId().getId()) && !this.isTranslating(((MgvAllViewsRec)object).getViewId().getId())) {
                    MdView mdView = MdView.retrieveExistingInstance(this.getPersistenceManager(), ((MgvAllViewsRec)object).getViewId());
                    String string = persistenceUtility.getHostForConnection(((MgvAllConnectionsRec)object).getConnectionId());
                    TranslationDBObject translationDBObject = ConvertUtils.asDBObject(string, ((MgvAllCatalogsRec)object).getCatalogName(), ((MgvAllSchemasRec)object).getSchemaName(), mdView);
                    this.translateIndividualViewDefinition(iTranslator, iTranslationContext, translationDBObject, mdView);
                }
                System.gc();
            }
            this.updateViewGenerationOrder(iTranslationContext);
        }
    }

    private void updateViewGenerationOrder(ITranslationContext iTranslationContext) {
        if (iTranslationContext.getViewGenOrderList() == null || iTranslationContext.getViewGenOrderList().isEmpty()) {
            return;
        }
        String string = "select id from migr_generation_order where object_type = 'MD_VIEWS' and object_id = ? ";
        String string2 = "select generation_order from migr_generation_order where object_type = 'MD_VIEWS' and generation_order <= all (select generation_order from migr_generation_order where object_type = 'MD_VIEWS') ";
        Iterator iterator = iTranslationContext.getViewGenOrderList().iterator();
        int n = -1;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                return;
            }
            n = resultSet.getInt(1);
        }
        catch (Exception exception) {
            return;
        }
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            long l2 = -1L;
            try {
                PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
                preparedStatement.setLong(1, l);
                ResultSet resultSet = preparedStatement.executeQuery();
                l2 = -1L;
                if (!resultSet.next()) continue;
                l2 = resultSet.getLong(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MigrGenerationOrder migrGenerationOrder = null;
            DBObjectId dBObjectId = new DBObjectId(l2);
            migrGenerationOrder = MigrGenerationOrder.getExistingInstance(dBObjectId);
            migrGenerationOrder.setGenerationOrder(iTranslationContext.getViewGenOrderList().indexOf(l) + n);
            try {
                migrGenerationOrder.save(this.getPersistenceManager());
            }
            catch (PersistenceException persistenceException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualViewDefinition(ITranslator iTranslator, ITranslationContext iTranslationContext, TranslationDBObject translationDBObject, MdView mdView) throws PersistenceException, NoSuchObjectException {
        this.m_translatingObjects.push(mdView.getKey().getId());
        iTranslationContext.setObjIndex(iTranslationContext.getObjIndex() + 1);
        try {
            MdView mdView2;
            block15: {
                mdView2 = ConvertUtils.findViewCopy(mdView, this.getPersistenceManager(), this.getConvertedConnectionId());
                if (ConvertUtils.findObjectCopy(this.getPersistenceManager(), mdView.getKey(), "MD_VIEWS", this.getConvertedConnectionId()) != null || this.m_filterList == null) break block15;
                return;
            }
            try {
                this.deletePreviousLogs(mdView2.getKey().getId());
                ConvertEvent convertEvent = new ConvertEvent(8, "MD_VIEWS", mdView.getViewName() + this.getCountString(iTranslationContext));
                this.getAudience().fireListeners(convertEvent);
                s_logger.log(Level.INFO, Messages.getString("ConverterWorker.AttemptingConvert") + mdView.getViewName(), new Object[]{new ClickableLogInfo(mdView, Messages.getString("ConverterWorker.123"))});
                DBObjectId dBObjectId = mdView.getSchemaId();
                MdSchema mdSchema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
                String string = mdSchema.getName();
                iTranslationContext.setDefaultSchema(string);
                iTranslationContext.addInfoKeyValue("schema_id", dBObjectId != null ? dBObjectId.toString() : null);
                StopWatch stopWatch = new StopWatch();
                TranslationResult translationResult = iTranslator.translate(translationDBObject, iTranslationContext, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
                long l = stopWatch.getDuration();
                mdView2.setNativeSql(translationResult.getFullDdlScript());
                mdView2.setLanguage("OracleSQL");
                mdView2.save(this.getPersistenceManager());
                this.m_translationLogManager.commitLog(Level.INFO, (Object)mdView, ConverterWorker.multiLogHeader("MD_VIEWS", mdView.getViewName()), mdView2);
                this.storeGenerationOrder(mdView2);
                convertEvent.setEventId(9);
                this.getAudience().fireListeners(convertEvent);
                s_logger.log(Level.INFO, MessageFormat.format(Messages.getString("ConverterWorker.SuccessfulConvert"), mdView.getViewName(), TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS)), new Object[]{new ClickableLogInfo(mdView2, Messages.getString("ConverterWorker.123"))});
            }
            catch (TranslationException translationException) {
                try {
                    mdView2.setLanguage("FailedSQL");
                    mdView2.save(this.getPersistenceManager());
                    MigrationLogUtil.logThrowable(MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_VIEWS") + " " + mdView2.getViewName() + " " + translationException.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdView2, Messages.getString("ConverterWorker.138"))}, (Throwable)translationException);
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable(MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_VIEWS") + " " + mdView.getViewName() + " " + translationException.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdView, Messages.getString("ConverterWorker.142"))}, (Throwable)translationException);
                }
            }
        }
        catch (NoCopyFoundException noCopyFoundException) {
            MigrationLogUtil.logThrowable(noCopyFoundException.getLocalizedMessage(), Messages.getString("ConverterWorker.143"), (Throwable)noCopyFoundException);
        }
        catch (Exception exception) {
            try {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + " " + MigrationAddinArb.getString("MD_VIEWS") + " " + mdView.getViewName() + " " + exception.getLocalizedMessage(), new Object[]{new ClickableLogInfo(mdView, Messages.getString("ConverterWorker.142"))});
            }
            catch (Exception exception2) {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString("FAILED_TO_CONVERT") + ":" + exception2.getMessage(), exception);
            }
        }
        finally {
            this.setSourceTranslated(mdView);
            this.m_translatingObjects.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transformIdentityColumns() throws ConvertException {
        OracleCallableStatement oracleCallableStatement = null;
        ConvertEvent convertEvent = new ConvertEvent(13, "MD_COLUMNS", "");
        this.getAudience().fireListeners(convertEvent);
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.TRANSFORM_IDENTITY_COLUMNS(?,?)}");
            oracleCallableStatement.registerOutParameter(1, 4);
            oracleCallableStatement.setLong(2, this.getConvertedConnectionId().getId());
            if (MigrationAddin.getConfigurationData().getIdentityCols()) {
                oracleCallableStatement.setString(3, "Y");
            } else {
                oracleCallableStatement.setString(3, "N");
            }
            oracleCallableStatement.execute();
            long l = oracleCallableStatement.getLong(1);
            convertEvent.setEventId(14);
            this.getAudience().fireListeners(convertEvent);
        }
        catch (SQLException sQLException) {
            MigrationLogUtil.logThrowable(sQLException.getLocalizedMessage(), Messages.getString("ConverterWorker.147"), (Throwable)sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void setMapId(DBObjectId dBObjectId) {
        this.m_mapId = dBObjectId;
    }

    protected DBObjectId getMapId() {
        return this.m_mapId;
    }

    protected TranslationSession getTranslationSession() {
        return this.m_translationSession;
    }

    protected void setTranslationSession(TranslationSession translationSession) {
        this.m_translationSession = translationSession;
    }

    public boolean isTranslated(Object object) {
        if (object instanceof PersistableObject) {
            return this.m_translatedSourceObjects.contains(((PersistableObject)object).getKey());
        }
        if (object instanceof Long) {
            return this.m_translatedSourceObjects.contains(new DBObjectId((Long)object));
        }
        return false;
    }

    public boolean isTranslating(Object object) {
        return object instanceof PersistableObject ? this.m_translatingObjects.contains(((PersistableObject)object).getKey().getId()) : object instanceof Long && this.m_translatingObjects.contains(object);
    }

    public void translate(Object object, ITranslationContext iTranslationContext) {
        if (this.shouldCancel()) {
            ConvertEvent convertEvent = new ConvertEvent(-1, "TRANSLATE", "");
            this.getAudience().fireListeners(convertEvent);
            return;
        }
        PersistableObject persistableObject = (PersistableObject)object;
        if (this.isTranslated(persistableObject) || this.isTranslating(persistableObject)) {
            return;
        }
        ITranslator iTranslator = this.getPlatformConverter().getPlaformTranslator();
        if (iTranslator != null) {
            try {
                if (iTranslationContext == null) {
                    iTranslationContext = new TranslationContext(this.getPersistenceManager(), this.getConvertedConnectionId(), 100, this.m_mapId);
                }
            }
            catch (PersistenceException persistenceException) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.148"), Messages.getString("ConverterWorker.149"), persistenceException.getMessage(), persistenceException);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
            }
            try {
                TranslationDBObject translationDBObject = ConvertUtils.asTranslationDBObject(persistableObject, this.getPersistenceManager());
                if (translationDBObject == null) {
                    return;
                }
                if (persistableObject.getObjectType().equalsIgnoreCase("MD_STORED_PROGRAMS")) {
                    this.translateIndividualStoredProgram(iTranslator, iTranslationContext, translationDBObject, (MdStoredProgram)persistableObject);
                } else if (persistableObject.getObjectType().equalsIgnoreCase("MD_VIEWS")) {
                    this.translateIndividualViewDefinition(iTranslator, iTranslationContext, translationDBObject, (MdView)persistableObject);
                } else if (persistableObject.getObjectType().equalsIgnoreCase("MD_TRIGGERS")) {
                    if (((MdTrigger)persistableObject).getTriggerOnFlag().equalsIgnoreCase("V")) {
                        this.translateIndividualViewTrigger(iTranslator, iTranslationContext, translationDBObject, (MdTrigger)persistableObject);
                    } else if (((MdTrigger)persistableObject).getTriggerOnFlag().equalsIgnoreCase("T")) {
                        this.translateIndividualTableTrigger(iTranslator, iTranslationContext, translationDBObject, (MdTrigger)persistableObject);
                    }
                } else if (persistableObject.getObjectType().equalsIgnoreCase("MD_CONSTRAINTS")) {
                    this.translateIndividualCheckConstraint(iTranslator, iTranslationContext, translationDBObject, (MdConstraint)persistableObject);
                }
            }
            catch (Exception exception) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").logp(Level.SEVERE, Messages.getString("ConverterWorker.150"), Messages.getString("ConverterWorker.151"), exception.getMessage(), exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    private static String multiLogHeader(String string, String string2) {
        String string3 = MigrationAddinArb.getString("CONVERT_MULTIPLE_LIMITATIONS");
        String string4 = ResourceBundle.getBundle("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").getString(string);
        return MessageFormat.format(string3, string4, string2);
    }

    private void setSourceTranslated(PersistableObject persistableObject) {
        if (this.m_translatedSourceObjects != null) {
            this.m_translatedSourceObjects.add(persistableObject.getKey());
        }
    }

    private void rollbackConvert() {
        if (this.m_convertedConnection != null) {
            try {
                this.m_convertedConnection.delete(this.getPersistenceManager());
                this.m_convertedConnection = null;
                this.m_convertedConnectionId = null;
            }
            catch (PersistenceException persistenceException) {
                s_logger.log(Level.WARNING, "Convert.ERROR_ROLLING_BACK", new Object[]{persistenceException.getLocalizedMessage()});
            }
        }
    }

    private String getRawValue(String string) throws PersistenceException {
        String string2 = "SELECT UTL_RAW.CAST_TO_RAW(?) FROM DUAL";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string2);
            if (preparedStatement != null) {
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    string3 = resultSet.getString(1);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            CloseableResultSet.close(null, resultSet);
        }
        return string3;
    }

    private void deletePreviousLogs(Long l) throws PersistenceException {
        String string = "DELETE FROM MIGRLOG WHERE REF_OBJECT_ID = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
            if (preparedStatement != null) {
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            CloseableResultSet.close(null, resultSet);
        }
    }

    private final void dbg_plsql() throws SQLException {
        Connection connection = this.getPersistenceManager().getConn();
        OracleCallableStatement oracleCallableStatement = null;
        if (connection != null) {
            try {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call DBMS_DEBUG_JDWP.CONNECT_TCP( ?, ? )}");
                oracleCallableStatement.setString(1, "localhost");
                oracleCallableStatement.setInt(2, 4001);
                oracleCallableStatement.execute();
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
        }
    }
}

