/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.capture.CaptureCmd;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.PlatformDatabaseListProvider;
import oracle.dbtools.raptor.utils.Connections;

public class MSSqlServerDatabaseListProvider
implements PlatformDatabaseListProvider {
    @Override
    public ArrayList<String> getAvailableOfflineDatabaseList(String string) {
        ArrayList<String> arrayList = null;
        File file = null;
        String string2 = null;
        File file2 = null;
        File[] fileArray = null;
        if (string != null && (file = new File(string)).exists()) {
            string2 = file.getParent();
            file2 = new File(string2);
            fileArray = file2.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                if (fileArray[i].getName().equalsIgnoreCase("master")) continue;
                arrayList.add(fileArray[i].getName());
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getAvailableOnlineDatabaseList(String string) {
        boolean bl = this.isClassicMigration(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!bl) {
            CaptureCmd captureCmd = new CaptureCmd();
            return captureCmd.getListOfOnlineSourceDatabases(string);
        }
        try {
            String string2 = Connections.getInstance().getConnection(string).getMetaData().getURL();
            String string3 = string2.substring(string2.lastIndexOf(47) + 1, string2.length());
            arrayList.add(string3);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private boolean isClassicMigration(String string) {
        boolean bl = false;
        String string2 = null;
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            string2 = connection.getMetaData().getDatabaseProductVersion();
            if (string2.startsWith("07.") || string2.startsWith("7.") || string2.startsWith("08.") || string2.startsWith("8.")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isSystemDatabase(String string) {
        return false;
    }
}

