/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import oracle.dbtools.migration.capture.EMDataMover;
import oracle.dbtools.migration.capture.EMSQL;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EMManager {
    ArrayList<EMSQL> m_stageDDLs = new ArrayList();
    EMSQL m_databaseListQuery = null;
    ArrayList<EMDataMover> m_emStageTables = new ArrayList();
    ArrayList<EMSQL> m_emShredQuery = new ArrayList();

    public EMManager(InputStream inputStream) throws IOException, SAXException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(true);
        dOMParser.parse(inputStream);
        XMLDocument xMLDocument = dOMParser.getDocument();
        Node node = xMLDocument.getChildNodes().item(0);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("stageddl")) {
                this.processStageDDL(node2);
                continue;
            }
            if (node2.getNodeName().equals("stagecapture")) {
                this.processStageCapture(node2);
                continue;
            }
            if (!node2.getNodeName().equals("shredcapture")) continue;
            this.processShredCapture(node2);
        }
    }

    public ArrayList<EMSQL> getStageDDL() {
        return this.m_stageDDLs;
    }

    public EMSQL getDatabaseListQuery() {
        return this.m_databaseListQuery;
    }

    public ArrayList<EMDataMover> getStageTableCapture() {
        return this.m_emStageTables;
    }

    public ArrayList<EMSQL> getShredQueries() {
        return this.m_emShredQuery;
    }

    private void processShredCapture(Node node) {
        XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"sql");
        for (int i = 0; i < xMLNodeArray.length; ++i) {
            EMSQL eMSQL = new EMSQL((Node)xMLNodeArray[i]);
            this.m_emShredQuery.add(eMSQL);
        }
    }

    private void processStageCapture(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("listdatabases")) {
                this.processListDatabases(node2);
                continue;
            }
            if (!node2.getNodeName().equals("stagetablecapture")) continue;
            this.processStageTableCapture(node2);
        }
    }

    private void processStageTableCapture(Node node) {
        boolean bl = this.getPerDatabase(node);
        boolean bl2 = this.getTranslation(node);
        EMSQL eMSQL = this.getSourceQuery(node);
        EMSQL eMSQL2 = this.getStageInsert(node);
        this.m_emStageTables.add(new EMDataMover(bl, bl2, eMSQL, eMSQL2));
    }

    private EMSQL getStageInsert(Node node) {
        try {
            Node node2 = XMLHelper.getChildNode((Node)node, (String)"stageinsert");
            Node node3 = XMLHelper.getChildNode((Node)node2, (String)"sql");
            return new EMSQL(node3);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            return null;
        }
    }

    private EMSQL getSourceQuery(Node node) {
        Node node2 = XMLHelper.getChildNode((Node)node, (String)"sourcequery");
        if (node2 != null) {
            return new EMSQL(XMLHelper.getChildNode((Node)node2, (String)"sql"));
        }
        return new EMSQL();
    }

    private boolean getPerDatabase(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("perdatabase");
        if (node2 != null) {
            String string = node2.getNodeValue();
            return string.equalsIgnoreCase("true");
        }
        return true;
    }

    private boolean getTranslation(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("translation");
        if (node2 != null) {
            String string = node2.getNodeValue();
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    private void processListDatabases(Node node) {
        EMSQL eMSQL;
        Node node2 = XMLHelper.getChildNode((Node)node, (String)"sql");
        this.m_databaseListQuery = eMSQL = new EMSQL(node2);
    }

    private void processStageDDL(Node node) {
        XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"sql");
        for (int i = 0; i < xMLNodeArray.length; ++i) {
            EMSQL eMSQL = new EMSQL((Node)xMLNodeArray[i]);
            this.m_stageDDLs.add(eMSQL);
        }
    }
}

