/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.migration.capture.AccessDatabaseListProvider;
import oracle.dbtools.migration.capture.DB2DatabaseListProvider;
import oracle.dbtools.migration.capture.MSSqlServerDatabaseListProvider;
import oracle.dbtools.migration.capture.MySQLDatabaseListProvider;
import oracle.dbtools.migration.capture.PostgreSQLDatabaseListProvider;
import oracle.dbtools.migration.capture.SybaseDatabaseListProvider;
import oracle.dbtools.migration.capture.TeradataDatabaseListProvider;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.PlatformDatabaseListProvider;

public class DatabaseProviderRegistry {
    private static Map<String, PlatformDatabaseListProvider> _registry = new HashMap<String, PlatformDatabaseListProvider>();

    public static Collection<String> getAvailableDBListOnline(String string, String string2) {
        PlatformDatabaseListProvider platformDatabaseListProvider;
        Collection<String> collection = null;
        if (string != null && string.trim().length() > 0 && (platformDatabaseListProvider = _registry.get(string)) != null) {
            ArrayList<String> arrayList = platformDatabaseListProvider.getAvailableOnlineDatabaseList(string2);
            collection = arrayList != null ? Collections.unmodifiableCollection(arrayList) : null;
        }
        return collection;
    }

    public static Collection<String> getAvailableDBListOffline(String string, String string2) {
        PlatformDatabaseListProvider platformDatabaseListProvider;
        Collection<String> collection = null;
        if (string != null && string.trim().length() > 0 && (platformDatabaseListProvider = _registry.get(string)) != null) {
            ArrayList<String> arrayList = platformDatabaseListProvider.getAvailableOfflineDatabaseList(string2);
            collection = arrayList != null ? Collections.unmodifiableCollection(arrayList) : null;
        }
        return collection;
    }

    public static void bleachSystemObjects(String string, Collection<String> collection) {
        PlatformDatabaseListProvider platformDatabaseListProvider;
        if (string != null && string.trim().length() > 0 && (platformDatabaseListProvider = _registry.get(string)) != null) {
            Iterator<String> iterator = collection.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = iterator.next();
                if (!platformDatabaseListProvider.isSystemDatabase(string2)) continue;
                iterator.remove();
            }
        }
    }

    static {
        _registry.put("MSAccess", new AccessDatabaseListProvider());
        _registry.put("Sybase", new SybaseDatabaseListProvider());
        _registry.put("Microsoft SQL Server", new MSSqlServerDatabaseListProvider());
        _registry.put("DB2", new DB2DatabaseListProvider());
        _registry.put("MySQL", new MySQLDatabaseListProvider());
        _registry.put("Teradata", new TeradataDatabaseListProvider());
        _registry.put("PostgreSQL", new PostgreSQLDatabaseListProvider());
    }
}

