/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.ide.util.Assert;

public class PropertyBasedPersitableObjectIterator<T extends PersistableObject>
implements CloseableIterator<T> {
    private static final String QUERYBY_PROPERTY = "SELECT DISTINCT(REF_ID_FK), REF_TYPE FROM MD_ADDITIONAL_PROPERTIES WHERE PROP_KEY IN (";
    private static final String CONDITION = ") AND CONNECTION_ID_FK = ?";
    private PersistenceManager m_persistenceManager;
    private String[] m_propertyKeys;
    private PreparedStatement m_preparedStatement;
    private DBObjectId m_connectionId;
    private ResultSet m_resultSet;
    private DBObjectId m_nextId;
    private String m_nextObjectType;
    private PersistenceUtility m_persistenceUtility;

    public PropertyBasedPersitableObjectIterator(String[] stringArray, PersistenceManager persistenceManager, DBObjectId dBObjectId) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Property keys invalid");
        }
        this.setPersistenceManager(persistenceManager);
        this.setConnectionId(dBObjectId);
        this.setPersistenceUtility(PersistenceUtility.getInstance(persistenceManager));
        this.m_propertyKeys = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_propertyKeys[i] = stringArray[i];
        }
    }

    private String generateSQLQuery() {
        StringBuffer stringBuffer = new StringBuffer(QUERYBY_PROPERTY);
        for (int i = 0; i < this.m_propertyKeys.length; ++i) {
            stringBuffer.append('?');
            if (i >= this.m_propertyKeys.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(CONDITION);
        return stringBuffer.toString();
    }

    private PreparedStatement getPreparedStatement() throws SQLException {
        int n;
        String string = this.generateSQLQuery();
        PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(this.generateSQLQuery());
        for (n = 0; n < this.m_propertyKeys.length; ++n) {
            preparedStatement.setString(n + 1, this.m_propertyKeys[n]);
        }
        preparedStatement.setLong(n + 1, this.getConnectionId().getId());
        return preparedStatement;
    }

    @Override
    public void close() {
        CloseableResultSet closeableResultSet = new CloseableResultSet(null, this.m_resultSet);
        closeableResultSet.close();
        this.m_preparedStatement = null;
        this.m_resultSet = null;
    }

    @Override
    public boolean hasNext() {
        if (this.m_preparedStatement == null) {
            try {
                this.m_preparedStatement = this.getPreparedStatement();
                this.m_resultSet = this.m_preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        if (this.m_resultSet == null) {
            return false;
        }
        try {
            if (this.m_resultSet.next()) {
                this.m_nextId = new DBObjectId(this.m_resultSet.getLong(1));
                this.m_nextObjectType = this.m_resultSet.getString(2);
                return true;
            }
            CloseableResultSet closeableResultSet = new CloseableResultSet(null, this.m_resultSet);
            closeableResultSet.close();
            return false;
        }
        catch (SQLException sQLException) {
            this.m_resultSet = null;
            this.m_preparedStatement = null;
            return false;
        }
    }

    @Override
    public T next() {
        PersistableObject persistableObject = null;
        if (this.m_nextId == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            persistableObject = this.getPersistenceUtility().loadPersistableObject(this.m_nextId, this.m_nextObjectType);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            Assert.printStackTrace((Throwable)noSuchObjectException);
            throw new NoSuchElementException(noSuchObjectException.getMessage());
        }
        catch (PersistenceException persistenceException) {
            Assert.printStackTrace((Throwable)persistenceException);
            throw new NoSuchElementException(persistenceException.getMessage());
        }
        this.m_nextId = null;
        this.m_nextObjectType = null;
        return (T)persistableObject;
    }

    @Override
    public void remove() {
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected DBObjectId getConnectionId() {
        return this.m_connectionId;
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        this.m_connectionId = dBObjectId;
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }
}

