/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import oracle.dbtools.metadata.persistence.ClobHelper;

public class PrepareClobHelper {
    public static final int OVERSIZE = 20000;
    private File m_fileStore = null;
    private BufferedWriter m_bufferedWriter = null;
    private int m_totalLength = 0;
    private StringBuffer m_memoryStore = null;
    private int m_overSize = 20000;

    public PrepareClobHelper() {
    }

    public PrepareClobHelper(int n) {
        this.m_overSize = n;
    }

    public void append(String string) throws IOException {
        if (string != null) {
            int n = string.length();
            if (this.m_memoryStore == null) {
                this.m_memoryStore = new StringBuffer();
            }
            if (this.m_fileStore == null) {
                this.m_memoryStore.append(string);
            } else {
                this.m_bufferedWriter.write(string);
            }
            this.m_totalLength += n;
            if (this.m_totalLength > this.m_overSize && this.m_fileStore == null) {
                this.m_fileStore = File.createTempFile("Clobstore", ".tmp");
                this.m_fileStore.deleteOnExit();
                this.m_bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_fileStore), "UTF8"), this.m_overSize);
                this.m_bufferedWriter.write(this.m_memoryStore.toString());
                this.m_memoryStore = new StringBuffer();
            }
        }
    }

    public ClobHelper getClobHelper() throws IOException {
        if (this.m_fileStore != null && this.m_bufferedWriter != null) {
            this.m_bufferedWriter.close();
        }
        if (this.m_memoryStore == null) {
            return null;
        }
        if (this.m_fileStore == null) {
            return new ClobHelper(this.m_memoryStore.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_fileStore), "UTF8"));
        return new ClobHelper(bufferedReader, this.m_totalLength);
    }

    public void close() throws IOException {
        if (this.m_fileStore != null) {
            this.m_bufferedWriter.close();
        }
        if (this.m_fileStore != null) {
            this.m_fileStore.delete();
        }
    }
}

