/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public abstract class PersistableObjectIterator
implements CloseableIterator {
    protected ResultSet m_resultSet;
    private PreparedStatement m_preparedStatement;
    protected Class m_class;
    private DBObjectId m_nextId;
    private PersistenceManager m_persistenceManager;

    public PersistableObjectIterator(Class clazz, PersistenceManager persistenceManager) {
        this.setPersistenceManager(persistenceManager);
        this.m_class = clazz;
        String string = this.getTableName();
        if (string == null) {
            throw new IllegalStateException("Invalid class");
        }
    }

    protected String getTableName() {
        String string = null;
        try {
            Field field = this.m_class.getField("TABLE_NAME");
            string = field.get(new Object()).toString();
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    @Override
    public boolean hasNext() {
        if (this.m_preparedStatement == null) {
            try {
                this.m_preparedStatement = this.getPreparedStatement();
                this.m_resultSet = this.m_preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        if (this.m_resultSet == null) {
            return false;
        }
        try {
            if (this.m_resultSet.next()) {
                this.m_nextId = new DBObjectId(this.m_resultSet.getLong(1));
                return true;
            }
            CloseableResultSet closeableResultSet = new CloseableResultSet(null, this.m_resultSet);
            closeableResultSet.close();
            return false;
        }
        catch (SQLException sQLException) {
            this.m_resultSet = null;
            this.m_preparedStatement = null;
            return false;
        }
    }

    @Override
    public Object next() {
        Object object = null;
        if (this.m_nextId == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Class[] classArray = new Class[]{PersistenceManager.class, DBObjectId.class};
        try {
            Method method = this.m_class.getMethod("retrieveExistingInstance", classArray);
            Object[] objectArray = new Object[]{this.getPersistenceManager(), this.m_nextId};
            object = method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new NoSuchElementException(exception.getMessage());
        }
        this.m_nextId = null;
        return object;
    }

    @Override
    public void remove() {
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    @Override
    public void close() {
        CloseableResultSet.close(null, this.m_resultSet);
        this.m_resultSet = null;
    }

    public void closePreparedStatement() {
        CloseableResultSet.close(this.m_preparedStatement, null);
        this.m_preparedStatement = null;
    }

    protected abstract PreparedStatement getPreparedStatement() throws SQLException;
}

