/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MgvAllProjectsRec;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MgvIterator
implements CloseableIterator {
    private CloseableResultSet m_crs;
    private Constructor m_recordConstructor;
    private MgvAllProjectsRec m_nextRecord;

    public MgvIterator(Class clazz, String string, DBObjectId dBObjectId, PersistenceManager persistenceManager) throws PersistenceException {
        Class[] classArray = new Class[]{ResultSet.class};
        try {
            this.m_recordConstructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PersistenceException(noSuchMethodException);
        }
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string);
            preparedStatement.setLong(1, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            this.m_crs = new CloseableResultSet(null, resultSet);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    @Override
    public void close() {
        if (this.m_crs != null) {
            this.m_crs.close();
        }
    }

    @Override
    public boolean hasNext() {
        block6: {
            if (this.m_crs == null || this.m_crs.getResultSet() == null) {
                return false;
            }
            ResultSet resultSet = this.m_crs.getResultSet();
            try {
                if (resultSet.next()) {
                    Object[] objectArray = new Object[]{resultSet};
                    try {
                        this.m_nextRecord = (MgvAllProjectsRec)this.m_recordConstructor.newInstance(objectArray);
                        break block6;
                    }
                    catch (Exception exception) {
                        this.m_crs.close();
                        this.m_crs = null;
                        return false;
                    }
                }
                this.m_crs.close();
                this.m_crs = null;
                return false;
            }
            catch (SQLException sQLException) {
                this.m_crs.close();
                this.m_crs = null;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object next() {
        if (this.m_nextRecord == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_nextRecord;
    }

    @Override
    public void remove() {
    }
}

