/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class DBObjectHierarchy {
    private MdConnection m_connection = null;
    private MdCatalog m_catalog = null;
    private MdSchema m_schema = null;
    private PersistableObject m_object = null;
    private PersistableObject m_part = null;
    private String m_objectType = null;
    private String m_partType = null;

    public DBObjectHierarchy(PersistableObject persistableObject, PersistenceManager persistenceManager) {
        this.init(persistableObject, persistenceManager);
    }

    private void init(PersistableObject persistableObject, PersistenceManager persistenceManager) {
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
        if (persistableObject == null) {
            return;
        }
        PersistableObject persistableObject2 = null;
        try {
            if (persistableObject.getObjectType().equals("MD_COLUMNS") || persistableObject.getObjectType().equals("MD_CONSTRAINTS") || persistableObject.getObjectType().equals("MD_TRIGGERS")) {
                this.setPart(persistableObject);
                this.setPartType(persistableObject.getObjectType());
                persistableObject2 = persistenceUtility.loadParentPersistableObject(persistableObject);
            } else {
                persistableObject2 = persistableObject;
            }
            PersistableObject persistableObject3 = null;
            if (!persistableObject2.getObjectType().equals("MD_SCHEMAS")) {
                this.setObject(persistableObject2);
                this.setObjectType(persistableObject2.getObjectType());
                persistableObject3 = persistenceUtility.loadParentPersistableObject(persistableObject2);
            } else {
                persistableObject3 = persistableObject2;
            }
            this.setSchema((MdSchema)persistableObject3);
            PersistableObject persistableObject4 = persistenceUtility.loadParentPersistableObject(persistableObject3);
            this.setCatalog((MdCatalog)persistableObject4);
            PersistableObject persistableObject5 = persistenceUtility.loadParentPersistableObject(persistableObject4);
            this.setConnection((MdConnection)persistableObject5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MdCatalog getCatalog() {
        return this.m_catalog;
    }

    public void setCatalog(MdCatalog mdCatalog) {
        this.m_catalog = mdCatalog;
    }

    public MdConnection getConnection() {
        return this.m_connection;
    }

    public void setConnection(MdConnection mdConnection) {
        this.m_connection = mdConnection;
    }

    public PersistableObject getObject() {
        return this.m_object;
    }

    public void setObject(PersistableObject persistableObject) {
        this.m_object = persistableObject;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public void setObjectType(String string) {
        this.m_objectType = string;
    }

    public PersistableObject getPart() {
        return this.m_part;
    }

    public void setPart(PersistableObject persistableObject) {
        this.m_part = persistableObject;
    }

    public String getPartType() {
        return this.m_partType;
    }

    public void setPartType(String string) {
        this.m_partType = string;
    }

    public MdSchema getSchema() {
        return this.m_schema;
    }

    public void setSchema(MdSchema mdSchema) {
        this.m_schema = mdSchema;
    }

    public TranslationDBObjectReference getTranslationDBObjectReference() {
        TranslationObjectType translationObjectType = TranslationContext.getRosettaObjectType(this.getPart() != null ? this.getPart() : (this.getObject() != null ? this.getObject() : this.getSchema()));
        String string = translationObjectType.equals(TranslationObjectType.TRIGGER_TYPE) ? this.getPartName() : this.getObjectName();
        String string2 = translationObjectType.equals(TranslationObjectType.TRIGGER_TYPE) ? this.getObjectName() : this.getPartName();
        return new TranslationDBObjectReference(this.getConnection().getHost(), this.getCatalog().getCatalogName(), this.getSchema().getName(), string, string2, translationObjectType, (Object)(this.getPart() != null ? this.getPart() : this.getObject()));
    }

    private String getObjectName() {
        if (this.getObjectType() == null) {
            return null;
        }
        if (this.getObjectType().equalsIgnoreCase("MD_TABLES")) {
            return ((MdTable)this.getObject()).getTableName();
        }
        if (this.getObjectType().equalsIgnoreCase("MD_STORED_PROGRAMS")) {
            return ((MdStoredProgram)this.getObject()).getName();
        }
        if (this.getObjectType().equalsIgnoreCase("MD_TRIGGERS")) {
            return ((MdTrigger)this.getObject()).getTriggerName();
        }
        if (this.getObjectType().equalsIgnoreCase("MD_VIEWS")) {
            return ((MdView)this.getObject()).getViewName();
        }
        return null;
    }

    private String getPartName() {
        if (this.getPart() == null) {
            return null;
        }
        if (this.getPartType().equalsIgnoreCase("MD_CONSTRAINTS")) {
            return ((MdConstraint)this.getPart()).getName();
        }
        if (this.getPartType().equalsIgnoreCase("MD_COLUMNS")) {
            return ((MdColumn)this.getPart()).getColumnName();
        }
        if (this.getPartType().equalsIgnoreCase("MD_TRIGGERS")) {
            return ((MdTrigger)this.getPart()).getTriggerName();
        }
        return null;
    }
}

