/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class ConstraintsIterator
extends PersistableObjectIterator {
    private static final String GET_CHECK_CONSTRAINTS_FOR_CONNECTIONID_QUERY = "SELECT ID FROM MD_CONSTRAINTS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?) AND CONSTRAINT_TYPE = ?";
    private static final String GET_ALL_CONSTAINTS_QUERY = "SELECT ID FROM MD_CONSTRAINTS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?)";
    private PreparedStatement m_myStatement;

    public ConstraintsIterator(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        super(MdConstraint.class, persistenceManager);
        Object object = "";
        try {
            Object object2;
            if (migrationObjectFilterList != null && (object2 = migrationObjectFilterList.getFilterForType(string)) != null) {
                object = ((MigrationObjectFilter)object2).toWhereConditionForMigrationRepository();
                if (object == null) {
                    throw new IllegalStateException("Error creating where condition");
                }
                if (((String)object).length() > 0) {
                    object = (String)object + " AND " + (String)object;
                }
            }
            if (string != null) {
                object2 = GET_CHECK_CONSTRAINTS_FOR_CONNECTIONID_QUERY + (String)object;
                this.m_myStatement = persistenceManager.getPreparedStatement((String)object2);
                this.m_myStatement.setLong(1, dBObjectId.getId());
                this.m_myStatement.setString(2, string);
            } else {
                object2 = GET_ALL_CONSTAINTS_QUERY + (String)object;
                this.m_myStatement = persistenceManager.getPreparedStatement((String)object2);
                this.m_myStatement.setLong(1, dBObjectId.getId());
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    @Override
    protected PreparedStatement getPreparedStatement() {
        return this.m_myStatement;
    }
}

