/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.db.PasswordPrompter;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.security.misc.Checksum;

public class DatabaseProviderHelperImplementation
implements DatabaseProviderHelper.DatabaseProviderHelperImpl {
    public String getProgramName() {
        return null;
    }

    public PasswordPrompter getPasswordPrompter() {
        return null;
    }

    public ReferenceWorker<?> getDefaultWorker() {
        return null;
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        while (clazz != null) {
            linkedHashSet.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return linkedHashSet.toArray(new Class[linkedHashSet.size()]);
    }

    static String goingOut(String string) {
        try {
            byte[] byArray = string.getBytes();
            byte[] byArray2 = Checksum.MD5((byte[])byArray, null);
            return RepConversion.bArray2String(byArray2);
        }
        catch (Throwable throwable) {
            DatabaseProviderHelper.DatabaseProviderHelperImpl.getDefaultLogger().log(Level.FINE, "Legacy encryption failed", throwable);
            return null;
        }
    }

    public static String comingIn(String string) {
        try {
            byte[] byArray = RepConversion.convertHexStringToByte(string);
            byte[] byArray2 = Checksum.SHA((byte[])byArray, null);
            return new String(byArray2);
        }
        catch (Throwable throwable) {
            DatabaseProviderHelper.DatabaseProviderHelperImpl.getDefaultLogger().log(Level.FINE, "Legacy decryption failed", throwable);
            return null;
        }
    }

    private static class RepConversion {
        private RepConversion() {
        }

        private static byte nibbleToHex(byte by) {
            return (byte)((by = (byte)(by & 0xF)) < 10 ? by + 48 : by - 10 + 65);
        }

        private static String bArray2String(byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append((char)RepConversion.nibbleToHex((byte)((byArray[i] & 0xF0) >> 4)));
                stringBuffer.append((char)RepConversion.nibbleToHex((byte)(byArray[i] & 0xF)));
            }
            return stringBuffer.toString();
        }

        private static int convertCharToInt(char c) {
            switch (c) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': 
                case 'a': {
                    return 10;
                }
                case 'B': 
                case 'b': {
                    return 11;
                }
                case 'C': 
                case 'c': {
                    return 12;
                }
                case 'D': 
                case 'd': {
                    return 13;
                }
                case 'E': 
                case 'e': {
                    return 14;
                }
                case 'F': 
                case 'f': {
                    return 15;
                }
            }
            return 48;
        }

        private static byte[] convertHexStringToByte(String string) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                int n = RepConversion.convertCharToInt(string.charAt(i));
                Integer n2 = new Integer(0xF0 & n << 4);
                byArray[i / 2] = n2.byteValue();
                n = RepConversion.convertCharToInt(string.charAt(i + 1));
                n2 = new Integer(0xF & n);
                int n3 = i / 2;
                byArray[n3] = (byte)(byArray[n3] | n2.byteValue());
            }
            return byArray;
        }
    }
}

